﻿#pragma TextEncoding="UTF-8"
#pragma rtGlobals=3
#pragma ModuleName=StackTraces
#pragma version=1.2

#include <Readback ModifyStr>
// includes functions to align, reorder and offset traces using trace and
// graphpopup menus.
// not tested extensively, probably many ways for this code to fail.
// https://www.wavemetrics.com/user/tony

// edit this list if you work with traces that should be ignored
static strconstant ksIgnoreList = "w_base;MQP_*;" // list of traces to ignore, wildcards okay

menu "TracePopup", dynamic
	submenu "Stack spectra"
		StackTraces#SaveMenuPosition("Align Traces Here"), /Q, StackTraces#alignTraces()
		StackTraces#SaveMenuPosition("Reorder Traces at Point Value"), /Q, StackTraces#orderTraces()
		"Stack Aligned Traces", /Q, StackTraces#stackAlignedSpectra()
		"Stack Traces Equal Gap", /Q, StackTraces#stackSpectra(2)
		"Stack Traces Equal Offset", /Q, StackTraces#stackSpectra(1)
		"Add offsets...", /Q, StackTraces#AddOffsets()
	end
end

menu "AllTracesPopup"
	"Offset traces...", /Q, StackTraces#AddOffsets()
end

menu "Graph"
	submenu "Packages"
		"Add offsets...", /Q, StackTraces#AddOffsets()
		"Stack Traces Equal Gap", /Q, StackTraces#stackSpectra(2)
		"Stack Traces Equal Offset", /Q, StackTraces#stackSpectra(1)
	end
end

menu "GraphPopup"
	submenu "Stack Traces"
		"Aligned", /Q, StackTraces#stackAlignedSpectra()
		"Equal Gap", /Q, StackTraces#stackSpectra(2)
		"Equal Offset", /Q, StackTraces#stackSpectra(1)
	end
end

// Use to create a menu item in a popup when you need to
// know where the user clicks to invoke the popup.
static function /S SaveMenuPosition(string s_menu)
	if (WinType("") != 1)
		return "" // don't create variables if Igor is just rebuilding the menu
	endif
	GetMouse /W=kwTopWin
	if (V_left<0 || V_top<0)
		return ""
	endif
	variable /G V_MenuX = V_left, V_MenuY = V_top
	return s_menu
end

// use trace popup to align traces at this x position by setting offsets
static function alignTraces()
	
	// figure out graph and trace names
	GetLastUserMenuInfo	
	NVAR x_pixel = v_menuX
	NVAR y_pixel = v_menuY
		
	string s_info = TraceInfo(S_graphName, S_traceName, 0)
	variable x_pos = AxisValFromPixel(S_graphName, StringByKey("XAXIS",s_info) , x_pixel)
	variable y_pos = AxisValFromPixel(S_graphName, StringByKey("YAXIS",s_info) , y_pixel)

	variable v_offset, i
	
	string traces = TraceNameList("",";",1)
	traces = RemoveFromListWC(traces, ksIgnoreList)
	string traceName
	variable numTraces = itemsinlist(traces)
	
	for(i=0;i<numTraces;i+=1)
		traceName = StringFromList(i,traces)		
		wave w = TraceNameToWaveRef("", traceName)
		wave /Z w_x = XWaveRefFromTrace("", traceName)	
		if(WaveExists(w_x))
			FindLevel /P/Q w_x, x_pos
			if(v_flag)
				continue
			endif
			v_offset = y_pos - w[v_levelX]
		else
			v_offset = y_pos - w(x_pos)
		endif
		ModifyGraph offset($traceName)={0,v_offset}
	endfor
end

// reorder traces based on (possibly offset) value at x=xpos
static function orderTraces()
	
	// figure out graph and trace names
	GetLastUserMenuInfo	
	NVAR x_pixel = v_menuX
	
	string s_info = TraceInfo(S_graphName, S_traceName, 0)
	variable x_pos = AxisValFromPixel(S_graphName, StringByKey("XAXIS",s_info), x_pixel)
		
	string traces = TraceNameList("",";",1)
	traces = RemoveFromListWC(traces, ksIgnoreList)
	variable i = 0, numTraces = ItemsInList(traces)
	
	Make /T/free/N=(numTraces) w_traces
	Make /free/N=(numTraces) w_order//, w_offsets
	
	w_traces = StringFromList(p,traces)
	w_order = getOffset(S_graphName, w_traces, 1)
	
	for(i=0;i<numTraces;i+=1)
		wave w = TraceNameToWaveRef("", w_traces[i])
		wave /Z w_x = XWaveRefFromTrace("", w_traces[i])
		if(WaveExists(w_x))
			FindLevel /P/Q w_x, x_pos
			if(v_flag)
				continue
			endif
			w_order[i] += w[v_levelX]
		else
			w_order[i] += w(x_pos)
		endif
	endfor
	
	Sort w_order,w_order,w_traces
		
	for(i=0;i<numpnts(w_traces);i+=1)
		ReorderTraces _front_, {$w_traces[i]}
	endfor
end
	
// spread (possibly offset) spectra over Y axis range
// traces are stacked in the order of plotting
// designed to stack traces that are vertically aligned
// offset additions will be made with equal increments
static function stackAlignedSpectra()
			
	variable i = 0, v_high = -Inf, v_low = Inf, v_offset
	string traces = TraceNameList("",";",1)
	traces = RemoveFromListWC(traces, ksIgnoreList)
	
	Make /T/free/N=(ItemsInList(traces)) w_traces
	Make /free/N=(ItemsInList(traces)) w_offsets
	
	w_traces = StringFromList(p,traces)	
	w_offsets = getOffset("", w_traces[p], 1)

	variable traceNum
	for (i=0;i<2;i+=1)
		traceNum = (numpnts(w_traces) - 1) * i // loop through first and last trace
		wave w = TraceNameToWaveRef("", w_traces[traceNum])
		wave /Z w_x = XWaveRefFromTrace("", w_traces[traceNum])
		GetAxis /Q bottom
		
		if(WaveExists(w_x))
			FindLevel /Q w_x, v_min // no /P flag here - assumes same x-scaling for w and w_x
			if(v_flag)
				v_min = 0
			else
				v_min = V_LevelX
			endif
			FindLevel /Q w_x, v_max
			if(v_flag)
				v_max = numpnts(w)
			else
				v_max = V_LevelX
			endif
		endif
		if (i) // last trace: figure out max value
			v_high = max(v_high, WaveMax(w, v_min, v_max) + w_offsets[traceNum])
		else
			v_low = min(v_low, WaveMin(w, v_min, v_max) + w_offsets[traceNum])
		endif
	endfor

	GetAxis /Q left
	variable bottomGap = v_low - v_min, topGap = v_max - v_high
//	if((topGap+bottomGap)<0)
//		return 0
//	endif
	variable v_offsetincrement = (topGap + bottomGap) / (numpnts(w_traces) - 1)
	
	// apply offsets
	for (i=0;i<numpnts(w_traces);i+=1)
		ModifyGraph offset($w_traces[i])={0,w_offsets[i]-bottomGap+v_offsetincrement*i}
	endfor
end

// assumes traces are plotted using left and bottom axes
// gap is defined as distance between highest value of spectrum n and
// lowest value of spectrum n+1
// option = 1: equal increment, 2: equal space
static function stackSpectra(variable option)
	string traces=TraceNameList("",";",1)
	traces = RemoveFromListWC(traces, ksIgnoreList)
	variable i = 0, v_high = -Inf, v_low = Inf, v_offset
	variable numTraces = ItemsInList(traces)
	
	Make /T/free/N=(numTraces) w_traces
	Make /free/wave/N=(numTraces) w_waves
	Make /free/N=(numTraces) w_xMin, w_xMax, w_low, w_high, w_range
	
	w_traces = StringFromList(p,traces)
	w_waves = TraceNameToWaveRef("",w_traces)
	setMinMax(w_xMin, w_xMax, w_traces) // x-wave aware
	w_low = WaveMin(w_waves[p], w_xMin[p], w_xMax[p])
	w_high = WaveMax(w_waves[p], w_xMin[p], w_xMax[p])
	w_range = w_high[p]-w_low[p]
	
	GetAxis /Q left
	variable yAxMin = v_min, yAxMax = v_max, yAxRange = (v_max-v_min)
	variable dataRange = sum(w_range)
	variable gap
	if(option == 2) // equal gaps
		gap = (yAxRange-dataRange)/(numTraces-1)
		// gap between each trace
	else
		gap = (yAxRange-w_range[numTraces-1])/(numTraces-1)
		// offset between each trace
	endif
	
	// first trace
	v_offset = yAxMin - w_low[0] // add this to bring first trace down to bottom
	ModifyGraph offset($w_traces[0])={0,v_offset}
	w_high[0] += v_offset; w_low[0] += v_offset
		
	for (i=1;i<numTraces;i+=1)
		if(option == 2)
			v_offset = w_high[i-1] - w_low[i] + gap
		else
			v_offset = w_low[i-1] - w_low[i] + gap
		endif
		ModifyGraph offset($w_traces[i])={0,v_offset}
		w_high[i] += v_offset; w_low[i] += v_offset
	endfor
end

// figure out plotted x-range for each trace and fill values of w_xMin, w_xMax
static function setMinMax(wave w_xMin, wave w_xMax, wave /T w_traces)
	
	variable numTraces = numpnts(w_traces)
	variable i
	
	for (i=0; i<numTraces;i+=1)
		wave w = TraceNameToWaveRef("", w_traces[i] )
		wave /Z w_x = XWaveRefFromTrace("", w_traces[i] )
		GetAxis /Q bottom
	
		if(WaveExists(w_x))
			FindLevel /Q w_x, v_min // no /P flag here - assumes same x-scaling for w and w_x
			if(v_flag)
				v_min = 0
			else
				v_min = V_LevelX
			endif
			FindLevel /Q w_x, v_max
			if(v_flag)
				v_max = numpnts(w)
			else
				v_max = V_LevelX
			endif
		endif
		
		w_xMin[i] = v_min
		w_xMax[i] = v_max
	endfor
	return 1
end

// Adds y offsets to the waves in the open graph
// User chooses a fixed increment for offsets
// Offset is added to any existing y offset
static function addOffsets()

	variable verbose = 1
	variable offsetIncrement = 0.5
	
	Prompt offsetIncrement, "Offset increment"
	DoPrompt "Add Offset to Traces", offsetIncrement
	if (V_flag)
		return 0
	endif
	
	string traces = TraceNameList("",";",1) // Traces in top graph
	traces = RemoveFromListWC(traces, ksIgnoreList)
	Make /T/free/N=(ItemsInList(traces)) w_traces
	Make /free/N=(ItemsInList(traces),2) w_offsets
	
	w_traces = StringFromList(p,traces)
	w_offsets[][] = getOffset("", w_traces[p], q)
	w_offsets[][1] += offsetIncrement*p
	string traceName
	variable i = 0, numTraces = ItemsInList(traces)
		
	for(i=0;i<numTraces;i+=1)
		traceName = StringFromList(i,traces)
		ModifyGraph offset($traceName)={w_offsets[i][0],w_offsets[i][1]}
		if (verbose)
			printf "•ModifyGraph offset(%s)={%g,%g}\r", traceName, w_offsets[i][0], w_offsets[i][1]
		endif
	endfor
end

// applies offset from one wave to another - called from Match Offset trace menu
static function TraceSetOffset()	
	// figure out trace names
	GetLastUserMenuInfo // sets s_tracename, v_value
	string strTrace = S_traceName
	string strOffsetTrace = StringFromList(v_value, TraceNameList("",";",1))
	variable xOff, yOff
	sscanf ListMatch(TraceInfo(S_graphName,strOffsetTrace,0), "offset(x)=*"), "offset(x)={%g,%g}", xOff, yOff	
	ModifyGraph offset($strTrace)={xOff,yOff}
end

// returns listStr, purged of any items that match an item in ZapListStr.
// Wildcards okay! Case insensitive.
static function /S RemoveFromListWC(string listStr, string zapListStr)
	string removeStr=""
	variable i
	for(i=0;i<ItemsInList(zapListStr);i+=1)
		removeStr += ListMatch(listStr, StringFromList(i, zapListStr))
	endfor
	return RemoveFromList(removeStr, listStr, ";", 0)
end

static function getOffset(string graph, string trace, int axis)
	string s = ListMatch(TraceInfo(graph,trace,0), "offset(x)=*")
	variable xoffset, yoffset
	sscanf s, "offset(x)={%g,%g}", xoffset, yoffset
	return axis ? yoffset : xoffset
end