%%
X = readmatrix("X.txt");
Y = readmatrix("Y.txt");
Z = readmatrix("Z.txt");
X2 = 0.8*X + Y;
Y2 = -X/0.8 + Y;


%%
fig1 = figure('Color','w','Units','inches','Position',[1 1 6 4]);
ax1 = axes(fig1);
pcolorplot1 = pcolor(ax1, X, Y, Z);
shading(ax1, 'flat');
set(pcolorplot1, 'EdgeColor', 'none');

colormap(ax1, parula(256));
cb1 = colorbar(ax1);
cb1.Label.String = 'Z (\Omega)'; 

xlabel(ax1, 'X (V)', 'FontSize', 11);
ylabel(ax1, 'Y (V)', 'FontSize', 11);
ax1.FontSize = 10;
ax1.LineWidth = 0.8;
axis(ax1, 'tight');
box(ax1, 'on');
cb1.Ticks = linspace(ax1.CLim(1), ax1.CLim(2), 5);
ax1.TickDir = 'out';
ax1.Layer = 'top';
exportgraphics(fig1, "matlabpcolor_1.png", 'Resolution', 300);


%%
fig2 = figure('Color','w','Units','inches','Position',[1 1 6 4]);
ax2 = axes(fig2);
pcolorplot2 = pcolor(ax2, X2, Y2, Z);
shading(ax2, 'flat');
set(pcolorplot2, 'EdgeColor', 'none');

colormap(ax2, parula(256));
cb2 = colorbar(ax2);
cb2.Label.String = 'Z (\Omega)'; 

xlabel(ax2, 'X (V)', 'FontSize', 11);
ylabel(ax2, 'Y (V)', 'FontSize', 11);
ax2.FontSize = 10;
ax2.LineWidth = 0.8;
axis(ax2, 'tight');
box(ax2, 'on');
cb2.Ticks = linspace(ax2.CLim(1), ax2.CLim(2), 5);
ax2.TickDir = 'out';
ax2.Layer = 'top';
exportgraphics(fig2, "matlabpcolor_2.png", 'Resolution', 300);