import matplotlib.pyplot as plt
import numpy as np

def setup_axis_style(ax, cb, title_z):
    ax.set_xlabel('X (V)', fontsize=11)
    ax.set_ylabel('Y (V)', fontsize=11)
    
    ax.tick_params(axis='both', which='major', labelsize=10, direction='out')
    
    for spine in ax.spines.values():
        spine.set_linewidth(0.8)

    ax.autoscale(enable=True, axis='both', tight=True)
    
    ax.set_axisbelow(False)

    cb.set_label(title_z, fontsize=11)
    
    vmin, vmax = cb.mappable.get_clim()
    cb.set_ticks(np.linspace(vmin, vmax, 5))
    
    cb.ax.tick_params(labelsize=10)



X = np.loadtxt("X.txt")
Y = np.loadtxt("Y.txt")
Z = np.loadtxt("Z.txt")
X2 = 0.8*X + Y
Y2 = -X/0.8 + Y

fig1, ax1 = plt.subplots(figsize=(6, 4), dpi=100)

pcm1 = ax1.pcolormesh(X, Y, Z, shading='auto', cmap='viridis', rasterized=True)
cb1 = fig1.colorbar(pcm1, ax=ax1)

setup_axis_style(ax1, cb1, r'Z ($\Omega$)')

fig1.savefig("matplotlibpcolor_1.png", dpi=300, bbox_inches='tight')
fig2, ax2 = plt.subplots(figsize=(6, 4), dpi=100)

pcm2 = ax2.pcolormesh(X2, Y2, Z, shading='auto', cmap='viridis', rasterized=True)
cb2 = fig2.colorbar(pcm2, ax=ax2)

setup_axis_style(ax2, cb2, r'Z ($\Omega$)')

fig2.savefig("matplotlibpcolor_2.png", dpi=300, bbox_inches='tight')

