// Code Developer Panel
// Jeffrey J Weimer
// SVN History: $Revision: 623 $ on $Date: 2008-03-24 16:31:39 -0400 (Mon, 24 Mar 2008) $

#pragma rtGlobals=1
#pragma version = 1.20
#pragma ModuleName=DeveloperPanel

#include "ScreenSizer", version > 1.10
#include "CodeDeveloperPanel.lcl"

Menu "Misc", hideable
	Submenu "Panels"
		"Code Developer Panel",/Q,DeveloperPanel#Show()
	end
End

// Initialize Stuff

Static Function InitializeStructure(sDP)
	STRUCT DeveloperPanelStructure &sDP
	sDP.MyCPackages = CDP_CoderPackages
	sDP.MyUPackages = CDP_UserPackages
	sDP.ph = CDP_height
	sDP.pw = 240
end

Static STRUCTURE DeveloperPanelStructure
	string MyCPackages
	string MyUPackages
	variable ph
	variable pw
ENDSTRUCTURE

// Show the Panel

Function Show()

	if (strlen(WinList("DP_Panel","","WIN:64"))!=0)
		DoWindow/F DP_Panel
		return 0
	endif
	
	string cdf = GetDataFolder(1)
	NewDataFolder/O/S root:Packages
	NewDataFolder/O/S DeveloperPanel
	
	STRUCT DeveloperPanelStructure sDP
	InitializeStructure(sDP)
	
	if (sDP.ph<120)
		sDP.ph=120
	endif
	
	variable nitems, ic
	nitems = ItemsInList(sDP.MyCPackages)
	make/T/O/N=(nitems) Cpackages
	make/O/N=(nitems) CpackageSEL=32
	for (ic=0;ic<nitems;ic+=1)
		Cpackages[ic] = StringFromList(ic,sDP.MyCPackages)
	endfor
	nitems = ItemsInList(sDP.MyUPackages)
	make/T/O/N=(nitems) Upackages
	make/O/N=(nitems) UpackageSEL=32
	for (ic=0;ic<nitems;ic+=1)
		Upackages[ic] = StringFromList(ic,sDP.MyCPackages)
	endfor
	SetDataFolder $cdf

#if (exists("ScreenSizer#Initialize")==6)	
	ScreenSizer#Initialize(0)
	ScreenSizer#MakePanel(-95,0,sDP.pw,sDP.ph,"Developer Panel",other="/K=1/N=DP_Panel")
#else
	NewPanel/W=(0,0,sDP.pw,sDP.ph)/K=1/N=DP_Panel as "Developer Panel"
#endif
//	ModifyPanel fixedSize=1, noEdit=1
	
	variable lh, lw
	
	lh = sDP.ph - 80
	lw = sDP.pw - 10
	
	// package list
	ListBox list0 mode=0,font="default", listwave=Cpackages, selwave=CpackageSEL
	ListBox list0 pos={5,30},size={lw,lh},frame=0,font="default", proc=TogglePackage
	PopupMenu mode title="Mode",pos={5,5},value="Coder;User;", mode=1,proc=ToggleMode
	// show/hide localization
	CheckBox check3,pos={120,7},size={165,15},title="Show Localization"
	CheckBox check3, value= 0, proc=ShowLocalization
	// insert with/without compile
	CheckBox check0,pos={5,lh+40},size={165,15},title="Compile After Insert"
	CheckBox check0,value= 1
	// independent module development
	CheckBox check1,pos={5,lh+60},size={165,15},title="Indepent Module Development"
	CheckBox check1,value= 0,proc=SetIMDevelopment
	// save experiment button
	Button saveX,pos={190,lh+40},picture=DeveloperPanel#SaveXButton
	Button saveX, proc=SaveThisExperiment, title=""
	string exeStr
	sprintf exeStr, "SetIgorOption IndependentModuleDev = %g", 0
	Execute exeStr
	ToggleMeInvisible(1)
	ToggleLocalInvisible(1)		
	return 0
end

// Control Support Functions Below Here

Function ToggleMode(pa) : PopupMenuControl
	STRUCT WMPopupAction &pa

	wave/T lCwave = root:Packages:DeveloperPanel:Cpackages
	wave/T lUwave = root:Packages:DeveloperPanel:Upackages
	wave sCwave = root:Packages:DeveloperPanel:CpackageSEL
	wave sUwave = root:Packages:DeveloperPanel:UpackageSEL

	variable nitems, ic

	switch( pa.eventCode )
		case 2: // mouse up
			switch(pa.popNum)
				case 1:
					Checkbox check1, disable = 0
					ListBox list0 mode=0, listwave=lCwave, selwave=sCwave
					break
				case 2:
					Checkbox check1, disable = 1
					ListBox list0 mode=0, listwave=lUwave, selwave=sUwave
					break
			endswitch
			break
	endswitch

	return 0
End

Function SaveThisExperiment(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			SaveExperiment
			break
	endswitch

	return 0
End

Function SetIMDevelopment(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	string exeStr = ""
	switch( cba.eventCode )
		case 2:
			sprintf exeStr, "SetIgorOption IndependentModuleDev = %g", cba.checked
			Execute exeStr			
			break
	endswitch

	return 0
End

Function TogglePackage(lba) : ListBoxControl
	STRUCT WMListboxAction &lba

	Variable row = lba.row
	WAVE/T/Z listWave = lba.listWave
	WAVE/Z selWave = lba.selWave

	switch( lba.eventCode )
		case 2:
			variable nitems = numpnts(listWave) - 1
			if (row>nitems)
				break
			endif
			LoadUnloadPackage(listWave[row], selWave[row])
			break
	endswitch

	return 0
End

Function ToggleMeInvisible(how)
	variable how

	string IgorProcPathStr, filePath
	PathInfo Igor
	IgorProcPathStr = S_path + "User Procedures:CodeDeveloperPanel:"
	NewPath/O/Q/Z CDP_ProcPath IgorProcPathStr
	filePath="CodeDeveloperPanel.ipf"
	GetFileFolderInfo/Q/P=CDP_ProcPath filePath
	if (V_flag==0)
		SetFileFolderInfo/P=CDP_ProcPath/INV=(how)/RO=(how) filePath
	endif
	KillPath/Z CDP_ProcPath
	return 0
end

Function ShowLocalization(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			if (cba.checked)
				DoAlert 0, "Localization will reappear after a restart of Igor Pro"
			else
				DoAlert 0, "Localization will disappear after a restart of Igor Pro"
			endif
			ToggleLocalInvisible(!cba.checked)
			break
	endswitch

	return 0
End

Function ToggleLocalInvisible(how)
	variable how

	string IgorProcPathStr, filePath
	PathInfo Igor
	IgorProcPathStr = S_path + "User Procedures:CodeDeveloperPanel:"
	NewPath/O/Q/Z CDP_ProcPath IgorProcPathStr
	filePath="CodeDeveloperPanel.lcl.ipf"
	GetFileFolderInfo/Q/P=CDP_ProcPath filePath
	if (V_flag==0)
		SetFileFolderInfo/P=CDP_ProcPath/INV=(how)/RO=(how) filePath
	endif
	KillPath/Z CDP_ProcPath
	return 0
end

Static Function LoadUnloadPackage(itsName,itsValue)
	string itsName
	variable itsValue
	
	string exeCmd=""
	if (itsValue == 32)
//		print "unloading"
		exeCmd = "DELETEINCLUDE \"" + itsName +"\""
	else
//		print "loading"
		exeCmd = "INSERTINCLUDE \"" + itsName +"\""
	endif
	Execute/P/Q/Z exeCmd
	ControlInfo check0
	if (V_Value || (itsValue ==32))
		Execute/P/Q/Z "COMPILEPROCEDURES"
	endif
	return 0
	
end

// PNG: width= 125, height= 39
Static Picture SaveXButton
	ASCII85Begin
	M,6r;%14!\!!!!.8Ou6I!!!"A!!!!E#R18/!4UO%mJm4e"EQn$<!Wa8#^cngL]@DT$#iF<ErZ1Lf)P
	d[f)\2dRs4o5!#]lI=EIJ[Aor6*Eb,5pGBYZRDJO<'@;od1DfTK[mQ;Bf!"CeW6pXdsSB[PLD]D8ja
	$3SS^SaT_L_NPr+De1=!&D2"TY88J/-A1]Y6bVI04#cV`<*Rr^gccST-.N[6&rJZJYhCEYRki:J-E$
	./R+)Ib;)aa'J3N/H@GN\GLt$3VgE#H%`K;W'YcnCHE-:4f=0V;pKgk#CY,]q-P5a[pE$e]h>5/7#_
	(bmc=t==>X/<<V:9MY778EIF31^=<D#D/`dF$sM<Xd3%pH)9gKL'fB7CE/V+[.oTGYJ.KI^-,!"_TH
	:HZt8i-F00>3eFhXT1cM=@iZA9iKGC-e@!gXYn+ck.,Qr*c%mCj#G*7SV(qTl;[gZ7W5.hCOOnRZg,
	-iRasM>PL*e_<CFiE77<q1(^q+_WO5J$F'O-]"Vn#=<pO>jj$5#h>c!Z<,,)EQ,5&oJW^<ZsWFP30&
	b,m'6o:RJh(Dms(YbJuEM?#.PdOP'=f*Sm6311=b)1_.#$ratXCEbY?=b-G4iK9%WFT.$Q=WZVeG,K
	hl#`Ne'q[]c1oVZcT'$)UCCq-]Ydl()/6O=\\Y&rC;7NbM&mLGQ^#$&4+j5NiZ[cGB_K?<JUX<7>OI
	G>m=dB(^87ndK+\bakSHOn6HHZTTOc\b:;G&AM;:\o^X]6Q!89<>IA[FNZrI0dS:l?<.2.qm#!or`,
	8WqHh><8=6DDsr$iqo0(FpUMPf:<V&CMhUo4O:)-jE[n5f2XS4q+J_+8c?-u][-W7pmQsK>?no?f5i
	fio4H,es*,?1\)719%mKbrjuQ*`c)i9d/aZ<QpHK("[kiD5@@%\"DfAu>I$]t!*f!W#CB\LIh\Va+N
	$hC6Z7I5\%G"^A;/#?i[B:d()J>)j*;JmXs6DjmY&CVVg#VnBIs^>P"o-8J')qBUqZ+;#cM,!Orqf2
	8=-7g]@_]AF1Kpom>e"`]Y0M/NpUP;(YGg(=gpll/^\m3[L4rM4,m#K8$V=_#Z'DZMb_\YR]rk0k30
	&VG#EpV]6W-G>4@u4!Zm84<RL2pQ;Qgo(N6d9)1tgU:7G@//j8A`E1RA8Y\*nD:3n3I)Y$\rc&NMuq
	om;e-bZ_`j1eLn=+O=IMJGqgm3X3Mg)],Uc=plNt?X)X*ed>n$8m/5Q$jN/,:Z6RfS^nQ7=j^PQ[[[
	nU@>q1W^M"V;+.eD?cT_5b,Y>!kj1j[Z&B?N/^]+'cOZHh3\9/,cOn-qnFB,N#@')Sr]l@+T.1I,qe
	`=9\=t%%[aYq3:nLXJ-dn`PuA1BTNH5MCLn\uMh[rWhf],,D!p"#)H9Ff(DIU+hH)O)8*;(u8*X\b:
	@A$)l_lTl0p1m<Mk:56H8mO.[1,]\&c4C;o</kNa)q_l,oDlSJVpMh0op?^I\m_r&X.XY#teYi/KV3
	iOp0T>n8@kCN?\=ZI60If([DQguR1R&BdSND&Zom6M`pI]>:?K^\.Zg8Fj(TMrAI.PT-k8i,;q/=P9
	'oDuYoj@*cH_62P/"uhfi3]qMolRR<>&0a5;U:mq2g<qX0UMVfBA><M/cXGgF^BLheU7NZ93WY$7Up
	;/:A#Z"72QXu.G;TD_g9>ge&0:9pK>!PTis\\20H*u:6W=g;Wl#(OuhofRofRVbs,B1LP1\-C+UPS@
	2^O'V%GF+j)#Tc(P^L/CGW)lV=f0L4KG9l;"Zn#SqltHTE217-*\R<bCm^IOsCgh1H8-Dftt7pMF^a
	Eh\VHo1)L;780m:"(eO$arG&G^1sAN!if@S%ofG7t;nlnX8N4S^[&V&/cQPk2]=TM#0VI<i+fXfW42
	1"^rP#,]9PLmiqL)Q[>8g%f\MRK*niT,@@UHA4)hoN&0E7G0UUDiUe*c\]r;kfZ+.24>R&ErM7Z7CG
	j>ljZQH,%bdX`U";I!9t"SP>8;l[W%^RrtmBC+u\F?2EcQVf$9LY0^4m-VD>k0Wi/!f+scs31%SI;5
	@e.+R[T4-']cG[L;GbEk.`)sE9@%DMWB^A6p4I2g':Si?L)YPM6+ZlN)[8n2p2Y:$,uN,D,k!eoed*
	2b&_`i`e<*=OLTDGI*ne*C0->R3]OC[3sb\sa?))G1qfBA)'nc-;Z7!b_5;2+PJflIXaCQ'Gg<0uf;
	d)+g!Q,RJ1RiVO[fkOIIr6Dmau="Q!Ui=23G7r9]W6"IiD;&%ER/C!E,_P!MV(f1f[$lC4&D:,p;-I
	3DuP1+4Wf\Odh$j=U*\?;e>WKB9K?i<0XmEoEh)8O46+\gF#gp/IU#Qc!d@;@Beh(H_7baE#^-_.0$
	\I>>%mEbUQDuOo(/^(`4>.Z1/`,W`[du4.h=8uPhO5m_oFWO*p"UJr+d\,+:nl<Z#W8ne*EL\em.l`
	P#"G6)X>h:,n'mVE6S'p]t)%==T?1NB=%JEu?LCrg_mZHC>C[2JFrq5/BUnqdpG.Rog`,V>;A!%9dr
	6rToea$Yoekn-1op]NMhu<<f@2SS']+M6[p&h^+NV2se<`^*jf[uQpG+LQkX29Qfj$l`4Zr!o*GVCM
	g8l[BdSe)$Z`C5P1EZ#9BBdsrEjEVp%`or88;n8bHUjbtES>PO=I/0^3;u#2;reDU%\TB:Y[F]R-_i
	WF!<S#_2+1J"SDX5no>f&0?MB]XfDFNdcqYF,P2N.7?5JWs#@Z*H>7Zh/p<UB4.6=J+Sl;SFOL4of'
	H9ENF'[:6Mj+)q+#4_)J0m1!uqQ+XALEHj/Jq-lPW<h>4fQ]$%_D=aJGMdg='Lhf2cf1\>qKb7iBXc
	`e>'Bm!+i?j4XsA/6@2Y5mA$*^i1p1U"!fo=$3-D5jXl]^$a6AQe6q0XFfiB8m#@"ri@>pUG+L\_m-
	O9d*+J@,$=C$n6#]7'*;p2oEi'Xi]KCA]Tc3:;QT:$hoH'(-"p/;;UN569E(f4+86ZTQB\?6BtMM24
	p7O)AN+X2pK>h;:-6'YNNddS_596lL%+,\/a'>$KTJp)L=,'A/kA7K+pK$],Orj-'Op&!d1&%QrT%#
	m`lKa[ba9p0%%fm1'`(p7Mk-lf"%?#UgB0nk0h[)MWi3*%R](f$^s=Bb9pf6poU!.qTr+rSB+Y,h&?
	n2s_#jf79:QB>c-&&7f7I<rRJH(O%UcJ7Kh>*$1<EKTAEOIuMo5G<jlgJMr98_r+sR'j>o9r'?oqj]
	km+"3gSP0i[lVq*f-oiqDFV%=*=@gE0(>VjmqR^B78GR@phE=@h]@VNr^dI:7?E:A8Z=Rs+$c`RXql
	u;g.8&#R#i3KlV&BBMZ1rI4H7@Z;2;qgUs4$,NG]3UXN[M6oPY;'X(r-)rB->RB5-dinBLNDY<"!t<
	rDl2L(WS`4(kBHb!CL?]+f,n(.^(4'Td;1^T2OiL9IJ^gclg(>CG5EoZG&d$<0N+YoihMPuRcm[aEM
	=-O_=J*.f]C=t8=j#EcnH<t30#;BKZ-C)_Lb:kmT1b<LMe`YDcg6Qf[paM[=C(;f/5*1\?)ifS3#cj
	H%f4qC!,l3/rq&:io.e1,Y:>)<b#]PKmLF=*FCr8s7/sPpq&ch#P[]EXO;\#Jfq#3mFJCD#F6C>QeL
	j([+k>#kFM(>[KT+<YP_Ye8F#s7eUKQc_J/f@cY(EC"MqgZ8P<#+7cAV&ost[.L]W@W8kPCPN"J0J&
	OhR*1;i%aWA_Aj'o_[%*1o3ndHfoT3>eLs!f'^P>S\(V>Z[,#"ehETS(tW"O3PpDXL5.4XqHI4@9E;
	bH(Ifse14TaS8A7\pr+mub?st>`/-MKlhg[q1o6Fq?WDX6;5d=M3Y$/rOf!<3f*]NVf#Am60cn\s0G
	J7ZU!Y:*K8&'tn0#3[EAZ7DZs#%&4F"XX?[T]WgUCa@HWt6mRKPo!rI/+T[A('p+:.%>T(tMt+E8Sr
	ou7*O@h=cN(Jp6lFg:o\c_rDJnga3*OpZg(NDA`)FHkJL4JgNkZG!rrQX>3`kF[7L]mKM;F?6M)XH7
	#HK\F\VCo0AGkD<mbVIS>+RuYB%Iqu/s=XM-*&J5oLA%=NZ3o=/=_^oh,7#[#Hg70E[f\LDM[C*u_h
	gWc/a,fJ,3Wb-+qr52iGb-;%8IYLE`pL!liCfHcVp4]^bL/4Aqb!jEcsNn5<i;M+SJS-gdd-SiF?9&
	?4fl%Z;8gW"MKk^?CMR_!V5:#;X]A)S0ii'A`g@uTV9]NFHZ'-Y+8Hs:8h5*(PYt<J4F`TmW@4Tp,"
	]JP:Dp:BUhP]aMC=@,jcrp:I@i>j`Uc2p>$=PLf@RJNNQ)XXo9)m5q'=kNfob=o5jE'23@F2Eno5LV
	^)F#^e&E5kTnL-.;FL^u$t0unk0+]jh^:u.XL7&5T%%M_FCAV:8\JI1C2Ih4KOHhO&NM:IP*brnGq\
	fRB,%.1z8OZBBY!QNJ
	ASCII85End
End
