// Link Display
// Jeffrey J Weimer
// SVN History: $Revision: 775 $ on $Date: 2008-05-23 10:15:44 -0500 (Fri, 23 May 2008) $

#pragma rtGlobals=1
#pragma IgorVersion=6.03
#pragma version = 0.20

//#pragma IndependentModule=LinkDisplay

Static StrConstant kLinkStart ="<link>"
Static StrConstant kLinkEnd = "</link>"
Static StrConstant kregEx = "<link>(.+)</link>"

// Link
// xwave: independent wave
// ywaveList: string list of dependent waves in current folder or via path

Function Link(xwave,ywaveList,[full])
	wave xwave
	string ywaveList
	variable full
	
	string theOne, itsNote, itsLink, xdf
	variable ic, nt
		
	if (!WaveExists(xwave))
		DoAlert 0, "No independent wave for linking!"
		return -1
	endif
	
	if (ParamIsDefault(full))
		full = 1
	endif
	
	if (cmpstr(GetDataFolder(1),GetWavesDataFolder(xwave,1))!=0)
		full = 1
	endif
	
	if (full)
		itsLink = GetWavesDataFolder(xwave,2)
	else
		itsLink = NameofWave(xwave)
	endif
	
	if (strlen(ywaveList)==0)
		ywaveList = RemoveFromList(NameofWave(xwave),WaveList("*",";",""))
	endif
	
	nt = ItemsInList(ywaveList)
	for (ic=0;ic<nt;ic+=1)
		theOne = StringFromList(ic,ywaveList)
		wave ywave = $theOne
		itsNote = note(ywave)
		SplitString/E=(kregEx) itsNote
		if (strlen(S_value)!=0)
			sprintf theOne, "%s%s%s", kLinkStart,itsLink,kLinkEnd
			itsNote = ReplaceString(S_value,itsNote,theOne)
		else
			sprintf itsNote, "%s%s%s\r%s", kLinkStart,itsLink,kLinkEnd,itsNote
		endif
		Note/K ywave, itsNote
	endfor
	return 0
end

// LDisplay
// ywaveList: string list of dependent waves in current folder or via path
// flags: string of flags to append to Display command
// title: string title for graph

Function LDisplay(ywaveList,[flags,title])
	string ywaveList, flags, title
	
	string theOne, itsNote, theXwave, theCmd
	variable ic, nt, na
		
	if (strlen(ywaveList)==0)
		ywaveList = WaveList("*",";","")
		ic = 0
		do
			theOne = StringFromList(ic,ywaveList)
			if (strlen(theOne)==0)
				break
			endif
			itsNote = note($theOne)
			SplitString/E=(kregEx) itsNote, theXwave
			if (strlen(S_Value)!=0)
				print theXWave, ywaveList
				ywaveList = RemoveFromList(NameofWave($theXwave),ywaveList)
				print ywaveList
				break
			endif
			ic+=1
		while(1)
	endif
	
	nt = ItemsInList(ywaveList)

	if (ParamIsDefault(flags))
		flags = ""
	endif
	
	for (ic=0;ic<nt;ic+=1)
		theOne = StringFromList(ic,ywaveList)
		itsNote = note($theOne)
		SplitString/E=(kregEx) itsNote, theXWave
		if (strlen(S_Value)!=0)
			if (ParamIsDefault(title))
				if (!WaveExists($theXWave))
					sprintf theCmd "Display%s %s", flags, theOne
				else
					sprintf theCmd "Display%s %s vs %s", flags, theOne, theXwave
				endif
			else
				if (!WaveExists($theXWave))
					sprintf theCmd "Display%s %s as \"%s\"", flags, theOne, title
				else
					sprintf theCmd "Display%s %s vs %s as \"%s\"", flags, theOne, theXwave, title
				endif
			endif
		else
			if (ParamIsDefault(title))
				sprintf theCmd, "Display%s %s", flags, theOne
			else
				sprintf theCmd "Display%s %s as \"%s\"" flags, theOne, title
			endif
		endif
		Execute/Q/Z theCmd
	endfor
	return 0
end

// LAppendToGraph
// ywaveList: string list of dependent waves in current folder or via path
// flags: string list of options to append to appendtograph command

Function LAppendToGraph(ywaveList,[flags])
	string ywaveList, flags

	string theOne, itsNote, theXwave, theCmd
	variable nt, ic

	if (ParamIsDefault(flags))
		flags = ""
	endif
	
	if (strlen(ywaveList)==0)
		ywaveList = WaveList("*",";","")
		ic = 0
		do
			theOne = StringFromList(ic,ywaveList)
			if (strlen(theOne)==0)
				break
			endif
			itsNote = note($theOne)
			SplitString/E=(kregEx) itsNote, theXwave
			if (strlen(S_Value)!=0)
				ywaveList = RemoveFromList(NameofWave($theXwave),ywaveList)
				break
			endif
			ic+=1
		while(1)
	endif
	
	nt = ItemsInList(ywaveList)
	for (ic=0;ic<nt;ic+=1)
		theOne = StringFromList(ic,ywaveList)
		itsNote = note($theOne)
		SplitString/E=(kregEx) itsNote, theXwave
		if (strlen(S_Value)!=0)
			if (!WaveExists($theXwave))
				sprintf theCmd,"appendtograph%s %s", flags, theOne
			else
				sprintf theCmd,"appendtograph%s %s vs %s", flags, theOne, theXwave
			endif
		else
			sprintf theCmd,"appendtograph%s %s", flags, theOne
		endif
		Execute/Z/Q theCmd
	endfor
	return 0
	
end
