// udFLPlugIn for Link Display
// Jeffrey J Weimer
// SVN History: $Revision: 842 $ on $Date: 2008-07-10 10:54:00 -0500 (Thu, 10 Jul 2008) $

#pragma rtGlobals=1
#pragma IgorVersion=6.03
#pragma version = 1.2

//#pragma ModuleName=LinkDisplay

#include "LinkDisplay"
#include "udFLStandardStructure"

// START OF PLUG-IN
// a plug-in for a user-defined file loader
// udFL.itLst.WAVES: string list of waves in current folder
// udFL.userCtrl
//	-1 = initialize
//	0 = query
//	1 = link first wave in list to all others
//	2 = link waves as pairs

Function udFLPlugInLinkDisplay(udFL)
	STRUCT udFLStandardStructure &udFL
	
	string theXOne, theYList
	variable nt, ic
	
	switch(udFL.userLCtrl)
		case -1:
		case 0:
			udFL.procModes += "Link All to 1st;Link as XY Pairs;"
			break
		default:
			switch(udFL.userPCtrl)
				case 1:
					theXOne = StringFromList(0,udFL.itLst.WAVES)
					wave xwave = $theXOne
					theYList = RemoveListItem(0,udFL.itLst.WAVES)
					LinkDisplay#link(xwave,theYList)
					break
				case 2:
					nt = ItemsInList(udFL.itLst.WAVES)
					for (ic=0;ic<nt;ic+=2)
						theXOne = StringFromList(ic,udFL.itLst.WAVES)
						wave xwave = $theXOne
						theYList = StringFromList(ic+1,udFL.itLst.WAVES)
						LinkDisplay#link(xwave,theYList)
					endfor
					break
			endswitch
			break
	endswitch
	return 0
end
>>>>>>> .merge-right.r841
