// Link VS
// $Author: Jeffrey J Weimer$
// SVN History: $Revision: 1454 $ on $Date: 2010-09-26 18:20:54 -0700 (Sun, 26 Sep 2010) $

#pragma rtGlobals=1
#pragma IgorVersion=6.20
#pragma version=1.5

#pragma IndependentModule=LinkVS

#include "LinkDisplay", version>=2.3

Static StrConstant thePackage="LinkVS"
//Static StrConstant thePackageFolder="root:Packages:LinkVS"	no actual data folder used
Static StrConstant theProcedureFile = "LinkVS.ipf"
Static StrConstant thePackageInfo = "A control panel to use the LinkDisplay functions"
Static StrConstant thePackageAuthor = "Jeffrey J Weimer"
Static Constant hasHelp = 1
Static Constant thePackageVersion = 1.5
Static Constant removable = 1

// Package Constants

// Menu

Menu "Misc", hideable
	Submenu "Panels"
		"LinkVS", /Q, MakeLinkVSPanel()
	end
end

// comment this to test development of the panel

#define NOTEST
Static StrConstant MTNest="--"
Static StrConstant NoFolders="You have no data folders!"

// Package Functions

// Setup LinkVS

Function SetupLinkVS()
	
	string theCmd
	sprintf theCmd, "ProcGlobal#PackageExists(\"%s\")", thePackage
	Execute/Q/Z theCmd
	NVAR V_exists
	if (NVAR_exists(V_exists))
		sprintf theCmd,"\"%s\"", thePackage
		sprintf theCmd, "%s,file=\"%s\"", theCmd, theProcedureFile
		sprintf theCmd, "%s,info=\"%s\"", theCmd, thePackageInfo
		sprintf theCmd "%s,author=\"%s\"", theCmd, thePackageAuthor
		sprintf theCmd, "%s,version=%f", theCmd, thePackageVersion
		sprintf theCmd, "%s,hasHelp=%d", theCmd, hasHelp
		switch(V_exists)
			case 0:
				sprintf theCmd, "ProcGlobal#PackageSetup(%s)", theCmd
				break
			case 1:
				sprintf theCmd, "ProcGlobal#PackageUpdate(%s)", theCmd
				break
		endswitch
		Execute/Q/Z theCmd
	endif
	return 0
end

// Make the Panel

Function MakeLinkVSPanel()

	string theTopFldr = StringFromList(0,ListofDataFolders())
	string theFirstWave = StringFromList(0,ListofWavesinFolder(theTopFldr))
	string GIMN = GetIndependentModuleName()
	string fldrList = GIMN + "#ListofDataFolders()"
	string wList = GIMN + "#ListofWavesinFolder(\""+ theTopFldr + "\")"
	string cdf
	
	if (WinType("LinkVS")==7)
		DoWindow/F LinkVS
		return 0
	endif

	NewPanel/W=(10,20,155,170)/K=1/N=LinkVS as "LinkVS"
#ifdef NOTEST
	ModifyPanel/W=LinkVS noEdit=1, fixedSize=1
#endif
	Execute/Z/Q "ProcGlobal#ScreenSizer#ShiftFrontWindow(-10,10)"
	cdf = GetDataFolder(0) +":"
	PopupMenu FolderList,pos={2,3},size={84,20},proc=ChangeFolder,title=cdf
	PopupMenu FolderList,font="Arial",fSize=12, mode=1,popvalue=theTopFldr,value= #fldrList

	PopupMenu XWave,pos={2,25},size={120,20},title="x"
	PopupMenu XWave,font="Arial",fSize=12,mode=1,popvalue=theFirstWave,value=#wList

	Button DoIt,pos={2,47},size={20,20},proc=DoIt,title="->",font="Arial",fSize=12

	PopupMenu Task,pos={28,47},size={86,20},font="Arial",fSize=12,proc=ChangeTask
	PopupMenu Task,mode=2,popvalue="AppendVS",value= #"\"DisplayVS;AppendVS;AppendVS*;\""

	SetVariable Title,pos={2,70},size={135,17},title="Title",font="Arial",fSize=12, value= _STR:""

	SetVariable DVSFlags,pos={2,90},size={130,17},title="DspFlags",font="Arial",fSize=12, value= _STR:""

	SetVariable AVSFlags,pos={2,110},size={130,17},title="AVSFlags",font="Arial",fSize=12, value= _STR:""

	CheckBox SetPrefs, pos={50,132},title="*",value=0
	
	Button Help,pos={80,128},size={20,20},proc=GetHelp,title="?",font="Arial", fSize=12

	Button RemoveMe,pos={105,128},size={20,20},title="X",font="Arial", fSize=12, proc=RemoveLinkVS

	string theV
	sprintf theV, "v %g", thePackageVersion
	SetDrawEnv fname= "Arial",fsize= 8
	DrawText 4,145, theV

	SetupLinkVS()
	return 0
End

// List of Data Folders
// removes Packages folder from list
// returns "--" as empty list

Function/S ListofDataFolders()

	string LoFldrs="", theOne, cdf
	variable ic = 0
	if (wintype("LinkVS")!=0)
		cdf=(GetDataFolder(0)+":")
		PopupMenu FolderList, title=cdf
	endif
	cdf = GetDataFolder(1)
	do
		theOne = GetIndexedObjName(cdf,4,ic)
		if (strlen(theOne)==0)
			break
		endif
		LoFldrs +=  PossiblyQuoteName(theOne) + ";"
		ic += 1
	while(1)
	
	LoFldrs = RemoveFromList("Packages",LoFldrs)
	
	if (strlen(LoFldrs)==0)
		LoFldrs = MTNest
	endif

	return LoFldrs
end

// List of Waves In Folder

Function/S ListofWavesInFolder(theFldr)
	string theFldr

	string LoWaves="", theOne
	variable ic = 0
	
//	theFldr = PossiblyQuoteName(GetDataFolder(1))
	
//	sprintf theFldr "root:%s", theFldr
	do
		theOne = GetIndexedObjName(theFldr,1,ic)
		if (strlen(theOne)==0)
			break
		endif
		LoWaves +=  theOne + ";"
		ic += 1
	while(1)
	
	if (strlen(LoWaves)==0)
		LoWaves = MTNest
	endif

	return LoWaves
end

// PopMenu Action to Change Folder

Function ChangeFolder(pa) : PopupMenuControl
	STRUCT WMPopupAction &pa

	switch( pa.eventCode )
		case 2: // mouse up
			string theCurrFldr = StringFromList(pa.popNum-1,ListofDataFolders())
//			string theCurrFldr = GetDataFolder(1)
			string theFirstWave = StringFromList(0,ListofWavesinFolder(theCurrFldr))
			string wList = GetIndependentModuleName() + "#ListofWavesinFolder(\""+ theCurrFldr + "\")"
			PopupMenu XWave mode=1, popValue=theFirstWave, value=#wList
			break
	endswitch

	return 0
End

// PopMenu Action to Change Task

Function ChangeTask(pa) : PopupMenuControl
	STRUCT WMPopupAction &pa

	switch( pa.eventCode )
		case 2: // mouse up
			Variable popNum = pa.popNum
			String popStr = pa.popStr
			switch(pa.popNum)
				// DisplayVS
				case 1:
					SetVariable DVSFlags,title="DVSFlags", value= _STR:""
					SetVariable AVSFlags,disable=1
					break
				// AppendVS or AppendVS*
				case 2:
				case 3:
					SetVariable DVSFlags,title="DspFlags", value= _STR:""
					SetVariable AVSFlags,disable=0
					break
			endswitch
			break
	endswitch

	return 0
End

// Button Action to Do It

Function DoIt(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2:
			string theTask, theFldr, theWave, title, DVSflags, AVSflags, theCmd, GIMN
			variable prefs
			ControlInfo FolderList
			if (cmpstr(S_value,MTNest)==0)
				DoAlert 0, NoFolders
				break
			endif
//			sprintf theFldr "root:%s" S_value
			theFldr = GetDataFolder(1)+S_value
			ControlInfo XWave
			if (cmpstr(S_value,MTNest)==0)
				break
			endif
			sprintf theWave, "%s:%s", theFldr, S_value
			ControlInfo Task
			theTask = S_Value
			ControlInfo Title
			title = S_value
			ControlInfo DVSFlags
			DVSflags = S_Value
			ControlInfo AVSFlags
			AVSflags = S_Value
			GIMN = GetIndependentModuleName()
			ControlInfo SetPrefs
			prefs = V_value
			strswitch(theTask)
				case "DisplayVS":
					if (strlen(title)==0)
						if (strlen(DVSflags)==0)
							sprintf theCmd "%s#LinkDisplay#%s(%s)", GIMN, theTask, theWave
						else
							sprintf theCmd "%s#LinkDisplay#%s(%s,flags=\"%s\")", GIMN, theTask, theWave, DVSflags
						endif
					else
						if (strlen(DVSflags)==0)
							sprintf theCmd "%s#LinkDisplay#%s(%s,title=\"%s\")", GIMN, theTask, theWave, title
						else
							sprintf theCmd "%s#LinkDisplay#%s(%s,flags=\"%s\",title=\"%s\")", GIMN, theTask, theWave, DVSflags, title
						endif
					endif
					break
				case "AppendVS":
					if (strlen(WinName(0,1))==0)
						if (strlen(title)==0)
							sprintf theCmd "Display%s" DVSflags
						else
							sprintf theCmd "Display%s as \"%s\"" DVSflags, title
						endif
						Execute/Q theCmd
					endif
					if (strlen(AVSflags)==0)
						sprintf theCmd "%s#LinkDisplay#%s(%s)", GIMN, theTask, theWave
					else
						sprintf theCmd "%s#LinkDisplay#%s(%s,flags=\"%s\")", GIMN, theTask, theWave, AVSflags
					endif
					break
				case "AppendVS*":
					if (strlen(title)==0)
						sprintf theCmd "Display%s" DVSflags
					else
						sprintf theCmd "Display%s as \"%s\"" DVSflags, title
					endif
					Execute/Q theCmd
					theTask = RemoveEnding(theTask)
					if (strlen(AVSflags)==0)
						sprintf theCmd "%s#LinkDisplay#%s(%s)", GIMN, theTask, theWave
					else
						sprintf theCmd "%s#LinkDisplay#%s(%s,flags=\"%s\")", GIMN, theTask, theWave, AVSflags
					endif
					break
			endswitch
			Preferences prefs
			Execute/Q theCmd
			break
	endswitch
	
	Preferences 0
	return 0
End

// Button Action to Remove LinkVS

Function RemoveLinkVS(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	string theCmd = "PackageRemove(\"LinkVS\")"

	switch( ba.eventCode )
		case 2:
			KillWindow LinkVS
			Execute/P/Q/Z theCmd
			break
	endswitch
	return 0
end

// Button Action to Get Help

Function GetHelp(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	string theCmd = "PackageHelp(\"LinkVS\")"
	
	switch( ba.eventCode )
		case 2:
			Execute/P/Q/Z theCmd
			break
	endswitch

	return 0
End