#include "XOPStandardHeaders.r"

resource 'vers' (1) {						/* XOP version info */
	0x01, 0x00, final, 0x00, 0,				/* version bytes and country integer */
	"1.00",
	"1.00, Copyright 2012 Impulse Devices, Inc., all rights reserved."
};

resource 'vers' (2) {						/* Igor version info */
	0x06, 0x00, release, 0x00, 0,			/* version bytes and country integer */
	"6.00",
	"(for Igor Pro 6.00 or later)"
};

resource 'STR#' (1100) {					/* custom error messages */
	{
		/* [1] */
		"SelectFolders requires Igor Pro 6.0 or later.",
		/* [2] */
		"SelectFolders XOP was called to execute an unknown function.",
		/* [3] */
		"Couldn't create dialog options.",
		/* [4] */
		"Couldn't create dialog.",
		/* [5] */
		"Couldn't run dialog.",
		/* [6] */
		"Couldn't get reply from dialog.",
	}
};

/* no menu item */

resource 'XOPI' (1100) {
	XOP_VERSION,							// XOP protocol version.
	DEV_SYS_CODE,							// Development system information.
	0,										// Obsolete - set to zero.
	0,										// Obsolete - set to zero.
	XOP_TOOLKIT_VERSION,					// XOP Toolkit version.
};

resource 'XOPF' (1100) {
	{
		/* str1 = selectFolders() */	/* This uses the direct call method */
		"selectFolders",					/* function name */
		F_STR | F_EXTERNAL,					/* function category (string) */
		HSTRING_TYPE,						/* return value type str1 (string handle) */
		{},
	}
};
