#pragma rtGlobals=1		// Use modern global access method.
#pragma IgorVersion = 6.2
#pragma version = 3.2
#include <Scatter Plot Matrix 2>
#include <All Gizmo Procedures>
#include <Autosize Images>
#include <Wave Arithmetic Panel>
#include <Multi-peak fitting 2.0>

// written by Matt Sfeir, Brookhaven National Laboratory
// msfeir@bnl.gov
// v.3.1 February 12 2011


Menu "Load Waves"
	"Load Helios TA Data...", ProcessTA()
End

Menu "TA Analysis"
	"Load Helios TA Data...", OpenTA()
	"-"
	"Extract Kinetics", ExtractKin()
	"Extract Spectra", ExtractSpec()
	"-"
	"Time Zero Correction", T0ImCorr()
	"Scattered Light Correction", DisplayIntBkgdControlPanel()
End

// Modify Open File Dialog to break if cancelled

Function OpenTA()
	Variable refNum
	String message = "Select a file" 
	String outputPath, fileHandle, wName, wName2
	String fileFilters = "Helios TA Data Files (*.csv):.csv;" 
	fileFilters += "All Files:.*;" 
	Open /D /R /F=fileFilters /M=message refNum 
	outputPath = S_fileName
	printf "%s\r" outputPath
	fileHandle = ParseFilePath(5, outputPath, ":", 0,0)
	fileHandle = ParseFilePath(3, outputPath, ":", 0,0)
	printf "%s\r" fileHandle
	Variable lengthTest = strlen(fileHandle)
//  shorten string to 24 characters to satisfy Igor constraints on wave name length
//  max is 31.  start with 24 so that we can append suffix.
	if(lengthTest >= 24)
		Variable i = lengthTest - 24
		Variable j=0
		do
			fileHandle = RemoveEnding(fileHandle)
			j+=1
		while(j <= i)
	else
		fileHandle = fileHandle
	endif
	LoadWave/J/M/U={0,2,0,2}/D/A=$fileHandle/K=0 outputPath
	Wave w =outputPath
	// WaveExists  1 valid 0 invalid
	wName = fileHandle +"0"
	Variable b=0
	if (WaveExists ($wName) == 1)
		wName2 = fileHandle + num2str(b+1)
	if (WaveExists ($wName2) == 1)
			wName = wName2
		b += 1
	else
		wName = fileHandle + num2str(b)
		endif		
	endif
	Print wName
	Variable cancelTest = cmpstr(outputPath, "")
	if (cancelTest == 0)
		Print "Open file cancelled."
	else
		ProcessTA(wName)
	endif
End

// Loads waves and processes them for plotting
// Called by OpenTA()
Function ProcessTA(wName)  // CMD - . aborts the procedure
	String wName

	Duplicate $wName w
	String RPName = "RP_" + wName
	String CPName = "CP_" + wName
	Wave RP =RPName
	Wave CP =CPName
	Duplicate $RPName RP
	Duplicate $CPName CP

//	Wave w,RP,CP	
	Variable m, n, p, q, r
	
// remove NaNs and Infs.  Replace with zeros.

	m = Dimsize(w,0) // numer of rows
	printf "%f\r" m
	n = Dimsize(w,1) // number of columns	
	
	Make/N=(m,n) /D/O Zmat
	Zmat= (numtype(w) == 1) ? 0  : w
	Zmat= (numtype(Zmat) == 2) ? 0  : Zmat
	
	Make/N=(m) /D/O ContX
	ContX= (numtype(RP) == 1) ? 0  : RP
	ContX= (numtype(ContX) == 2) ? 0  : ContX

// remove extra rows - often contain bad data

	q = Dimsize(ContX,0)


//  IR camera contains half the pixels of the VIS camera
//  implement for this condition
//  mys 2/11/2011
 
//	if (q  > 512)
//		Redimension /N=512 ContX
//		Redimension /N=(512,-1) Zmat
//	endif

	if (q  < 300)
		Redimension /N=256 ContX
		Redimension /N=(256,-1) Zmat
	elseif(q > 512)
		Redimension /N=512 ContX
		Redimension /N=(512,-1) Zmat
	endif


	
	m = Dimsize(Zmat,0) // numer of rows
	n = Dimsize(Zmat,1) // number of columns
	p = m*n
			
	Make/N=(n) /D/O ContY
	ContY= (numtype(CP) == 1) ? 0  : CP
	ContY= (numtype(ContY) == 2) ? 0  : ContY

	Make/N=(p) /D/O tempXwave
	Make/N=(p) /D/O tempYwave
	Make/N=(p) /D/O tempZwave
	
	Make/N=(m+1) /D/O ImageX
	Make/N=(n+1) /D/O ImageY
	
	Make/N=(M,N,3) /O ParametricWave

// create new processed row, column positions and z matrix
// can be used to generate contour plot
	
	Variable i,j
	
	i=0
	do
		j=0
		do	
			tempXwave[j+m*i]=ContX[j]
			tempYwave[j+m*i]=ContY[floor((j+m*i)/m)]
			tempZwave[j+m*i]=Zmat[j][i]
			j +=1
		while (j <=m)
	i +=1	
	while (i <= n)
	
	Concatenate/O {tempXwave, tempYwave, tempZwave}, wScatterMatrix
	KillWaves tempXwave, tempYwave, tempZwave
	
// Format for Image Plot
// Create x and y wave for image.  Points define start and end of pixel positions, not center 
// so need to generate N+1 points from N.
// Add point at [-1] at same distance from [0] as [1]
// and shift by [0] - [1] distance OR pick midpoint between consecutive points
// assuming smallest increment at start of wave
	
	Variable g, h
	
	ImageX[0]= ContX[0]-((ContX[1]-ContX[0])/2)
//	g = 0
//	do
//		ImageX[g+1]=ContX[g]+((ContX[1]-ContX[0])/2)
//		g += 1
//	while (g <= m)
	g=1
	do
		ImageX[g] = (ContX[g] + ContX[g-1])/2
		g += 1
	while (g < m)
	ImageX[m] = ContX[m-1] + ((ContX[m-1] - ContX[m-2])/2)


	ImageY[0]= ContY[0]-((ContY[1]-ContY[0])/2)
//	h=0
//	do
//		ImageY[h+1]=ContY[h]+((ContY[1]-ContY[0])/2)
//		h += 1
//	while (h <= n)
	h=1
	do
		ImageY[h] = (ContY[h] + ContY[h-1])/2
		h+= 1
	while (h < n)
	ImageY[n] = ContY[n-1] + ((ContY[n-1] - ContY[n-2])/2)



// generate Parametic data.
// used for uneven spacings in surface plots

	Variable k,l
	
	k=0
	do
		l=0
		do
			ParametricWave[k][l][0]=ContX[k]
			ParametricWave[k][l][1]=ContY[l] 
			ParametricWave[k][l][2]=Zmat[k][l]
			l +=1
		while (l <= n)
	k +=1
	while (k <= m)

// clean up wave names
	
//	String ZmatName = NameOfWave(w) + "_zmat"
	String ZmatName = wName + "_zmat"
	Duplicate/O Zmat, $ZmatName
	KillWaves Zmat
	
//	String ContXName = NameOfWave(w) + "_xc"
	String ContXName = wName + "_xc"
	Duplicate/O ContX, $ContXName
	KillWaves ContX
	
//	String ContYName = NameOfWave(w) + "_yc"
	String ContYName = wName + "_yc"
	Duplicate/O ContY, $ContYName
	KillWaves ContY
	
//	String ImageXName = NameOfWave(w) + "_xim"
	String ImageXName = wName + "_xim"
	Duplicate/O ImageX, $ImageXName
	KillWaves ImageX
	
//	String ImageYName = NameOfWave(w) + "_yim"
	String ImageYName = wName + "_yim"
	Duplicate/O ImageY, $ImageYName
	KillWaves ImageY
	
//	String ScatMatName = NameOfWave(w) + "_sca"
	String ScatMatName = wName + "_sca"
	Duplicate/O wScatterMatrix, $ScatMatName
	KillWaves wScatterMatrix
	
//	String ParaName = NameOfWave(w) + "_par"
	String ParaName = wName + "_par"
	Duplicate/O ParametricWave, $ParaName
	KillWaves ParametricWave, w, RP, CP
	
	Display;AppendImage $ZmatName vs {$ImageXName,$ImageYName};DelayUpdate
	ModifyImage $ZmatName ctab= {*,*,Rainbow,0}
	ShowInfo
	
	GetWindow kwTopWin wtitle
	String imTitle = S_Value
	imTitle = RemoveEnding(imTitle, ":")
	Cursor/I /W=$imTitle A $ZmatName 1,1
	
	return 0
	
End


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

Function ExtractKin()
//	WAVE/Z w = CsrWaveRef(A)
//	if (!WaveExists(w))
//		return NaN
//	endif
//	String zmatName = NameOfWave(w)

	String info= ImageInfo("","",0)
	String zmatName = StringByKey("ZWAVE",info)
//	String xwName = StringByKey("XWAVE",info)
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg)"
	SplitString /E=(regex) zmatName, base, suffix
	String xwName
	if(CmpStr(zmatName,"")==0)
		xwName = "NewMatrix"
	else
		xwName = base + "xc"
	endif
//	String xwName = RemoveEnding(zmatName, "zmat")
// xwName = RemoveEnding(zmatName, "zibg")

	Variable xpos, lambda
	xpos = pcsr(A)
	lambda = hcsr(A)
	Prompt zmatName, "Enter matrix wave name: "
	Prompt xpos, "Enter cursor postion for desired wavelength: "
	Prompt xwName, "Enter wavelength wave name: "
	DoPrompt "Generate Kinetics", zmatName, xpos, xwName
	if (V_Flag)
		return -1
		endif
//	Print zmatName; Print xwName
//	Variable tName = NumberByKey("RECREATION",CsrInfo(A))
	KineticsPlot(zmatName,xpos,xwName)
	return 0
End

Function ExtractSpec()
//	WAVE/Z w = CsrWaveRef(A)
//	if (!WaveExists(w))
//		return NaN
//	endif
//	String zmatName = NameOfWave(w)

	String info= ImageInfo("","",0)
	String zmatName = StringByKey("ZWAVE",info)
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg)"
	SplitString /E=(regex) zmatName, base, suffix
	String ywName
	if(CmpStr(zmatName,"")==0)
		ywName = "NewMatrix"
	else
		ywName = base + "yc"
	endif
//	String ywName = RemoveEnding(zmatName, "zmat")
//	ywName = ywName + "yc"
	Variable ypos, stime	
	ypos = qcsr(A)
	stime = vcsr(A)
	Prompt zmatName, "Enter matrix wave name: "
	Prompt ypos, "Enter cursor postion for desired spectra: "
	Prompt ywName, "Enter time wave name: "
	DoPrompt "Generate Spectra", zmatName, ypos, ywName
	if (V_Flag)
		return -1
		endif
//	Print zmatName; Print ywName
	SpectraPlot(zmatName,ypos,ywName)
	return 0
End

Function KineticsPlot(KMat, lambdaPos, lambdaWave)
	String KMat, lambdaWave
	Variable lambdaPos
	
	String tWave //= RemoveEnding(KMat, "zmat") + "yc"
	Duplicate $KMat, kM
	Duplicate $lambdaWave, lM
	
	Variable m,n
	m = Dimsize(kM,0) // numer of rows
	n = Dimsize(kM,1) // number of columns

	String kWaveName
	Variable l = lM[lambdaPos]
	String lName = num2str(l)
//	printf "%s\r" lName
//	Print l; Print KMat
//	printf "%s\r" KMat
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg)"
	SplitString /E=(regex) kMat, base, suffix
	if(CmpStr(base,"")==0)
		kWaveName = "NewMatrix"
		tWave = "EmptyTimeWave"
	else
		kWaveName = base + "k" +lName
		tWave = base + "yc"
	endif
//	kWaveName = RemoveEnding(KMat, "zmat") + "k" +lName
	// Start of added code
	kWaveName = CleanupName(kWaveName, 1)
//	Print kWaveName
	// End of added code
	Make/D/O/N=(n) $kWaveName
	Wave w = $kWaveName
	Variable i,j
	i=lambdaPos
	j=0
	do
		w[j] = kM[i][j]
		j+=1
	while (j<=n)
//	Duplicate $kWaveName w
//	KillWaves tempKWave
	KillWaves kM, lM
	
	Display w vs $tWave

return 0
end

Function SpectraPlot(SMat, timePos, timeWave)
	String SMat, timeWave
	Variable timePos
	
	String sWave //= RemoveEnding(SMat, "zmat") + "xc"
	
	Wave sM = $SMat
	Wave tM = $timeWave
	
	Variable m,n
	m = Dimsize(sM,0) // numer of rows
	n = Dimsize(sM,1) // number of columns
	
	String tWaveName
	Variable tme = tM[timePos]
	String tmeName = num2str(tme)
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg)"
	SplitString /E=(regex) SMat, base, suffix
	if(CmpStr(base,"")==0)
		tWaveName = "EmptyTimeWave"
	else
		tWaveName = base + "s" +tmeName
		sWave = base + "xc"
	endif
//	tWaveName = RemoveEnding(SMat, "zmat") + "s" +tmeName
	tWaveName = CleanupName(tWaveName, 1)
		
	Make/D/O/N=(m) $tWavename
	Wave v = $tWavename
	
	Variable i,j
	i=timePos
	j=0
	do
		v[j] = sM[j][i]
		j+=1
	while (j<=m)
	
	Display v vs $sWave
	
return 0
end

/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

//  Subtract scattered light procedures (laser + fluorescence)
//  This is not used for other background subtraction

// Add a menu item to display the control panel. 
//Menu "TA Analysis"
//	"Subtract Intensity Background", DisplayIntBkgdControlPanel()
//End
// This is the display recreation macro, created by Igor 
// and then manually tweaked. The parts that were tweaked 
// are shown in bold. NOTE: Some lines are wrapped to fit on the page. 
Window IntBackControlPanel() : Panel
	PauseUpdate; Silent 1	// building window...
	NewPanel/W=(150,100,600,320)/K=1 as "Get Cursor Positions"
	
	SetDrawEnv fsize= 16
	DrawText 109,28,"Scattered Light Correction"

	SetVariable XSetVar,pos={40,45},size={150,15},title="Cursor A:" 
	SetVariable XSetVar,limits={0,Inf,1},value=root:Packages:IntensityBackground:cAComponent

	SetVariable YSetVar,pos={210,45},size={150,15},title="Cursor B:" 
	SetVariable YSetVar,limits={0,Inf,1},value=root:Packages:IntensityBackground:cBComponent
	Button ComputeButton,pos={110,76},size={90,20}, proc=GetCursorPositions,title="Preview"
	Button ComputeButton2,pos={227,76},size={90,20}, proc=GetCursorPositions2,title="Save"
	SetVariable setvar0 title="matrix:",size={284,15},bodyWidth=250, pos={77,115}, value=root:Packages:IntensityBackground:zWave
	SetVariable setvar0_1 title="sca_bkgd:",size={298,15},bodyWidth=250, pos={63,142}, value=root:Packages:IntensityBackground:scaWave
	SetVariable setvar0_2 title="corrected:",size={299,15},bodyWidth=250, pos={62,171}, value=root:Packages:IntensityBackground:corrWave
// embed graph
//	String IntBackPlot
//	Display/host=# /W=(50,200,400,350) as IntBackPlot
End

// This is the action procedure for the Compute button. 
// We created it using the Button dialog. 
Function GetCursorPositions(ctrlName) : ButtonControl
	String ctrlName
	// Make sure both cursors are on the same wave. 
	WAVE wA = CsrWaveRef(A) 
	WAVE wB = CsrWaveRef(B) 
	String dfA = GetWavesDataFolder(wA, 2)
	String dfB = GetWavesDataFolder(wB, 2) 
	if (CmpStr(dfA, dfB) != 0)
		Abort "Both cursors must be on the same wave."
		return -1 
	endif
	String info= ImageInfo("","",0)
	String zmatName = StringByKey("ZWAVE",info)
	Print zmatName
//	Wave wZ = $zmatName
	Variable n = Dimsize($zmatName,0) // number of columns
	String dfSave = GetDataFolder(1) 
	SetDataFolder root:Packages:IntensityBackground
	SVAR zWave
	zWave = zmatName
	NVAR cAComponent, cBComponent	// Access current data folder. 
	cAComponent = qcsr(A)
	Printf "Cursor A=%g\r", cAComponent
	Variable imin = cAComponent
	cBComponent = qcsr(B)
	Printf "Cursor B=%g\r", cBComponent
	Variable imax = cBComponent
	SetDataFolder dfSave  //restore original location
	Print imin 
	Print imax
	Print  n
	PreviewSLC(zmatName, imin, imax)
End

Function GetCursorPositions2(ctrlName) : ButtonControl
	String ctrlName
	// Make sure both cursors are on the same wave. 
	WAVE wA = CsrWaveRef(A) 
	WAVE wB = CsrWaveRef(B) 
	String dfA = GetWavesDataFolder(wA, 2)
	String dfB = GetWavesDataFolder(wB, 2) 
	if (CmpStr(dfA, dfB) != 0)
		Abort "Both cursors must be on the same wave."
		return -1 
	endif
	String info= ImageInfo("","",0)
	String zmatName = StringByKey("ZWAVE",info)
	Wave wZ = $zmatName
	Variable n = Dimsize(wZ,0) // number of columns
	String dfSave = GetDataFolder(1) 
	SetDataFolder root:Packages:IntensityBackground
	SVAR zWave
	zWave = zmatName
	NVAR gXComponent, gYComponent	// Access current data folder. 
	gXComponent = qcsr(A)
//	Printf "Cursor A=%g\r", gXComponent
	Variable imin = gXComponent
	gYComponent = qcsr(B)
//	Printf "Cursor B=%g\r", gYComponent
	Variable imax = gYComponent
	SetDataFolder dfSave  //restore original location
//	Print imin 
//	Print imax
//	Print  n
	ApplySLC(zmatName, imin, imax)
End


Function PreviewSLC(zMat, tmin, tmax)
	String zMat
	Variable tmin, tmax
	Wave fM = $zMat
	
	String scaBName = RemoveEnding(zMat, "zmat") + "scab"
	
	Variable minSig, maxSig

	if(tmin <= tmax)
		minSig = tmin
		maxSig = tmax
	elseif(tmin > tmax)
		minSig = tmax
		maxSig = tmin
	endif
	
	Variable m,n
	m = Dimsize(fM,0) // numer of rows
	n = Dimsize(fM,1) // number of columns
	
	String dfSave = GetDataFolder(1) 
	SetDataFolder root:Packages:IntensityBackground
//	Make/O/N=(m) dummyS1
	Make/O/N=(m) dummyS_avg
	
	Display/N=tempGraph
	Variable i,j
	i=0
	do
		String dumstr =  "dummyS_" + num2str(i)
		Make/O/N=(m) $dumstr
		Wave dS = $dumstr
		j=0
		do
			dS[j] = fM[j][i+minSig]
			j+=1
		while (j<=m)
		i+=1
		dummyS_avg += dS
		AppendToGraph $dumstr
	while (i+minSig <= maxSig)
	dummyS_avg /= i
	SVAR scaWave
	scaWave = scaBName
	Duplicate/O dummyS_avg, $scaBName
	KillWaves dummyS_avg
	

	SetDataFolder dfSave  //restore original location
	
return 0
end


Function ApplySLC(zMat, tmin, tmax)
	String zMat
	Variable tmin, tmax
	
	String scaBName = RemoveEnding(zMat, "zmat") + "scab"
	String zcorName = RemoveEnding(zMat, "zmat") + "zibg"
	String ImageXName = RemoveEnding(zMat, "zmat") + "xim"
	String ImageYName = RemoveEnding(zMat, "zmat") + "yim"
	
	Wave fM = $zMat
	Duplicate/O $zMat, root:Packages:IntensityBackground:zMatTemp
		
	Variable minSig, maxSig

	if(tmin <= tmax)
		minSig = tmin
		maxSig = tmax
	elseif(tmin > tmax)
		minSig = tmax
		maxSig = tmin
	endif
	
	Variable m,n
	m = Dimsize(fM,0) // numer of rows
	n = Dimsize(fM,1) // number of columns
	
	Make/O/N=(m) dummyS1
	Make/O/N=(m) dummyS_avg

	String dfSave = GetDataFolder(1) 
	SetDataFolder root:Packages:IntensityBackground
	
	Variable i,j
	i=0
	do
		j=0
		do
			dummyS1[j] = fM[j][i+minSig]
			j+=1
		while (j<=m)
		i+=1
		dummyS_avg += dummyS1
	while (i+minSig <= maxSig)
	dummyS_avg /= i
	SVAR scaWave
	scaWave = scaBName
	KillWaves dummyS1
	Duplicate/O dummyS_avg, $scaBName
	Duplicate/O dummyS_avg, root:$scaBName

	Wave wcorr = zMatTemp
	Variable k,l
	k=0
	do
		l=0
			do
				wcorr[l][k] = -log(10^(-(fM[l][k])) - 10^(-(dummyS_avg[l])) +1)
//				wcorr[k][l] = -log(10^(-(fM[k][l])))
//				wcorr[k][l] = fM[k][l]
				l+=1
			while (l<=m)
		k+=1
	while(k<n)
	SVAR corrWave
	corrWave = zcorName
	Duplicate/O zMatTemp, root:$zcorName
	KillWaves dummyS_avg
	SetDataFolder dfSave  //restore original location
	
	Display;AppendImage $zcorName vs {$ImageXName,$ImageYName};DelayUpdate
	ModifyImage $zcorName ctab= {*,*,Rainbow,0}
	ShowInfo
	
return 0
end

// This is the top level routine which makes sure that the globals 
// and their enclosing data folders exist and then makes sure that 
// the control panel is displayed.
 Function DisplayIntBkgdControlPanel()
	// If the panel is already created, 
	DoWindow/F IntBackControlPanel 
	if (V_Flag != 0)
		return 0 
	endif
	String dfSave = GetDataFolder(1)
	// Create a data folder in Packages to store globals.
	NewDataFolder/O/S root:Packages 
	NewDataFolder/O/S root:Packages:IntensityBackground
	// Create global variables used by the control panel. 
	Variable AComponent = NumVarOrDefault(":cAComponent", 10) 
	Variable/G cAComponent = AComponent 
	Variable BComponent = NumVarOrDefault(":cBComponent", 20) 
	Variable/G cBComponent = BComponent
	String ZWName = StrVarOrDefault(":zWave", "") 
	String /G zWave = ZWName
	String ScWName = StrVarOrDefault(":scaWave", "") 
	String /G scaWave = ScWName
	String CorWName = StrVarOrDefault(":corrWave", "") 
	String /G corrWave = CorWName
	// Create the control panel. 
	Execute "IntBackControlPanel()"
	SetDataFolder dfSave
End

///////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

Function T0ImCorr()
//	WAVE/Z w = CsrWaveRef(A)
//	if (!WaveExists(w))
//		return NaN
//	endif
//	String zmatName = NameOfWave(w)

	String info= ImageInfo("","",0)
	String yimName = StringByKey("YWAVE",info)
	String ycName = RemoveEnding(yimName, "im") + "c"
	Variable ypos, stime, newt0	
	ypos = qcsr(A)
	stime = vcsr(A)
	newt0 = stime
	Prompt yimName, "Enter image time wave name: "
	Prompt ycName, "Enter 1D time wave name (0 to ignore): "
	Prompt newt0, "Enter new t0: "
	DoPrompt "Correct Time Zero", yimName, ycName, newt0
	if (V_Flag)
		return -1
	endif
	T0CorrDo(yimName,newt0)
	if ((stringmatch(ycName, "0") == 1))
		Print "Igoring 1D time wave in t0 correction."
	else
		T0CorrDo(ycName,newt0)
	endif
	return 0
End

Function T0CorrDo(yName,newt0)
	String yName
	Variable newt0
	Wave w = $yName
	w -= newt0
	return 0
End

/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////


// Misc Fit Functions
// Keep t0 and pulsewidth identical for all decays
// G are rates

Function TwoExpGaussInf(w,x) : FitFunc
	Wave w
	Variable x

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(x) = y0+(amp1/G1)*ExpGauss(x-t0,G1,pw)+(amp2/G2)*ExpGauss(x-t0,G2,pw)+(Ainf/1E-9)*ExpGauss(x-t0,1E-9,pw)
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ x
	//CurveFitDialog/ Coefficients 8
	//CurveFitDialog/ w[0] = y0
	//CurveFitDialog/ w[1] = amp1
	//CurveFitDialog/ w[2] = t0
	//CurveFitDialog/ w[3] = pw
	//CurveFitDialog/ w[4] = G1
	//CurveFitDialog/ w[5] = amp2
	//CurveFitDialog/ w[6] = G2
	//CurveFitDialog/ w[7] = Ainf

	return w[0]+(w[1]/w[4])*ExpGauss(x-w[2],w[4],w[3])+(w[5]/w[6])*ExpGauss(x-w[2],w[6],w[3])+(w[7]/1E-9)*ExpGauss(x-w[2],1E-9,w[3])
End

Function ThreeExpGaussMatt(w,x) : FitFunc
	Wave w
	Variable x

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(x) = y0+(amp1/G1)*ExpGauss(x-t0,G1,pw)+(amp2/G2)*ExpGauss(x-t0,G2,pw)+(amp3/G3)*ExpGauss(x-t0,G3,pw)
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ x
	//CurveFitDialog/ Coefficients 9
	//CurveFitDialog/ w[0] = y0
	//CurveFitDialog/ w[1] = amp1
	//CurveFitDialog/ w[2] = t0
	//CurveFitDialog/ w[3] = pw
	//CurveFitDialog/ w[4] = G1
	//CurveFitDialog/ w[5] = amp2
	//CurveFitDialog/ w[6] = G2
	//CurveFitDialog/ w[7] = amp3
	//CurveFitDialog/ w[8] = G3

	return w[0]+(w[1]/w[4])*ExpGauss(x-w[2],w[4],w[3])+(w[5]/w[6])*ExpGauss(x-w[2],w[6],w[3])+(w[7]/w[8])*ExpGauss(x-w[2],w[8],w[3])
End
Function ExpGaussDampedOsc(w,t) : FitFunc
	Wave w
	Variable t

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(t) = (A/G1)*ExpGauss(t-t0,G1,sig)+ (B/G2)*ExpGauss(t-t0,G2,sig)+(C/G3)*ExpGauss(t-t0,G3,sig)*(D+sin(w*t+phi))
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ t
	//CurveFitDialog/ Coefficients 11
	//CurveFitDialog/ w[0] = A
	//CurveFitDialog/ w[1] = t0
	//CurveFitDialog/ w[2] = sig
	//CurveFitDialog/ w[3] = G1
	//CurveFitDialog/ w[4] = B
	//CurveFitDialog/ w[5] = G2
	//CurveFitDialog/ w[6] = C
	//CurveFitDialog/ w[7] = G3
	//CurveFitDialog/ w[8] = D
	//CurveFitDialog/ w[9] = w
	//CurveFitDialog/ w[10] = phi

	return (w[0]/w[3])*ExpGauss(t-w[1],w[3],w[2])+ (w[4]/w[5])*ExpGauss(t-w[1],w[5],w[2])+(w[6]/w[7])*ExpGauss(t-w[1],w[7],w[2])*(w[8]+sin(w[9]*t+w[10]))
End

Function ExpGaussDampedOsc2(w,t) : FitFunc
	Wave w
	Variable t

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(t) = (A/G1)*ExpGauss(t-t0,G1,sig)+ (B/G2)*ExpGauss(t-t0,G2,sig)+(C/G3)*ExpGauss(t-t0,G3,sig)*(D+sin(w*t+phi))+(E/G4)*ExpGauss(t-t0,G4,sig)*(F+sin(w2*t+phi2))
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ t
	//CurveFitDialog/ Coefficients 16
	//CurveFitDialog/ w[0] = A
	//CurveFitDialog/ w[1] = t0
	//CurveFitDialog/ w[2] = sig
	//CurveFitDialog/ w[3] = G1
	//CurveFitDialog/ w[4] = B
	//CurveFitDialog/ w[5] = G2
	//CurveFitDialog/ w[6] = C
	//CurveFitDialog/ w[7] = G3
	//CurveFitDialog/ w[8] = D
	//CurveFitDialog/ w[9] = w
	//CurveFitDialog/ w[10] = phi
	//CurveFitDialog/ w[11] = E
	//CurveFitDialog/ w[12] = G4
	//CurveFitDialog/ w[13] = F
	//CurveFitDialog/ w[14] = w2
	//CurveFitDialog/ w[15] = phi2

	return (w[0]/w[3])*ExpGauss(t-w[1],w[3],w[2])+ (w[4]/w[5])*ExpGauss(t-w[1],w[5],w[2])+(w[6]/w[7])*ExpGauss(t-w[1],w[7],w[2])*(w[8]+sin(w[9]*t+w[10]))+(w[11]/w[12])*ExpGauss(t-w[1],w[12],w[2])*(w[13]+sin(w[14]*t+w[15]))
End

Function ExpGaussDampedOsc3(w,t) : FitFunc
	Wave w
	Variable t

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(t) = (A/G1)*ExpGauss(t-t0,G1,sig)+ (C/G3)*ExpGauss(t-t0,G3,sig)*(D+sin(w*t+phi))
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ t
	//CurveFitDialog/ Coefficients 9
	//CurveFitDialog/ w[0] = A
	//CurveFitDialog/ w[1] = t0
	//CurveFitDialog/ w[2] = sig
	//CurveFitDialog/ w[3] = G1
	//CurveFitDialog/ w[4] = C
	//CurveFitDialog/ w[5] = G3
	//CurveFitDialog/ w[6] = D
	//CurveFitDialog/ w[7] = w
	//CurveFitDialog/ w[8] = phi

	return (w[0]/w[3])*ExpGauss(t-w[1],w[3],w[2])+ (w[4]/w[5])*ExpGauss(t-w[1],w[5],w[2])*(w[6]+sin(w[7]*t+w[8]))
End

Function SolventResponse(w,x) : FitFunc
	Wave w
	Variable x

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(x) = A* Gauss(x,t0,sig)+B*hermiteGauss(1,((x-t0)/(2*sig^2)))*Gauss(x,t0,sig)+C*hermiteGauss(2,((x-t0)/(2*sig^2)))*Gauss(x,t0,sig)
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ x
	//CurveFitDialog/ Coefficients 5
	//CurveFitDialog/ w[0] = A
	//CurveFitDialog/ w[1] = B
	//CurveFitDialog/ w[2] = C
	//CurveFitDialog/ w[3] = t0
	//CurveFitDialog/ w[4] = sig

	return w[0]* Gauss(x,w[3],w[4])+w[1]*hermiteGauss(1,((x-w[3])/(2*w[4]^2)))*Gauss(x,w[3],w[4])+w[2]*hermiteGauss(2,((x-w[3])/(2*w[4]^2)))*Gauss(x,w[3],w[4])
End
