#pragma rtGlobals=1		// Use modern global access method.
#pragma IgorVersion = 6.2
#pragma version = 4.2.2
#include <Scatter Plot Matrix 2>
#include <All Gizmo Procedures>
#include <Autosize Images>
#include <Wave Arithmetic Panel>
#include <Multi-peak fitting 2.0>
#include <Global Fit 2>

// written by Matt Sfeir, Brookhaven National Laboratory
// msfeir@bnl.gov
// v.4.2.2 January 20. 2012

// break out all unused procedures into a separate file
// provided to maintain backwards compatbility if needed

// unused for new implementations and can be excluded

Function/S Plot1DFromMat(Mat, ACurs, BCurs, ltWave, mode)
	// this function will average 1D slices over a range given by the 2 cursor positions
	// for extraction at a single pixel, make sure that ACurs = B Curs
	
	//  mode should be set to 0 for vertical image slice (kinetics)
	//  mode should be set to 1 for horizontal slice (spectra)
	
	// written to behave like KineticsPlot2 (found in v. 4alpha3)
	
	String Mat, ltWave
	Variable ACurs, BCurs, mode

	Wave ksM = $Mat
	Variable m,n
	m = Dimsize(ksM,0) // numer of rows
	n = Dimsize(ksM,1) // number of columns
	
	// get base name to append to
	// also define name of time wave to plot against
	String base
	String suffix
	// First write for kinetics plot
	String kWaveName, sWaveName
	// Name for common plot
	String kWinName, sWinName
	String tWave, swave
                                      
	String dfSave
	
	String regex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
	SplitString /E=(regex) Mat, base, suffix
	if(CmpStr(base,"")==0)
		kWaveName = "NewMatrix"
		tWave = "EmptyTimeWave"
		sWave = "EmstySpectraWave"
		// plot all extracted kinetics on the same graph
		// define window name to be base + kp
		kWinName = "Empty K Name"
		sWinName = "Empty S Plot"
	else
		tWave = base + "yc"
		sWave = base + "xc"
		// plot all extracted kinetics on the same graph
		// define window name to be base + kp
		kWinName = base + "kp"
		sWinName = base + "sp"
	endif
	// make sure it is not more than 31 chars

	
	if(mode == 0) // kinetics
		Wave ltM = $sWave  
	elseif(mode == 1)  // spectra
		Wave ltM = $tWave
	endif
	
	Variable DAB = abs(ACurs - BCurs)
	String IName
	
	Variable IA = ltM[ACurs]
	Variable lB = ltM[BCurs]     
	Variable lAB = abs(IA - lB)
	
	Variable minpix, maxpix
	if(ACurs <= BCurs)
//		Print "Less than or equal" 
		minpix = ACurs
		maxpix = BCurs
//		IName = num2Str(IA + ((IA - lB)/2))
		if(mode == 0)
			sprintf IName, "%3.0f", (IA + (lAB/2))
		else
			sprintf IName, "%1.3f", (IA + (lAB/2))
		endif

	else
//		Print "GT!"
		minpix = BCurs
		maxpix = ACurs
//		IName = num2Str(lB + ((lB - IA)/2))
		if(mode == 0)
			sprintf IName, "%3.0f", (lB + (lAB/2))
		else
			sprintf IName, "%1.3f", (lB + (lAB/2))
		endif
	endif
	
	kWaveName = base + "k" + IName + "_" + num2iStr(DAB)
	sWaveName = base + "s" + IName + "_" + num2iStr(DAB)
	kWaveName = CleanupName(kWaveName, 1)
	sWaveName = CleanupName(sWaveName, 1)
	
	Variable i = 0
	Variable j = 0
	if(mode == 0)
		Make/D/O/N=(n) $kWaveName
		Wave w = $kWaveName
		w = 0
		// use built-in indexing capabilities to
		// extract a row
		// I find this implementation to be partuclarly confusing
		do 
			w += ksM[minpix+i] [p]
			i+=1
		while(minpix+i <= maxpix)
		w /= i
		
		// show all extracted traces on the same graph
		// create new graph if it doesn't exist
		DoWindow/F $kWinName
		if (V_Flag == 0)
			Display/K=2/N=$kWinName w vs $tWave 
		else 
			AppendToGraph/W=$kWinName w vs $tWave 
		endif
		//	DoUpdate

	
	elseif(mode == 1)
		Make/D/O/N=(m) $sWaveName
		Wave v = $sWaveName
		v = 0
		do 
			v += ksM[p][minpix+j]
			j+=1
		while(minpix+j <= maxpix)
		v /= j
		
		// show all extracted traces on the same graph
		// create new graph if it doesn't exist
		DoWindow/F $sWinName
		if (V_Flag == 0)
			Display/K=2/N=$sWinName v vs $sWave 
		else 
			AppendToGraph/W=$sWinName v vs $sWave 
		endif
	else
		// just fail if mode set to anything else
		return ""
	endif
	
	if(mode == 0)
		return kWaveName
	elseif(mode == 1)
		return sWaveName
	endif


End


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////


Function KineticsPlot2(KMat, lambdaPos, lambdaWave)
	String KMat, lambdaWave
	Variable lambdaPos
	
	Wave kM = $KMat
	Wave lM = $lambdaWave
	
// generate target wave for kinetic information
// named appropriately with the wavelength
	
	Variable m,n
	m = Dimsize(kM,0) // numer of rows
	n = Dimsize(kM,1) // number of columns
	
	String kWaveName
	// Name for common plot
	String kWinName
	String tWave
	Variable l = lM[lambdaPos]
	String lName = num2str(l)
	String dfSave
	
	// get base name to append to
	// also define name of time wave to plot against
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
	SplitString /E=(regex) kMat, base, suffix
	if(CmpStr(base,"")==0)
		kWaveName = "NewMatrix"
		tWave = "EmptyTimeWave"
		// plot all extracted kinetics on the same graph
		// define window name to be base + kp
		kWinName = "Empty K Name"
	else
		kWaveName = base + "k" +lName
		tWave = base + "yc"
		// plot all extracted kinetics on the same graph
		// define window name to be base + kp
		kWinName = base + "kp"
	endif
	// make sure it is not more than 31 chars
	kWaveName = CleanupName(kWaveName, 1)

	Make/D/O/N=(n) $kWaveName
	Wave w = $kWaveName
	
// use built-in indexing capabilities to
// extract a row
// I find this implementation to be partuclarly confusing

	w = kM[lambdaPos] [p]

// show all extracted traces on the same graph
	// create new graph if it doesn't exist
	DoWindow/F $kWinName
	if (V_Flag == 0)
		Display/K=2/N=$kWinName w vs $tWave 
	else 
		AppendToGraph/W=$kWinName w vs $tWave 
	endif
//	DoUpdate


return 0
end


Function SpectraPlot2(SMat, timePos, timeWave)
	String SMat, timeWave
	Variable timePos
	
	String sWave //= RemoveEnding(SMat, "zmat") + "xc"
	
	Wave sM = $SMat
	Wave tM = $timeWave
	
	Variable m,n
	m = Dimsize(sM,0) // numer of rows
	n = Dimsize(sM,1) // number of columns
	
	String tWaveName, tWinName
	Variable tme = tM[timePos]
	String tmeName = num2str(tme)
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
	SplitString /E=(regex) SMat, base, suffix
	if(CmpStr(base,"")==0)
		tWaveName = "EmptyTimeWave"
		tWinName = "Empty S Name"
	else
		tWaveName = base + "s" +tmeName
		sWave = base + "xc"
		tWinName = base + "sp"
	endif
//	tWaveName = RemoveEnding(SMat, "zmat") + "s" +tmeName
	tWaveName = CleanupName(tWaveName, 1)
		
	Make/D/O/N=(m) $tWavename
	Wave v = $tWavename
	
	v = SM[p][timepos]
	
//	Display v vs $sWave
// show all extracted traces on the same graph
	// create new graph if it doesn't exist
	DoWindow/F $tWinName
	if (V_Flag == 0)
		Display/K=2/N=$tWinName v vs $sWave 
	else 
		AppendToGraph/W=$tWinName v vs $sWave 
	endif
//	DoUpdate
	
return 0
end


//  Fucntions below have been rewritten and are included for backwards compatibility only
//  Instead of for loops, use built-in Igor indexing


Function KineticsPlot(KMat, lambdaPos, lambdaWave)
	String KMat, lambdaWave
	Variable lambdaPos
	
	String tWave //= RemoveEnding(KMat, "zmat") + "yc"
	Duplicate $KMat, kM
	Duplicate $lambdaWave, lM
	
	Variable m,n
	m = Dimsize(kM,0) // numer of rows
	n = Dimsize(kM,1) // number of columns

	String kWaveName
	Variable l = lM[lambdaPos]
	String lName = num2str(l)
//	printf "%s\r" lName
//	Print l; Print KMat
//	printf "%s\r" KMat
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
	SplitString /E=(regex) kMat, base, suffix
	if(CmpStr(base,"")==0)
		kWaveName = "NewMatrix"
		tWave = "EmptyTimeWave"
	else
		kWaveName = base + "k" +lName
		tWave = base + "yc"
	endif
//	kWaveName = RemoveEnding(KMat, "zmat") + "k" +lName
	// Start of added code
	kWaveName = CleanupName(kWaveName, 1)
//	Print kWaveName
	// End of added code
	Make/D/O/N=(n) $kWaveName
	Wave w = $kWaveName
	Variable i,j
	i=lambdaPos
	j=0
	do
		w[j] = kM[i][j]
		j+=1
	while (j<=n)
//	Duplicate $kWaveName w
//	KillWaves tempKWave
	KillWaves kM, lM
	
	Display w vs $tWave

return 0
end

Function SpectraPlot(SMat, timePos, timeWave)
	String SMat, timeWave
	Variable timePos
	
	String sWave //= RemoveEnding(SMat, "zmat") + "xc"
	
	Wave sM = $SMat
	Wave tM = $timeWave
	
	Variable m,n
	m = Dimsize(sM,0) // numer of rows
	n = Dimsize(sM,1) // number of columns
	
	String tWaveName
	Variable tme = tM[timePos]
	String tmeName = num2str(tme)
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
	SplitString /E=(regex) SMat, base, suffix
	if(CmpStr(base,"")==0)
		tWaveName = "EmptyTimeWave"
	else
		tWaveName = base + "s" +tmeName
		sWave = base + "xc"
	endif
//	tWaveName = RemoveEnding(SMat, "zmat") + "s" +tmeName
	tWaveName = CleanupName(tWaveName, 1)
		
	Make/D/O/N=(m) $tWavename
	Wave v = $tWavename
	
	Variable i,j
	i=timePos
	j=0
	do
		v[j] = sM[j][i]
		j+=1
	while (j<=m)
	
	Display v vs $sWave
	
return 0
end

/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

//  Inspect Image Data section
// Apply Window Hook Calls to existing image

Function ImageHookGenOld()

//  No need to build new image
//  Just apply window hook function to top window
//  first make sure this is an image
	String ImTest = ImageInfo("","",0)
	if(cmpstr(Imtest,"",0) == 0)
		return 0
//		Print "Not an image."
	else
		GetWindow kwTopWin, wavelist
		// don't forget to declare wave
		Wave/T wl = W_WaveList
	// figure out which one is z
	// not the most elegant solution 
		String Zregex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
		String ZMatName
		String S00 = wl[0][0]
		String S10 = wl[1][0]
		String S20 = wl[2][0]
		if(GrepString(S00, Zregex) == 1)
			ZMatName = S00
		elseif(GrepString(S10, Zregex) == 1)
			ZMatName = S10
		elseif(GrepString(S20, Zregex) == 1)
			ZMatName = S20
		else
			Print "No image found."	
		endif
	
		Print "Z = " + ZMatNAme

		GetWindow kwTopWin, wtitle
		String imTitle = S_Value
	//	Cursor/I A $ZMatName 1,1
	
	//  add call for Window Hook - testing phase

		SetWindow kwTopWin, hook(MyHook)=MyWindowHook

	// build window for displaying kinetics
		String base
		String suffix
		String regex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
		SplitString /E=(regex) ZMatName, base, suffix

		String xwName
		String ywName
		if(CmpStr(zmatName,"")==0)
			xwName = "NewXWave"
			ywName = "NewYWave"
		else
			xwName = base + "xc"
			ywName = base + "yc"
		endif
	
		//  first data to display for kinetics
		Variable xpos, lambda
		xpos = pcsr(A)
		lambda = hcsr(A)
		//  first data to display for spectra
		Variable ypos, stime	
		ypos = qcsr(A)
		stime = vcsr(A)
	
		// build kinetics graph
		Wave kM = $ZMatName
		
	//	Wave lM = $xwName
	
	// generate target wave for kinetic information
	// named appropriately with the wavelength
	
		Variable m,n
		m = Dimsize(kM,0) // numer of rows
		n = Dimsize(kM,1) // number of columns

	// name with generic name so it can be continuously overwritten
	// can be copied later with appropriate command	
		// String kWaveName = "kinetics"
		// String sWaveName = "spectra"
		String kWaveName = "kineticsA"
		String sWaveName = "spectraA"

	// we do need the right time wave though . . .
		String tWave
		if(CmpStr(base,"")==0)
			tWave = "EmptyTimeWave"
		else
			tWave = base + "yc"
		endif

		Make/D/O/N=(n) $kWaveName

		
		Wave w = $kWaveName

		
	//  . . . and lambda wave
		String sWave
		if(CmpStr(base,"")==0)
			sWave = "EmptyLamWave"
		else
			sWave = base + "xc"
		endif

		Make/D/O/N=(m) $sWaveName
		Wave v = $sWaveName
	
	// use built-in indexing capabilities to
	// extract a row
	// I find this implementation to be partuclarly confusing

		w = kM[xpos] [p]
		v = kM[p][ypos]

	// create new graph if it doesn't exist
	//	DoWindow/F kinetics0
	//	if (V_Flag == 0)
	//		Display/K=2/N=kinetics w vs $tWave as "kinetics"
	//	endif
	//	DoUpdate

	
	//	DoWindow/F spectra0
	//	if (V_Flag == 0)
	//		Display/K=2/N=spectra v vs $sWave as "spectra"
	//	endif
	//	DoUpdate

	// break out graphing function so that the panel can be modified
	
	//  first create global variables if they don't exist
		if(DataFolderExists("root:Packages:InspectData") == 0)
			NewDataFolder/O root:Packages:InspectData
		endif
		String/G root:Packages:InspectData:gMessagek= ""
		String/G root:Packages:InspectData:gMessagekB= ""		
		String/G root:Packages:InspectData:gMessageki= ""
		String/G root:Packages:InspectData:gMessageXSck= ""
		String/G root:Packages:InspectData:gMessageYSck= ""
		
		Variable/G root:Packages:InspectData:gCursB= 0
		
		String/G root:Packages:InspectData:gMessages= ""
		String/G root:Packages:InspectData:gMessagesB= ""
		String/G root:Packages:InspectData:gMessagesi= ""
		String/G root:Packages:InspectData:gMessageXScs= ""
		String/G root:Packages:InspectData:gMessageYScs= ""
		
	// next fill in string values
		SVAR gMessagek = root:Packages:InspectData:gMessagek
		SVAR gMessagekB = root:Packages:InspectData:gMessagekB
		SVAR gMessageki = root:Packages:InspectData:gMessageki
		gMessagek = num2str(lambda)
		gMessageki = ZMatName
		
		NVAR gCursB = root:Packages:InspectData:gCursB
		
		SVAR gMessages = root:Packages:InspectData:gMessages
		SVAR gMessagesB = root:Packages:InspectData:gMessagesB
		SVAR gMessagesi = root:Packages:InspectData:gMessagesi
		gMessages = num2str(stime)
		gMessagesi = ZMatName
		
		//  make waves for cursor B anyway
		//  same size as A
		String kWaveNameB = "kineticsB"
		String sWaveNameB = "spectraB"
			
		Make/D/O/N=(n) $kWaveNameB
		Make/D/O/N=(m) $sWaveNameB
		
		Wave wB = $kWaveNameB
		Wave vB = $sWaveNameB
		
		Variable xposB, lambdaB	
		Variable yposB, stimeB	
		
		// initialize properly if B is on graph
		
		Variable bExists= strlen(CsrInfo(B)) > 0
		if (bExists == 1)
			gCursB = 1
			//  first data to display for kinetics			
			xposB = pcsr(B)
			lambdaB = hcsr(B)
			gMessagekB= num2str(lambdaB)
			
			//  first data to display for spectra
			yposB = qcsr(B)
			stimeB = vcsr(B)
			gMessagesB = num2str(stimeB)
			
			wB = kM[xposB] [p]
			vB = kM[p][yposB]
		else
			gCursB = 0
			gMessagekB = ""
			gMessagesB = ""
		endif
		
	//  now build graphs
		InspectGraphK(kWaveName, tWave, "kinetics")
		InspectGraphS(sWaveName, sWave, "spectra")
		
	// do these only if cursor B is already on the graph
		if (bExists == 1)
			InspectGraphK(kWaveNameB, tWave, "kinetics")
			InspectGraphS(sWaveNameB, sWave, "spectra")
		endif
		return 0
	endif
	
	
End

Function MyWindowHookOld(s)
	STRUCT WMWinHookStruct &s
	
	Variable hookResult = 0
//	Wave wk = kinetics
//	Wave ws = spectra
	Wave wk = kineticsA
	Wave ws = spectraA
	
	Wave wkB = kineticsB
	Wave wsB = spectraB

// do this when procedure is called
	String Zregex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
	String ZMatName
	String S00, S10, S20
	GetWindow/Z kwTopWin, wavelist
	Wave/T wl = W_WaveList
	// make sure this is an image
	String ImTest = ImageInfo("","",0)
//	if((cmpstr(Imtest,"",0) == 0) && (! V_Flag == 0))
	if((cmpstr(Imtest,"",0) == 0))
//		Print "Not an image."
//	else
//		Print "Image"
//	endif
//	if(DimSize(wl,0) == 3)
//  need to switch order of if then statement
// comment out return 0 and else to switch back
//		Print "Not an image."
//		return 0
	else
		// Wave/T wl = W_WaveList
		if(Dimsize(wl,0) == 3)
			S00 = wl[0][0]
			S10 = wl[1][0]
			S20 = wl[2][0]
		else
			S00 = ""
			S10 = ""
			S20 = ""
		endif
		
		if(GrepString(S00, Zregex) == 1)
			ZMatName = S00
		elseif(GrepString(S10, Zregex) == 1)
			ZMatName = S10
		elseif(GrepString(S20, Zregex) == 1)
			ZMatName = S20
		else
			ZMatName =""
			return 0	
		endif
		Wave kM = $ZMatName
	endif
	
// initalize variables for case 0, image window get activated
	String grtitle
	String base
	String suffix
	String regex = "(.*?)(zmat|zibg|zroi|zccm|A.sv)"
	String tWave, sWave
	Variable colsize, rowsize, xpos, ypos, lambda, stime

	Variable xposB, lambdaB	
	Variable yposB, stimeB	
	Variable bExists
	
	//  add global variable references for the PreserveGraphScaling function
	PreserveGraphScaling("kinetics","k")
	PreserveGraphScaling("spectra","s")
	
	//  what is happening here?
	// are we resetting the values somehow???
	NVAR gvaslk = root:Packages:InspectData:gvaslk
	NVAR gvasbk = root:Packages:InspectData:gvasbk
	NVAR gvlmink = root:Packages:InspectData:gvlmink
	NVAR gvlmaxk = root:Packages:InspectData:gvlmaxk
	NVAR gvbmink = root:Packages:InspectData:gvbmink
	NVAR gvbmaxk = root:Packages:InspectData:gvbmaxk
	//PreserveGraphScaling("spectra0","s")
	
	//  add global variable references for the PreserveGraphScaling function
	NVAR gvasls = root:Packages:InspectData:gvasls
	NVAR gvasbs = root:Packages:InspectData:gvasbs
	NVAR gvlmins = root:Packages:InspectData:gvlmins
	NVAR gvlmaxs = root:Packages:InspectData:gvlmaxs
	NVAR gvbmins = root:Packages:InspectData:gvbmins
	NVAR gvbmaxs = root:Packages:InspectData:gvbmaxs
	// global variables for graph messages
	SVAR gMessagek = root:Packages:InspectData:gMessagek
	SVAR gMessageki = root:Packages:InspectData:gMessageki
	SVAR gMessageXSck = root:Packages:InspectData:gMessageXSck
	SVAR gMessageYSck = root:Packages:InspectData:gMessageYSck
		
	SVAR gMessagekB = root:Packages:InspectData:gMessagekB
	SVAR gMessagesB = root:Packages:InspectData:gMessagesB
	NVAR gCursB = root:Packages:InspectData:gCursB
		
	SVAR gMessages = root:Packages:InspectData:gMessages
	SVAR gMessagesi = root:Packages:InspectData:gMessagesi
	SVAR gMessageXScs = root:Packages:InspectData:gMessageXScs
	SVAR gMessageYScs = root:Packages:InspectData:gMessageYScs

//	Print gvaslk

	switch(s.eventcode)
		// activate window
		case 0:
			//Print "case 0"
			//Print gvaslk
			//PreserveGraphScaling("kinetics0","k")
			PreserveGraphScaling("kinetics","k")
			
			
			// update for window hook calls on kinetics or spectra window
			// just updates control bar fields
			GetWindow kwTopWin, wtitle
			grTitle = S_Value
//			Print grTitle
			
			if(CmpStr(grTitle,"kinetics",0) == 0)
				
				PreserveGraphScaling("kinetics","k")	
				if(gvaslk == 1)
					gMessageYSck = num2str(gvlmink) +", "+ num2str(gvlmaxk)
				else
					gMessageYSck = "Auto"
				endif
				
				if(gvasbk == 1)
					gMessageXSck = num2str(gvbmink) +", "+ num2str(gvbmaxk)
				else
					gMessageXSck = "Auto"
				endif
				
				hookresult = 1
				break			
			endif
			// do the same for the spectra graph
			GetWindow kwTopWin, wtitle
			grTitle = S_Value
//			Print grTitle
			if(CmpStr(grTitle,"spectra",0) == 0)
				
				PreserveGraphScaling("spectra","s")	
				if(gvasls == 1)
					gMessageYScs = num2str(gvlmins) +", "+ num2str(gvlmaxs)
				else
					gMessageYScs = "Auto"
				endif
				
				if(gvasbs == 1)
					gMessageXScs = num2str(gvbmins) +", "+ num2str(gvbmaxs)
				else
					gMessageXScs = "Auto"
				endif
				
				hookresult = 1
				break			
			endif
			
			// otherwise, make sure we are operating on the active image
			GetWindow kwTopWin, wavelist
			//  make this only applicable to images
			if(cmpstr(Imtest,"",0) == 0)
//				Print "Not an image."
				return 0
			else
				S00 = wl[0][0]
				S10 = wl[1][0]
				S20 = wl[2][0]
				if(GrepString(S00, Zregex) == 1)
					ZMatName = S00
				elseif(GrepString(S10, Zregex) == 1)
					ZMatName = S10
				elseif(GrepString(S20, Zregex) == 1)
					ZMatName = S20
				else
					return 0
				//	abort
				endif
				Wave kM = $ZMatName
		//	else
		//		return 0
//			endif
			
//			if(DimSize(wl,0) == 3)
//				S00 = wl[0][0]
//				S10 = wl[1][0]
//				S20 = wl[2][0]
//				if(GrepString(S00, Zregex) == 1)
//					ZMatName = S00
//				elseif(GrepString(S10, Zregex) == 1)
//					ZMatName = S10
//				elseif(GrepString(S20, Zregex) == 1)
//					ZMatName = S20
//				else
//					Print "No image found."	
//				endif
				// may need to plot against new time wave if we have switched windows
				SplitString /E=(regex) ZMatName, base, suffix
				if(CmpStr(base,"")==0)
					tWave = "EmptyTimeWave"
					sWave = "EmptyLamWave"
				else
					tWave = base + "yc"
					sWave = base + "xc"
				endif
				// update dimensions of the kinetics wave
				colsize = Dimsize(kM,1) // numer of columns
				rowsize = DimSize(kM,0) // number of rows
				Redimension/N=(colsize) kineticsA
				Redimension/N=(rowsize) spectraA
				
				// re-initialize graph
				//DoWindow kinetics0
				DoWindow kinetics
				if (V_Flag == 0)
					return 0
				else
					// RemoveFromGraph/W=kinetics0 kinetics
					// AppendToGraph/W=kinetics0 kinetics vs $tWave
					RemoveFromGraph/W=kinetics kineticsA
					AppendToGraph/W=kinetics kineticsA vs $tWave
				endif
				
				//DoWindow spectra0
				DoWindow spectra
				if (V_Flag == 0)
					return 0
				else				
					// RemoveFromGraph/W=spectra0 spectra
					// AppendToGraph/W=spectra0 spectra vs $sWave
					RemoveFromGraph/W=spectra spectraA
					AppendToGraph/W=spectra spectraA vs $sWave
				endif
								
				xpos = pcsr(A)
				ypos = qcsr(A)
				lambda = hcsr(A)
				stime = vcsr(A)
				
				gMessagek = num2str(lambda)
				gMessageki = ZMatName
				
				gMessages = num2str(stime)
				gMessagesi = ZMatName
				
				wk = kM[xpos] [p]
				ws = kM[p] [ypos]
				
				// the cursor calls reset the graph scaling need to fix it here
				// include temp variable to reset axes back to default
				Variable gvaslktemp = gvaslk
				Variable gvasbktemp = gvasbk
				
				Variable gvaslstemp = gvasls
				Variable gvasbstemp = gvasbs
				
				Cursor/H=2/W=kinetics A kineticsA ypos
				Cursor/H=2/W=spectra A spectraA xpos
				
				gvaslk = gvaslktemp
				gvasbk = gvasbktemp
				
				gvasls = gvaslstemp
				gvasbs = gvasbstemp
				
				// this is repeated during image operations
				// also calls setaxis so state of graph is preseved if not autoscaled
				if(gvaslk == 1)
					//SetAxis/W=kinetics0 left, gvlmink, gvlmaxk
					SetAxis/W=kinetics left, gvlmink, gvlmaxk
					gMessageYSck = num2str(gvlmink) +", "+ num2str(gvlmaxk)
				else
					gMessageYSck = "Auto"
				endif
				
				if(gvasbk == 1)
					//SetAxis/W=kinetics0 bottom, gvbmink, gvbmaxk
					SetAxis/W=kinetics bottom, gvbmink, gvbmaxk
					gMessageXSck = num2str(gvbmink) +", "+ num2str(gvbmaxk)
				else
					gMessageXSck = "Auto"
				endif
				
				if(gvasls == 1)
					//SetAxis/W=spectra0 left, gvlmins, gvlmaxs
					SetAxis/W=spectra left, gvlmins, gvlmaxs
					gMessageYScs = num2str(gvlmins) +", "+ num2str(gvlmaxs)
				else
					gMessageYScs = "Auto"
				endif
				
				if(gvasbs == 1)
					//SetAxis/W=spectra0 bottom, gvbmins, gvbmaxs
					SetAxis/W=spectra bottom, gvbmins, gvbmaxs
					gMessageXScs = num2str(gvbmins) +", "+ num2str(gvbmaxs)
				else
					gMessageXScs = "Auto"
				endif				
				
				
				// updates for cursor B
				bExists= strlen(CsrInfo(B)) > 0
				if (bExists == 1)
					gCursB = 1
					Redimension/N=(colsize) kineticsB
					Redimension/N=(rowsize) spectraB
					DoWindow kinetics
					if (V_Flag == 0)
						return 0
					else
						RemoveFromGraph/Z/W=kinetics kineticsB
						AppendToGraph/W=kinetics kineticsB vs $tWave
					endif
				
					DoWindow spectra
					if (V_Flag == 0)
						return 0
					else				
						RemoveFromGraph/Z/W=spectra spectraB
						AppendToGraph/W=spectra spectraB vs $sWave
					endif
				
					//  first data to display for kinetics			
					xposB = pcsr(B)
					lambdaB = hcsr(B)
					gMessagekB= num2str(lambdaB)
			
					//  first data to display for spectra
					yposB = qcsr(B)
					stimeB = vcsr(B)
					gMessagesB = num2str(stimeB)
			
					wkB = kM[xposB] [p]
					wsB = kM[p][yposB]
					
					Cursor/H=2/C=(65535,0,0)/W=kinetics B kineticsB yposB
					Cursor/H=2/C=(65535,0,0)/W=spectra B spectraB xposB
				else
					gCursB = 0
					gMessagekB = ""
					gMessagesB = ""
					RemoveFromGraph/Z/W=kinetics kineticsB
					RemoveFromGraph/Z/W=spectra spectraB
					Cursor/K/W=kinetics B
					Cursor/K/W=spectra B
				endif
				
				ModifyGraph/Z/W=kinetics rgb[0] = (0,0,0)
				ModifyGraph/Z/W=kinetics rgb[1] = (65535,0,0)
				ModifyGraph/Z/W=spectra rgb[0] = (0,0,0)
				ModifyGraph/Z/W=spectra rgb[1] = (65535,0,0)
				
				
				
				hookresult = 1
				break
//			else
//			return 0
			endif
			
//  implement cursor move part
		//  current problem with cursor move - activate seems ok
		//null string variable on startup
		case 7:
			//Print "case 7"
			//Print "1: " + num2str(gvaslk)
			// mouse move
//			Print s.pointnumber
//			Print s.yPointNumber	
			//PreserveGraphScaling("kinetics0","k")	
			PreserveGraphScaling("kinetics","k")
			//PreserveGraphScaling("spectra0","s")
			PreserveGraphScaling("spectra","s")
			//Print "2: " + num2str(gvaslk)
			// make sure we are operating on the active image
			GetWindow kwTopWin, wavelist
			//  make this only applicable to images
			if(cmpstr(Imtest,"",0) == 0)
//				Print "Not an image."
				return 0
			else
				//Print "3: " + num2str(gvaslk)
				PreserveGraphScaling("kinetics","k")	
				S00 = wl[0][0]
				S10 = wl[1][0]
				S20 = wl[2][0]
				if(GrepString(S00, Zregex) == 1)
					ZMatName = S00
				elseif(GrepString(S10, Zregex) == 1)
					ZMatName = S10
				elseif(GrepString(S20, Zregex) == 1)
					ZMatName = S20
				else
					return 0
				endif
				Wave kM = $ZMatName
				SplitString /E=(regex) ZMatName, base, suffix
				if(CmpStr(base,"")==0)
					tWave = "EmptyTimeWave"
					sWave = "EmptyLamWave"
				else
					tWave = base + "yc"
					sWave = base + "xc"
				endif
				
				xpos = pcsr(A)
				ypos = qcsr(A)
			
				wk = kM[xpos] [p]
				ws = kM[p][ypos]
			
				lambda = hcsr(A)
				gMessagek = num2str(lambda)
				gMessageki = ZMatName
			
				stime = vcsr(A)
				gMessages = num2str(stime)
				gMessagesi = ZMatName
				
				Cursor/H=2/W=kinetics A kineticsA ypos
				Cursor/H=2/W=spectra A spectraA xpos
				
				if(gvaslk == 1)
					//SetAxis/W=kinetics0 left, gvlmink, gvlmaxk
					SetAxis/W=kinetics left, gvlmink, gvlmaxk
				endif
				
				if(gvasbk == 1)
					//SetAxis/W=kinetics0 bottom, gvbmink, gvbmaxk
					SetAxis/W=kinetics bottom, gvbmink, gvbmaxk
				endif
				
				if(gvasls == 1)
					//SetAxis/W=spectra0 left, gvlmins, gvlmaxs
					SetAxis/W=spectra left, gvlmins, gvlmaxs
				endif
				
				if(gvasbs == 1)
					//SetAxis/W=spectra0 bottom, gvbmins, gvbmaxs
					SetAxis/W=spectra bottom, gvbmins, gvbmaxs
				endif
			
				// updates for cursor B
	//			Variable xposB, lambdaB	
	//			Variable yposB, stimeB	
				bExists= strlen(CsrInfo(B)) > 0
				if (bExists == 1)
					gCursB = 1
			
					//  first data to display for kinetics			
					xposB = pcsr(B)
					lambdaB = hcsr(B)
					gMessagekB= num2str(lambdaB)
			
					//  first data to display for spectra
					yposB = qcsr(B)
					stimeB = vcsr(B)
					gMessagesB = num2str(stimeB)
			
					wkB = kM[xposB] [p]
					wsB = kM[p][yposB]
				
					CheckDisplayed/W=kinetics kineticsB
					if(V_flag == 1)
						Cursor/H=2/C=(65535,0,0)/W=kinetics B kineticsB yposB
						// return 0
					else
						AppendToGraph/W=kinetics kineticsB vs $tWave
					endif	
				
					CheckDisplayed/W=spectra spectraB
					if(V_flag == 1)
						Cursor/H=2/C=(65535,0,0)/W=spectra B spectraB xposB
						// return 0
					else
						AppendToGraph/W=spectra spectraB vs $sWave
						
					endif
					
				else
					gCursB = 0
					gMessagekB = ""
					gMessagesB = ""
					RemoveFromGraph/Z/W=kinetics kineticsB
					RemoveFromGraph/Z/W=spectra spectraB
					Cursor/K/W=kinetics B
					Cursor/K/W=spectra B
				endif			
			endif
			//Print "4: " + num2str(gvaslk)
			hookresult = 1
			break
			
		case 8:
			//Print "case 8"
			//Print gvaslk
			// update if we rescale the kinetics graph

			GetWindow kwTopWin, wtitle
			grTitle = S_Value
			
	
			if(CmpStr(grTitle,"kinetics",0) == 0)
				//Print "modified kinetics running"
				// PreserveGraphScaling("kinetics0","k")	
				PreserveGraphScaling("kinetics","k")
				if(gvaslk == 1)
					gMessageYSck = num2str(gvlmink) +", "+ num2str(gvlmaxk)
				else
					gMessageYSck = "Auto"
				endif
				
				if(gvasbk == 1)
					gMessageXSck = num2str(gvbmink) +", "+ num2str(gvbmaxk)
				else
					gMessageXSck = "Auto"
				endif
				
				hookresult = 1
				break			
			endif		
			
			if(CmpStr(grTitle,"spectra",0) == 0)
				//PreserveGraphScaling("spectra0","s")	
				PreserveGraphScaling("spectra","s")	
				if(gvasls == 1)
					gMessageYScs = num2str(gvlmins) +", "+ num2str(gvlmaxs)
				else
					gMessageYScs = "Auto"
				endif
				
				if(gvasbs == 1)
					gMessageXScs = num2str(gvbmins) +", "+ num2str(gvbmaxs)
				else
					gMessageXScs = "Auto"
				endif
		
		// commenting out the following section because it is not shown above and 
		// the kinetics plot is not broken (while spectra is)		
		//		bExists= strlen(CsrInfo(B)) > 0
		//		if (bExists == 1)
		//			gCursB = 1
		//			RemoveFromGraph/Z/W=kinetics kineticsB
		//			AppendToGraph/W=kinetics kineticsB vs $tWave
		//			RemoveFromGraph/Z/W=spectra spectraB
		//			AppendToGraph/W=spectra spectraB vs $sWave
					
		//		else
		//			RemoveFromGraph/Z/W=kinetics kineticsB
		//			RemoveFromGraph/Z/W=spectra spectraB
		//		endif	
		//  everything was fixed when this code was removed
		//  don't think about it too hard
		
				hookresult = 1
				break			
			endif		
			
	endswitch
	
	return hookResult
End
