#pragma rtGlobals=3		// Use modern global access method and strict wave access.

StrConstant sSettingsFld="root:HT_Globals" // where to store remembered settings, omit trailing colon

// to extend "Data" menu
Menu "Data"
	"--"
	"Import Axg file into single 2D wave",HT_ImportAxgMatrix()
	"Import Axg file into multiple 1D waves",HT_ImportAxgWaves()
End

Proc HT_ImportAxgMatrix(filePathName, matrixname, inclFilenameFlag, numericTypeflag, overwriteFlag, verboseFlag, makeTableFlag)
	String filePathName
	String matrixname=StrVarOrDefault("root:HT_Globals:g_axgMatrixname","AxgImported")
	Variable inclFilenameFlag=NumVarOrDefault("root:HT_Globals:g_axgInclFilenameFlag",1)
	Variable numericTypeflag=NumVarOrDefault("root:HT_Globals:g_axgNumericTypeflag",1)
	Variable overwriteFlag=NumVarOrDefault("root:HT_Globals:g_axgOverwriteFlag",1)
	Variable verboseFlag=NumVarOrDefault("root:HT_Globals:g_axgVerboseFlag",2)
	Variable makeTableFlag=NumVarOrDefault("root:HT_Globals:g_axgMakeTableFlag",2)
	Prompt filePathName, "Filename (empty for dialog):"
	Prompt matrixname, "Name of the created 2D wave:"
	Prompt inclFilenameFlag, "Include filename into wavename?", popup, "No;Yes"
	Prompt numericTypeflag, "Numeric type of the created 2D wave:", popup, "single precision;double precision"
	Prompt overwriteFlag, "Overwrite existing wave?", popup, "Yes, overwrite;No, don't overwrite"
	Prompt verboseFlag, "Print additional info to history?", popup, "Yes, be verbose;No, be silent"
	Prompt makeTableFlag, "Show wave data in table after importing?", popup, "No;Yes"
	
	PauseUpdate; Silent 1
	String sImportedWaveName
	NewDataFolder/O $sSettingsFld
	Variable/g $(sSettingsFld+":g_axgInclFilenameFlag")=inclFilenameFlag
	Variable/g $(sSettingsFld+":g_axgNumericTypeflag")=numericTypeflag
	Variable/g $(sSettingsFld+":g_axgOverwriteFlag")=overwriteFlag
	Variable/g $(sSettingsFld+":g_axgVerboseFlag")=verboseFlag
	Variable/g $(sSettingsFld+":g_axgMakeTableFlagg")=makeTableFlag
	String/g $(sSettingsFld+":g_axgMatrixname")=matrixname 
	sImportedWaveName = fHT_ImportAxgMatrix(filePathName,matrixname,inclFilenameFlag,numericTypeflag,overwriteFlag,verboseFlag)
	if (makeTableFlag == 2)
		Edit $sImportedWaveName; DelayUpdate
		ModifyTable format(Point)=1, horizontalIndex=2; DelayUpdate
	endif
End

Function/S fHT_ImportAxgMatrix(filePathName, matrixname, inclFilenameFlag, numericTypeFlag, overwriteFlag, verboseFlag)
	String filePathName,matrixname
	Variable inclFilenameFlag,numericTypeFlag,overwriteFlag,verboseFlag

	Variable flags
	SVAR g_axgMatrixname = $(sSettingsFld+":g_axgMatrixname")
	
	if (inclFilenameFlag==1 && strlen(matrixname)==0)
		DoAlert/T="fHT_ImportAxgMatrix" 2, "Name of the 2D wave must not be empty. Expecting string composed of 1..31 characters.\r\rUse 'AxgImported' instead?"
		if (V_flag == 1) // Yes clicked.
			matrixname = "AxgImported"
			g_axgMatrixname = matrixname
		elseif (V_flag == 2) // No clicked.
			printf "ERROR: expecting matrixname\r"
			return ""
		else // Cancel clicked.
			return ""
		endif
	endif
	
	if (strlen(filePathName)==0)
		filePathName=bpc_AxgFileOpenDialog("Select Axg file to open","",1)
	endif
	if (strlen(filePathName)==0)
		printf "ERROR: expecting file name\r"
		return ""
	endif
	numericTypeFlag -= 1 // from 1,2 to 0,1
	if (inclFilenameFlag == 2)
		flags = flags | 1
	endif	
	if (overwriteFlag == 1)
		flags = flags | 2
	endif
	if (verboseFlag == 1)
		flags = flags | 4
	endif
	return bpc_AxgToMatrix(filePathName,matrixname,numericTypeFlag,flags)
End
	
Proc HT_ImportAxgWaves(filePathName, wavenamePrefix, inclFilenameFlag, scalingFlag, numericTypeflag, overwriteFlag, verboseFlag, makeTableFlag)
	String filePathName
	String wavenamePrefix=StrVarOrDefault("root:HT_Globals:g_axgWavenamePrefix","Axg_")
	Variable inclFilenameFlag=NumVarOrDefault("root:HT_Globals:g_axgInclFilenameFlag",1)
	Variable scalingFlag=NumVarOrDefault("root:HT_Globals:g_axgScalingFlag",2)
	Variable numericTypeflag=NumVarOrDefault("root:HT_Globals:g_axgNumericTypeflag",2)
	Variable overwriteFlag=NumVarOrDefault("root:HT_Globals:g_axgOverwriteFlag",1)
	Variable verboseFlag=NumVarOrDefault("root:HT_Globals:g_axgVerboseFlag",2)
	Variable makeTableFlag=NumVarOrDefault("root:HT_Globals:g_axgMakeTableFlag",2)
	Prompt filePathName, "Filename (empty for dialog):"
	Prompt wavenamePrefix, "Prefix of the created 1D waves:"
	Prompt inclFilenameFlag, "Include filename into wavename?", popup, "No;Yes"
	Prompt scalingFlag, "Try to obtain wave scaling && units?", popup, "No, don't scale;Yes, apply scaling if possible"
	Prompt numericTypeflag, "Numeric type of the created 1D waves:", popup, "preserve or single precision;preserve or double precision"
	Prompt overwriteFlag, "Overwrite existing wave?", popup, "Yes, overwrite;No, don't overwrite"
	Prompt verboseFlag, "Print additional info to history?", popup, "Yes, be verbose;No, be silent"
	Prompt makeTableFlag, "Show wave data in table after importing?", popup, "No;Yes"
	
	PauseUpdate; Silent 1
	String sImportedWavesList, sCurrentWavename
	Variable i, vListLen
	NewDataFolder/O $sSettingsFld
	Variable/g $(sSettingsFld+":g_axgInclFilenameFlag")=inclFilenameFlag
	Variable/g $(sSettingsFld+":g_axgScalingFlag")=scalingFlag
	Variable/g $(sSettingsFld+":g_axgNumericTypeflag")=numericTypeflag
	Variable/g $(sSettingsFld+":g_axgOverwriteFlag")=overwriteFlag
	Variable/g $(sSettingsFld+":g_axgVerboseFlag")=verboseFlag
	Variable/g $(sSettingsFld+":g_axgMakeTableFlagg")=makeTableFlag
	String/g $(sSettingsFld+":g_axgWavenamePrefix")=wavenamePrefix
	sImportedWavesList = fHT_ImportAxgWaves(filePathName,wavenamePrefix,inclFilenameFlag,scalingFlag,numericTypeflag,overwriteFlag,verboseFlag)
	if (makeTableFlag == 2)
		vListLen = ItemsInList(sImportedWavesList, ";")
		Edit; DelayUpdate
		do
			sCurrentWavename=StringFromList(i, sImportedWavesList, ";")
			AppendToTable $sCurrentWavename; DelayUpdate
			i += 1
		while (i<vListLen)
		ModifyTable format(Point)=1; DelayUpdate
	endif
End

Function/S fHT_ImportAxgWaves(filePathName,wavenamePrefix,inclFilenameFlag,scalingFlag,numericTypeFlag,overwriteFlag,verboseFlag)
	String filePathName,wavenamePrefix
	Variable inclFilenameFlag,scalingFlag,numericTypeFlag,overwriteFlag,verboseFlag

	Variable flags

	if (inclFilenameFlag==1 && strlen(wavenamePrefix)==0)
		DoAlert/T="fHT_ImportAxgWaves" 2, "Prefix must not be empty. Expecting string composed of 1..27 characters.\r\rPrefix wavenames with 'Axg_'?"
		if (V_flag == 1) // Yes clicked.
			wavenamePrefix="Axg_"
		elseif (V_flag == 2) // No clicked.
			printf "ERROR: expecting basename\r"
			return ""
		else // Cancel clicked.
			return ""
		endif
	endif
	
	if (strlen(filePathName)==0)
		filePathName=bpc_AxgFileOpenDialog("Select Axg file to open","",1)
	endif
	if (strlen(filePathName)==0)
		printf "ERROR: expecting filename\r"
		return ""
	endif
	numericTypeFlag -= 1 // from 1,2 to 0,1
	if (inclFilenameFlag == 2)
		flags = flags | 1
	endif
	if (overwriteFlag == 1)
		flags = flags | 2
	endif
	if (verboseFlag == 1)
		flags = flags | 4
	endif
	if (scalingFlag == 2)
		flags = flags | 8
	endif
	return bpc_AxgToWave(filePathName,wavenamePrefix,numericTypeFlag,flags)
End