/*	XOP1.c -- An interface for PCO Sensicam and Igor Pro
	
	(c) 2011 Alexander Kaiser
	
	This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "XOPStandardHeaders.h"			// Include ANSI headers, Mac headers, IgorXOP.h, XOP.h and XOPSupport.h
#include "XOP1.h"
#include "sencam.h"
#include "errcodes.h"
//#include "ccd_types.h"
//#include "cam_types.h"
#include "windows.h"
#include "stdio.h"


int SC_initState = -1;


int releaseCam()
{
	int err = 0;

//stop camera, ( not realy needed with RUN_COC(4); ) 
   err=STOP_COC(0);

//   free(buf);

//free camera
   CLOSE_DIALOG_CAM();
   SET_INIT(0);

   printf("Camera is released\n");

   return err;
}


int copyPicturetoBuf_12Bit(unsigned short * buf, int width, int height) {
	int err = 0;
   float pictime;
   int waittime;
   int picstat;
   unsigned int t1,t2;

   pictime=GET_COCTIME()+GET_BELTIME();
   waittime=(int)pictime/1000+20;

   t1=GetTickCount();
   do
   {
    err=GET_IMAGE_STATUS(&picstat);
    t2=GetTickCount();
   }
   while((err==0)&&(t2<t1+waittime)&&((picstat&0x02)!=0));
	
   err = RUN_COC(4);
	if (err <0) return err;
   err=READ_IMAGE_12BIT(0,width,height,buf);
	STOP_COC(0);
	return err;
}

unsigned short* takePicture_12bit()
{
	int err = 0;
	int width,height;
   unsigned short *buf;   

   float pictime;
   int waittime;
   int picstat;
   unsigned int t1,t2;

	err=GET_IMAGE_SIZE(&width,&height);
   if(err<0)
   {
    printf("\nGET_IMAGE_SIZE failed with error %d\n",err);
    SET_INIT(0);
    printf("Any key to finish program \n");
    getchar();
    exit(-1);
   }
   
   buf=(unsigned short *)malloc(width*height*2);
   if(buf==0)
   {
    printf("\nallocating image buffer failed\n");
    SET_INIT(0);
    printf("Any key to finish program \n");
    getchar();
    exit(-1);
   }

   pictime=GET_COCTIME()+GET_BELTIME();
   waittime=(int)pictime/1000+20;

//start camera single picture
   printf("\nCamera grabs one image\n");

   err=RUN_COC(4);
   if(err<0)
   {
    printf("\nRUN_COC failed with error %d\n",err);
   }


//2.:
   t1=GetTickCount();
   do
   {
    err=GET_IMAGE_STATUS(&picstat);
    t2=GetTickCount();
   }
   while((err==0)&&(t2<t1+waittime)&&((picstat&0x02)!=0));

   if(err<0)
    printf("\nGET_IMAGE_STATUS failed with error %d\n",err);
   
   if((picstat&0x02)!=0)
    printf("\nTIMEOUT in waiting for picture\n");



   printf("Read image from board buffer\n");

   err=READ_IMAGE_12BIT(0,width,height,buf);
   if(err<0)
    printf("\nREAD_IMAGE_12BIT failed with error %d\n",err);
   if(err==100)
    printf("\nREAD_IMAGE_12BIT failed because no picture is in buffer\n");
  
   //stop camera, ( not realy needed with RUN_COC(4); ) 
   err=STOP_COC(0);

   return buf;
}

unsigned char * takePicture_8bit()
{
	int err = 0;
	int width,height;
   unsigned char *buf;   

   float pictime;
   int waittime;
   int picstat;
   unsigned int t1,t2;

	err=GET_IMAGE_SIZE(&width,&height);
   if(err<0)
   {
    printf("\nGET_IMAGE_SIZE failed with error %d\n",err);
    SET_INIT(0);
    printf("Any key to finish program \n");
    getchar();
    exit(-1);
   }
   
   buf=(unsigned short *)malloc(width*height);
   if(buf==0)
   {
    printf("\nallocating image buffer failed\n");
    SET_INIT(0);
    printf("Any key to finish program \n");
    getchar();
    exit(-1);
   }

   pictime=GET_COCTIME()+GET_BELTIME();
   waittime=(int)pictime/1000+20;

//start camera single picture
   printf("\nCamera grabs one image\n");

   err=RUN_COC(4);
   if(err<0)
   {
    printf("\nRUN_COC failed with error %d\n",err);
   }

//2.:
   t1=GetTickCount();
   do
   {
    err=GET_IMAGE_STATUS(&picstat);
    t2=GetTickCount();
   }
   while((err==0)&&(t2<t1+waittime)&&((picstat&0x02)!=0));

   if(err<0)
    printf("\nGET_IMAGE_STATUS failed with error %d\n",err);
   
   if((picstat&0x02)!=0)
    printf("\nTIMEOUT in waiting for picture\n");

   printf("Read image from board buffer\n");

   err=READ_IMAGE_8BIT(0,width,height,buf);
   if(err<0)
    printf("\nREAD_IMAGE_8BIT failed with error %d\n",err);
   if(err==100)
    printf("\nREAD_IMAGE_8BIT failed because no picture is in buffer\n");
  
   //stop camera, ( not realy needed with RUN_COC(4); ) 
   err=STOP_COC(0);

   return buf;
}

int getImageWidth() {
	int err = 0;
	int width,height;
	err=GET_IMAGE_SIZE(&width,&height);
	return width;
}

int getImageHeight() {
	int err = 0;
	int width,height;
	err=GET_IMAGE_SIZE(&width,&height);
	return height;
}

#include "XOPStandardHeaders.h"			// Include ANSI headers, Mac headers, IgorXOP.h, XOP.h and XOPSupport.h
#include "XOP1.h"

static int SC_InitCam(struct { double result; } * p) {
	SET_BOARD(0);
	SC_initState = SET_INIT(2);
	p->result = (double) SC_initState;
	return 0;
};

static int SC_ReleaseCam(struct { double result; } * p) {
	//SET_BOARD(0);
	releaseCam();
	return 0;
};

static int SC_GetWidth(struct { double result; } * p) {
	int width, height;
	GET_IMAGE_SIZE(&width, &height);
	p->result = (double)width;
	return 0;
};

static int SC_GetHeight(struct { double result;} * p) {
	int width, height;
	GET_IMAGE_SIZE(&width, &height);
	p->result = (double)height;
	return 0;
};

static int SC_OpenDialog(struct { double result;} * p) {
	OPEN_DIALOG_CAM(IgorClientHWND(), 0, "Camera Dialog");
	return 0;
};

/*#include "XOPStructureAlignmentTwoByte.h"
struct SC_Take_Picture_Params {
	double make; // p1 is the first parameter to XFUNC1Div.
	double result;
};
typedef struct SC_Take_Picture_Params SC_Take_Picture_Params;
#include "XOPStructureAlignmentReset.h"*/

#include "XOPStructureAlignmentTwoByte.h"
struct SC_Take_Picture_Params {
	Handle wavenameH;
	double result;
};
typedef struct SC_Take_Picture_Params SC_Take_Picture_Params;
#include "XOPStructureAlignmentReset.h"

static int SC_TakePicture_12(SC_Take_Picture_Params * p) {
	waveHndl wavH;
	char * waveName;
	int result, err;
	unsigned short * buf;
	unsigned short * wp;
	int hState;
	int width, height;
	long dimensionSizes[MAX_DIMENSIONS];
	int len;

	if (SC_initState != 0) {
		DisposeHandle(p->wavenameH);
		p->result = (double) SC_initState;
		return SC_initState;
	}

	len = GetHandleSize(p->wavenameH);
	waveName = malloc(len < MAX_OBJ_NAME ? len : MAX_OBJ_NAME);
	GetCStringFromHandle(p->wavenameH, waveName, MAX_OBJ_NAME);

	buf = takePicture_12bit();
	width = getImageWidth();
	height = getImageHeight();

	dimensionSizes[0] = width; // 10 rows
	dimensionSizes[1] = height; // 10 columns
	dimensionSizes[2] = 0;
	if (err = MDMakeWave(&wavH, waveName, NULL, dimensionSizes, NT_I16 | NT_UNSIGNED, 1))
		return err;

	hState=MoveLockHandle(wavH); // Lock wave handle in heap
	wp = WaveData(wavH); // Get a pointer to the wave data
	//err = copyPicturetoBuf_12Bit(wp, width, height);
	memcpy(wp, buf, width*height*2);
	free(buf);
	HSetState(wavH, hState); // Restore lock/unlocked state
	WaveHandleModified(wavH);

	if (err != 0) {
		waveName[0] = '\0';

		return -1;
	}
	//p->result = p->wavenameH;
	//p->result = NewHandle(strlen(waveName)-1);
	//PutCStringInHandle(waveName, p->result);
	//DisposeHandle(p->wavenameH);

	p->result = err;
	DisposeHandle(p->wavenameH);

	return(err);
};

#include "XOPStructureAlignmentTwoByte.h"
struct SC_Take_Picture_8_Params {
	double max;
	double min;
	Handle wavenameH;
	double result;
};
typedef struct SC_Take_Picture_8_Params SC_Take_Picture_8_Params;
#include "XOPStructureAlignmentReset.h"


static int SC_TakePicture_8(SC_Take_Picture_8_Params * p) {
	waveHndl wavH;
	int result, err;
	char * waveName;
	unsigned short * buf;
	unsigned char * wp;
	int hState;
	int width, height;
	long dimensionSizes[MAX_DIMENSIONS];
	int len;
	int i;
	unsigned short value;
	Handle str;

	if (SC_initState != 0) {
		DisposeHandle(p->wavenameH);
		p->result = (double)SC_initState;
		return SC_initState;
	}

	buf = takePicture_12bit();
	width = getImageWidth();
	height = getImageHeight();

	len = GetHandleSize(p->wavenameH);
	waveName = malloc(len < MAX_OBJ_NAME ? len : MAX_OBJ_NAME);
	GetCStringFromHandle(p->wavenameH, waveName, MAX_OBJ_NAME);
	
//	if (p->make > 0) {
		dimensionSizes[0] = width; 
		dimensionSizes[1] = height; 
		dimensionSizes[2] = 0; 
		if (err = MDMakeWave(&wavH, waveName, NULL, dimensionSizes, NT_I8 | NT_UNSIGNED, 1))
			return err;
/*	} else {
		wavH = FetchWave(waveName);
	}*/
	hState=MoveLockHandle(wavH); // Lock wave handle in heap
	wp = WaveData(wavH); // Get a pointer to the wave data
	for (i = 0; i < width*height; i++) {
		//*wp++ = *buf;
		//buf += 2;
		value = buf[i];
		//buf++;
		value = 256*(value-p->min)/(p->max-p->min);
		if (value > 255) {
			value = 255;
		}
		*wp++ = (unsigned char)(value);
	}
	//memcpy(wp, buf, width*height*1);
	free(buf);
	HSetState(wavH, hState); // Restore lock/unlocked state
	WaveHandleModified(wavH);

	DisposeHandle(p->wavenameH);

	p->result = (double) err;

	return 0;
};

#include "XOPStructureAlignmentTwoByte.h"
struct SC_Set_Values_Params {
	double exposuretime;
	double binning;
//	double trig;
	double result;
};
typedef struct SC_Set_Values_Params SC_Set_Values_Params;
#include "XOPStructureAlignmentReset.h"

static int SC_SetValues(SC_Set_Values_Params * p) {
	int mode;
	int trig; 
	int roix1;
	int roix2;
	int roiy1;
	int roiy2;
	int hbin;
	int vbin;
	char * table;
	int len;

	table = (char*)malloc(200);
	GET_COC_SETTING(&mode, &trig, &roix1, &roix2, &roiy1, &roiy2, &hbin, &vbin, table, 200);

	sprintf(table, "0, %d, -1, -1", (int)p->exposuretime);
	hbin = (int) p->binning;
	vbin = (int) p->binning;
	p->result = (double) SET_COC(mode, trig, roix1, roix2, roiy1, roiy2, hbin, vbin, table);

	return 0;
}


static long
RegisterFunction()
{
	int funcIndex;

	/*	NOTE:
		Most XOPs should return a result of NIL in response to the FUNCADDRS message.
		See XOP manual "Restrictions on Direct XFUNCs" section.
	*/

	funcIndex = GetXOPItem(0);		/* which function invoked ? */
	switch (funcIndex) {
		case 0:						/* str1 = xstrcat0(str2, str3) */
			return((long)SC_InitCam);	/* this uses the direct call method */
			break;
		case 1:						
			return((long)SC_GetWidth);			
			break;
		case 2:						
			return((long)SC_GetHeight);			
			break;
		case 3:
			return((long)SC_OpenDialog);
			break;
		case 4:
			return((long)SC_TakePicture_12);
			break;
		case 5:
			return((long)SC_TakePicture_8);
			break;
		case 6:
			return((long)SC_SetValues);
			break;
		case 7:
			return((long)SC_ReleaseCam);
			break;
	}
	return(NIL);
}


/*	XOPEntry()

	This is the entry point from the host application to the XOP for all messages after the
	INIT message.
*/

static void
XOPEntry(void)
{	
	long result = 0;

	switch (GetXOPMessage()) {
		case FUNCTION:								/* our external function being invoked ? */
			//result = DoFunction();
			result = 0;
			break;
			
		case FUNCADDRS:
			result = RegisterFunction();
			break;

		case CLEANUP:
			releaseCam();
			break;
	}
	SetXOPResult(result);
}

/*	main(ioRecHandle)

	This is the initial entry point at which the host application calls XOP.
	The message sent by the host must be INIT.
	
	main does any necessary initialization and then sets the XOPEntry field of the
	ioRecHandle to the address to be called for future messages.
*/
HOST_IMPORT void
main(IORecHandle ioRecHandle)
{
	int result;

	SC_initState = -1;
	
	XOPInit(ioRecHandle);							// Do standard XOP initialization.

	SetXOPEntry(XOPEntry);							// Set entry point for future calls.

/*	if (result = RegisterOperations()) {
		SetXOPResult(result);
		return;
	}*/
	
	SetXOPResult(0);
}
