// Common Header
#pragma rtGlobals=3
#pragma rtFunctionErrors=1
#pragma IgorVersion=9
#pragma TextEncoding="UTF-8"
#pragma hide = 1

// Project Updater header
//Static Constant kProjectID=200
Static Strconstant ksShortTitle="SpXZeigR"

// Package Information
#pragma version=5.30
Constant k_SpXZgRVersion=5.30
StrConstant k_SpXZgRPackageFolder="root:Packages:SpXZeigR"
StrConstant k_SpXZgRAuthor="Jeffrey J Weimer"
StrConstant k_SpXZgRAuthorEmail="Jeffrey.Weimer@UAH.edu"
StrConstant k_SpXZgRWebPage="https://www.wavemetrics.com/project/SpXZeigR"

// Specific Parameters

// Other Packages
#include "SpXZeigR Styles"
#include "SpXZeigR Main"
#include "SpXZeigR Layout"
#include "SpXZeigR Math"

 // menu builder
 // @brief creates menu
Menu "SpXZeigR", dynamic, hideable
	SpXZgR_BuildMenu(0), /Q, SpXZgR_showMainPanel()
	"\\M1(-"
	SpXZgR_BuildMenu(1), /Q, DoWindow/F $(WinName(0,1))
	SpXZgR_BuildMenu(2), /Q, SpXZgR_AddLayoutPanel()
	"\\M1(-"
	SubMenu "Do Math"
	SpXZgR_BuildMenu(3), /Q, SpXZgR_StartSpectraMath()
	SpXZgR_BuildMenu(4), /Q, SpXZgR_StartSpectraToolsCaM()
	end
//	"\\M1(-"
	SubMenu "Baselines"
	SpXZgR_BuildMenu(51), /Q, SpXZgR_StartBaselines()
	SpXZgR_BuildMenu(52), /Q, SpXZgR_StartRemoveBackground()
	end
	SpXZgR_BuildMenu(61), /Q, SpXZgR_StartAnalyzePeaks()
	"\\M1(-"
	SpXZgR_BuildMenu(7), /Q, SpXZgR_StartSnapIt()
	SpXZgR_BuildMenu(8), /Q, SpXZgR_StartScrollTraces()
	"\\M1(-"
	"About SpXZeigR", /Q, AboutSpXZeigR()
end

Menu "GraphPopup", dynamic
	SubMenu "SpXZeigR"
	SpXZgR_BuildMenu(21),/Q, SpXZgR_AddLayoutPanel()
	SpXZgR_BuildMenu(31),/Q, SpXZgR_StartSpectraMath()
	end
end

// @brief runs after compilation
// @return 0
Function AfterCompiledHook() // Hook Function

	if (DataFolderExists(k_SpXZgRPackageFolder)==0)
		printf "SpXZeigR %3.2f included but not initialized %s %s\r", k_SpXZgRversion, date(), time()
	else
		if (update_SpXZeigR())
			print "SpXZeigR package updated to", k_SpXZgRversion, date(), time()
		endif
	endif	
	return 0
end

// @brief check for update
Static Function update_SpXZeigR()

	variable vrtn = 0
	string cwin
	NVAR/SDFR=$k_SpXZgRPackageFolder cversion
	if (cversion != k_SpXZgRVersion)
		KillWindow/Z $k_SpXZgRMainPanelName
		cwin = SpXZgR_findChildPanel(k_SpXZgRLayoutPanelName,"",main=1)
		if (strlen(cwin)!=0)
			KillWindow/Z $k_SpXZgRLayoutPanelName
		endif
		cversion = k_SpXZgRVersion
		vrtn = 1
	endif
	return vrtn
end

// @brief initialize SpXZeigR to create or update package folder
Function initialize_SpXZeigR()

	variable winXX=0
	string hstr = ""
	
	// create the package folder
	
	if (DataFolderExists(k_SpXZgRPackageFolder)==0)
		SetDataFolder root:
		NewDataFolder/O/S root:Packages
		NewDataFolder/S SpXZeigR
		variable/G cversion = k_SpXZgRversion
		NewDataFolder/S Globals
		variable/G dfGraphMode = 1
		variable/G dfSpectrumType = 1
		variable/G dfTraceStyle = 1
		SetDataFolder ::
		SpXZeigRStyles#load_SpXZgRstyles()		
		sprintf hstr, "Initialized SpXZeigR %3.2f", k_SpXZgRversion
		winXX = 1
	else
		NVAR/SDFR=$k_SpXZgRPackageFolder cversion
		if (cversion != k_SpXZgRversion)
			cversion = k_SpXZgRversion
			sprintf hstr, "Re-initialized SpXZeigR %3.2f", k_SpXZgRversion
		endif
	endif

	if (strlen(hstr)!=0)
		print hstr, date(), time()
	endif
	return 0
end

// @brief builds the SpXZeigR menu
// @input mval is menu line
// @return menu string line depending on inputs
Function/S SpXZgR_BuildMenu(variable mval)

	string mstr = ""
	string fWin, tStr
	
	switch(mval)
		case 0:		// Main Panel
			mStr = SelectString((WinType(k_SpXZgRMainPanelName)!=0),"Main Panel","* Main Panel")
			break
		case 1:		// Front Graph
			fWin = WinName(0,1,1)
			if (strlen(fWin) == 0)
				mStr = "(> NO FRONT GRAPH"
			else
				GetWindow $fWin, wtitle
				mStr = "(> " + StringFromList(0,s_value)[0,10] + "..."
			endif
			break
		case 2:		// Layout Panel
			if (strlen(WinName(0,1,1)) == 0)
				mstr = "(Layout"
			else
				mStr = SpXZgR_findChildPanel("SpXZeigRLayoutPanel", "Layout")
			endif
			break
		case 21:		// Layout Panel
			if ( WhichListItem( k_SpXZgRLayoutPanelName,ChildWindowList(WinName(0,1,1)) ) < 0 )
				mStr = "Layout"
			else
				mStr = "(Layout"
			endif
			break
		case 3:		// SpXZgR Math Panel
			if (strlen(WinName(0,1,1)) == 0)
				mstr = "(SpXZeigR Math"
			else
				mStr = SpXZgR_findChildPanel("SpXZgRMathPanel", "SpXZeigR Math")
			endif
			break
		case 31:		// SpXZgR Math Panel
			mStr = SpXZgR_findChildPanel("SpXZgRMathPanel", "Math")
			break
		case 4:		// Spectra Tools Package Math Panel
#if (exists("WaveArthimeticTool#WaveArithmeticUI") == 6)
			if (strlen(WinName(0,1,1)) == 0)
				mstr = "(Spectra Tools Math"
			else
				mStr = SpXZgR_findChildPanel("DiffGenPanel", "Spectra Tools Math")
			endif
#else
			mStr = "(Spectra Tools Math"
#endif
			break
		case 51:		// Baselines Package Panel Tony
#if (exists("Baselines#Initialise") == 6)
			if (strlen(WinName(0,1,1)) == 0)
				mStr = "(Fit Baselines"
			else
				mStr = SpXZgR_findChildPanel("BL_panel", "Fit Baselines")
			endif
#else
			mStr = "(Fit Baselines"
#endif	// BASELINES
			break
		case 52:		// Remove Background Package Panel chozo
#if (exists("BackRemoveInitialize") == 6)
			if (strlen(WinName(0,1,1)) == 0)
				mStr = "(Remove Background"
			else
				fWin = StringFromList(0,WinList("InelasticBackDisplay*",";","WIN:1"))
				tStr = StringFromList(0,TraceNameList(fWin,";",1+4))
				mstr = SelectString(strlen(fWin),"Remove Background "+tStr[0,10],"* Remove Background")
			endif
#else
			mStr = "(Remove Background"
#endif
			break
		case 61:		// Analyze Peaks (not yet active)
			mStr = "(Analyze Peaks"
			break
		case 7:		// SnapIt Panel
#if (exists("SnapIt#ShowPanel") == 6)
			if (strlen(WinName(0,1,1)) == 0)
				mStr = "("
			else
				DoWindow SnapItPanel
				mstr = SelectString(v_flag,"","* ")
			endif
#else
			mStr = "("
#endif
			mStr += "SnapIt"
			break
		case 8:		// Scroll Traces Panel
#if (exists("ScrollTraces#ShowPanel") == 6)
			if (strlen(WinName(0,1,1)) == 0)
				mStr = "("
			else
				DoWindow ScrollTracesPanel
				mstr = SelectString(v_flag,"","* ")
			endif
#else
			mStr = "("
#endif
			mStr += "Scroll Traces"
			break
		default:
			break
	endswitch

	return mstr
end

// @brief displays the main panel for SpXZeigR
// @return 0
Function SpXZgR_showMainPanel()
	
	DoWindow/F $k_SpXZgRMainPanelName
	if (v_flag==1)
		return 0
	endif
	
	initialize_SpXZeigR()
	
	SpXZgRMain#create_SpXZgRMainPanel()
	return 0
end

// @brief find a child panel to a graph
// returns
// 	no cpanel: mStr
// 	cpanel
//			main default: "* " + mStr
//			main non-default: fWin
Function/S SpXZgR_findChildPanel(string cPanel, string mStr, [variable main])

	string fWin = ""
	string rStr = ""
	wave/T tList = ListToTextWave(WinList("*",";","WIN:1"),";")
	for (fWin : tList)
		if (WhichListItem(cPanel,ChildWindowList(fWin)) >= 0)
			rStr = SelectString(!ParamIsDefault(main),"* ",fWin)
			break
		endif
	endfor
	return (rStr + mStr)
end

Function SpXZgR_AddLayoutPanel()

	SpXZgRLayout#attach_SpXZeigRPanel()
	return 0
end

// @brief start the math panel
Function SpXZgR_StartSpectraMath()
	string mWin = SpXZgR_findChildPanel("SpXZgRMathPanel","",main=1)
	if (strlen(mWin) != 0)
		DoWindow/F $mWin
	else
		mWin = WinName(0,1,1)
		DoWindow/F $mWin
		SpXZgRMath#start_SpXZgRMath()
	endif
	return 0
end

// @brief start the compare and modify panel
Function SpXZgR_StartSpectraToolsCaM()
#if (exists("WaveArthimeticTool#WaveArithmeticUI") == 6)
	string mWin = SpXZgR_findChildPanel("DiffGenPanel","",main=1)
	if (strlen(mWin) != 0)
		DoWindow/F $mWin
	else
		mWin = WinName(0,1,1)
		DoWindow/F $mWin
		wave ww = TraceNameToWaveRef(mWin,StringFromList(0,TraceNameList(mWin,";",1+4)))
		WaveArthimeticTool#WaveArithmeticUI(ww)
	endif
#endif
	return 0
end

// @brief start the baseline panel
Function SpXZgR_StartBaselines()
#if (exists("Baselines#Initialise") == 6)
	string mWin = SpXZgR_findChildPanel("BL_panel","",main=1)
	if (strlen(mWin) != 0)
		DoWindow/F $mWin
	else
		mWin = WinName(0,1,1)
		DoWindow/F $mWin
		Baselines#Initialise(graph=mWin)
	endif
#endif
	return 0
end

// @brief start the remove background package
Function SpXZgR_StartRemoveBackground()
#if (exists("BackRemoveInitialize") == 6)
	string mWin = StringFromList(0,WinList("InelasticBackDisplay*",";","WIN:1"))
	if (strlen(mWin) != 0)
		DoWindow/F $mWin
	else
		mWin = WinName(0,1,1)
		DoWindow/F $mWin
		wave ww = TraceNametoWaveRef(mWin,StringFromList(0,TraceNameList(mWin,";",1+4)))
		BackgroundSubtractGUI(ww)
	endif
#endif
	return 0
end

// @brief start the analyze peaks
// NOT YET ACTIVE
Function SpXZgR_StartAnalyzePeaks()
	return 0
end

// @brief start the snapit panel
Function SpXZgR_StartSnapIt()
#if (exists("SnapIt#ShowPanel") == 6)
	SnapIt#ShowPanel()
#endif
	return 0
end

// @brief start the scroll traces panel
Function SpXZgR_StartScrollTraces()
#if (exists("ScrollTraces#ShowPanel") == 6)
	DoWindow/F ScrollTracesPanel
	if (v_flag == 0)
		ScrollTraces#ShowPanel()
	endif
#endif
	return 0
end

// @brief show an about me
Function AboutSpXZeigR()

	string aboutme, kstrv
	sprintf kstrv, "%3.2f", k_SpXZgRversion
	sprintf aboutme, "This package was orginally developed under Igor Pro 3 " + \
		"to analyze data from chemical spectroscopies, especially XPS.\rIt is " + \
		"being redesigned to work with modern Igor Pro versions primarily to show spectra in an intuitive,  easy,  and useful manner.\r\r" + \
		"Many of the previous built-in routines to modify and analyze data,  such as background removal or FFT processing,  " + \
		"now exist nicely in other packages and will be added back though hooks to them when possible.\r\r" + \
		"SpX - spectra\rZeigR - from German 'zeigen'  ...  to show\r\r" + \
		"Please ask questions using the contact on the IgorExchange site where the package is posted.\r\r" + \
		"The package is provided openly for non-commerical use.\rContact me for use in commerical applications.\r\r" + \
		"I hope that you find this package useful!\r\r" + \
		"Version " + kstrv + " by " + k_SpXZgRAuthor
	
	DoAlert/T="About SpXZeigR" 0, aboutme

	return 0
end

// global helper functions

// @brief check whether pop string has change
// @details compares popStr and userdata strings
// @return 0 no change, 1 changed
Function SpXZgR_PopHasChanged(STRUCT WMPopupAction &pa)	

	variable vv = abs(cmpstr(pa.popStr,pa.userdata))
	if (vv!= 0)
		pa.userdata = pa.popstr
	endif
	return vv
end

// @brief set SpXZgRHF hooks
Function set_SpXZgRHook(string hf, [string winnm])

	if (ParamIsDefault(winnm))
		winnm = WinName(0,1)
	endif
	SetWindow $winnm, hook(SpXZgRHF)=$hf
	return 0
end

// @brief clear SpXZgRHF hooks
Function clear_SpXZgRHook([string winnm])

	if (ParamIsDefault(winnm))
		winnm = WinName(0,1)
	endif
	SetWindow $winnm, hook(SpXZgRHF)=$""
	return 0
end

