﻿#pragma TextEncoding="UTF-8"
#pragma rtGlobals=3
#pragma version=1.40
#pragma IgorVersion=7
#pragma ModuleName=spidergram
#include <Resize Controls>

// updater headers
static constant kProjectID=8145 // the project node on IgorExchange
static strconstant ksShortTitle="Spidergram" // the project short title on IgorExchange

// If you have installed the IgorExchange Projects Installer
// (http: www.igorexchange.com/project/Updater) you can be
// notified when new versions of this project are released.

// https://www.wavemetrics.com/user/tony

// Please let me know if you find a bug.
// Feedback is appreciated.
// 1.40 adds customizable element order list
// in Igor 9, listbox must be active for 'paste to import'

// To Do: clean up on quit

// How to use this package

// Select Spidergram from the Macros menu to create the spidergram panel
// and preview plot. To import data from a spreadsheet, select the area
// of the spreadsheet that includes all of the data, with the element
// symbols in either the first row or the first column. Copy and paste
// into the wave selection listbox in the spidergram panel. Imported data
// are saved as waves in current data folder.

// Input data consists of a text wave containing element symbols, and one
// or more numerical waves containing element concentrations in ppm or
// wt. %. The text wave and data wave(s) *must* have the same length.
// Select a text wave containing element symbols from the popup menu,
// then select data waves from the listbox in the Data Selection area.
// Input data are normalized and reordered according to the selections in
// Data Treatment, and only those elements present in both the input and
// the selected element ordering scheme will be in the output. If 'skip
// blanks' is not selected, every element in the ordering scheme will be
// listed on the category axis, otherwise just those in the input data.
// Elements in the input waves for which there are no data in the
// selected normalizing scheme will be output as NaN. The plot window
// shows a preview of the output data. Click the 'Do It' button in the
// Data Output area to save the ordered and normalized data in waves
// within a subfolder of the current data folder. The name of the
// detination subfolder can be edited in the Data Output section. You can
// choose whether to create a table and plot for the output data. The
// spidergram panel and preview plot will close after the data have been
// saved.

// Note: the preview plot is not intended to be edited! Click 'Do It' to 
// cereate a plot in a new graph window that you can edit as you please.

// **********************************************************************
// *****                     IMPORTANT NOTE:                         ****
// *****                                                             ****
// *****       The values in the element order waves and             ****
// *****       normalizing values waves are not guaranteed           ****
// *****       to be right, so caveat emptor! Please let me          ****
// *****       know if you find errors, and send suggestions         ****
// *****       for other useful normalizing values. Send me          ****
// *****       a reference, or (preferably) tabulated values!        ****
// *****                                                             ****
// **********************************************************************

// Details

// The text wave used as input must contain properly capitalized element
// symbols. Non-alphabetic characters such as whitespace and numerals are
// ignored. This means that the output from a mass spectrometer that has
// element masses alongside the symbols is acceptable. It's up to you to
// perform any needed corrections to the data. The plot order and
// normalizing values are stored in waves in the Packages:spidergram data
// folder. Look in the CreateUserWaves() function to see how these are
// created. Follow the same format to add more options for normalizing
// and plot order. The default options for the spidergram plot can be
// edited in the spider_style() function.

// note that version updates will overwrite any code customizations, so
// save a copy of any code you want to keep.

menu "Macros"
	"Spidergram", /Q, spidergram#spider_init()
end

static function CreateUserWaves(DFREF dfr)
	
	// use this as a template for creating user-defined element order waves
	Make /O/N=0/T dfr:o_Custom /WAVE=o_Custom
	o_Custom = {"Re", "Se", "Ar", "C", "H"}

// template for creating a new normalization wave
//	Duplicate /O dfr:n_template dfr:n_NormWave /WAVE=n_NormWave
//	note n_NormWave, "Reference info"
//	n_NormWave[%Li] = 1.23 // etc, values in ppm
	
	// Edit here. Note that version updates will reset this function, so keep a backup.
	
end

static function spider_init()
	
	NewDataFolder /O root:Packages
	NewDataFolder /O root:Packages:Spidergram
	DFREF dfr = root:Packages:Spidergram
	string strRef = ""
	
	// Waves with o_ prefix define order of elements for a category plot;
	// waves with n_ prefix contain normalizing values (wt. ppm). Data
	// waves will be divided by corresponding values in normalizing wave
	// and plotted in the selected order.
	
	// n_waves have element symbol as dimension labels from 1 to 92.
	// o_waves are text waves containing element symbols in order.
	// If no value is given for an element concentration in the
	// normalizing wave, the output will have a NaN value. If an element
	// is present in the order wave but not in the data it will be
	// optionally skipped.
		
	// ------------------- Create element order waves ----------------------
		
	Make /O/N=0/T dfr:o_AtomicNo /WAVE=o_AtomicNo
	o_AtomicNo = {"","H","He","Li","Be","B","C","N","O","F"}
	o_AtomicNo[10] = {"Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K"}
	o_AtomicNo[20] = {"Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu"}
	o_AtomicNo[30] = {"Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y"}
	o_AtomicNo[40] = {"Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","cd","In"}
	o_AtomicNo[50] = {"Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr"}
	o_AtomicNo[60] = {"Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm"}
	o_AtomicNo[70] = {"Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au"}
	o_AtomicNo[80] = {"Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac"}
	o_AtomicNo[90] = {"Th","Pa","U"}
	
	strRef = "Hofmann, A.W. (1988) Chemical differentiation of the Earth: the\r"
	strRef += "relationship between mantle, continental crust, and oceanic crust\r"
	strRef += "Earth and Planetary Science Letters, 90, 297-314"
	Make /O/N=0/T dfr:o_Hofmann1988 /WAVE=o_Hofmann1988
	note o_Hofmann1988, strRef
	o_Hofmann1988={"Rb","Pb","U","Th","Ba","K","La","Ce","Nb","Sn"}
	o_Hofmann1988[10]={"Pr","Sr","Nd","Hf","Zr","Na","Sm","Eu","Gd","Tb"}
	o_Hofmann1988[20]={"Dy","Ho","Yb","Er","Y","Tm","Ti","Lu","Al","Cu"}
	o_Hofmann1988[30]={"Ca","Sc","Si","Fe","Co","Mg","Ni"}
		
	strRef = "Hofmann, A.W. (1997) Mantle geochemistry: The message\r"
	strRef += "from oceanic volcanism. Nature, 385, 219-229"
	Make /O/N=0/T dfr:o_Hofmann1997 /WAVE=o_Hofmann1997
	note o_Hofmann1997, strRef
	o_Hofmann1997={"Rb","Ba","Th","Nb","U","La","Ce","Pb","Nd","Sr"}
	o_Hofmann1997[10]={"P","Sm","Hf","Eu","Ti","Gd","Dy","Y","Er","Lu"}
	o_Hofmann1997[20]={"Al","Ca","Fe","Si","Mg"}
				
	strRef = "Hofmann, A.W. (2014) Sampling Mantle Heterogeneity through\r"
	strRef += "Oceanic Basalts: Isotopes and Trace Elements. In H.D. Holland & K.K.\r"
	strRef += "Turekian (Eds.), Treatise on Geochemistry (Second Edition) pp. 67–101."
	Make /O/N=0/T dfr:o_Hofmann2014 /WAVE=o_Hofmann2014
	note o_Hofmann2014, strRef
	o_Hofmann2014={"Rb","Ba","Th","Nb","U","K","La","Ce","Pb","Nd","Sr"}
	o_Hofmann2014[10]={"Sm","Zr","Eu","Ti","Gd","Tb","Dy","Er","Yb"}
	
	strRef = "Shannon, R.D. (1976) Revised effective ionic radii and systematic\r"
	strRef += "studies of interatomic distances in halides and chalcogenides.\r"
	strRef += "Acta Cryst. A32, 751-767."
	// VIII-coordinated
	// U and Eu appear twice (two valences). So they'll be plotted twice :)
	Make /O/N=0/T dfr:o_radiusVIII /WAVE=o_radiusVIII
	note o_radiusVIII, strRef
	o_radiusVIII={"Zr","U","Sc","Mg","Zn","Sb","Li","Fe","Pb","Mn"}
	o_radiusVIII[10]={"Ce","Lu","Yb","Tm","U","Er","Ho","Y","Dy","Tb"}
	o_radiusVIII[20]={"Th","Gd","Eu","Sm","Pm","cd","Nd","Ca","Pr","Ce"}
	o_radiusVIII[30]={"La","Bi","Na","Eu","Sr","Pb","Ba","K","Rb","Cs"}

	// VI-coordinated ionic radius order
	// several elements will appear twice in output
	// so output will have to be corrected for valence
	Make /O/N=0/T dfr:o_radiusVI /WAVE=o_radiusVI
	note o_radiusVI, strRef
	o_radiusVI = {"Si","Mn","Al","Mo","W","Sb","Ti","Nb","Ta","Fe"}
	o_radiusVI[10] = {"Mn","Mo","W","Sn","Zr","Mg","U","Zn","Sc","Sb"}
	o_radiusVI[20] = {"Li","Bi","Pb","Fe","Mn","Lu","Yb","Ce","Y"}
	
	// Rare earth elements, ordered by atomic number
	Make /O/N=0/T dfr:o_REE /WAVE=o_REE
	o_REE = {"La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu"}
	
	Make /O/N=0/T dfr:o_REEY /WAVE=o_REEY
	o_REEY = {"La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Y","Ho","Er","Tm","Yb","Lu"}
		
	Make /O/N=0/T dfr:o_LILplus /WAVE=o_LILplus
	o_LILplus = {"Rb","Ba","Th","Nb","U","K","La","Ce","Pb","Nd","Sm","Zr","Eu","Ti","Gd","Tb","Dy","Er","Yb"}
		
	Make /O/N=0/T dfr:o_SDZ /WAVE=o_SDZ
	o_SDZ = {"Ba","Nb","K","La","Ce","Pr","Sr","P","Nd","F","Sm","Zr","Eu","Ti","Gd","Tb","Dy","Y","Ho","Er","Tm","Yb","Lu"}
	
	Make /O/N=0/T dfr:o_order1 /WAVE=o_order1
	o_order1 = {"Rb","Ba","Th","Nb","La","Ce","Nd","Sm","Eu","Gd","Dy","Er","Yb","Sc"}
	
	Make /O/N=0/T dfr:o_order2 /WAVE=o_order2
	o_order2 = {"Ba","Rb","Nb","La","Ce","Pr","Sr","Nd","Zr","Hf","Sm","Eu","Gd","Tb","Dy","Ho","Er","Y","Yb","Lu"}
	
	Make /O/N=0/T dfr:o_order3 /WAVE=o_order3
	o_order3 = {"Cs","Rb","Ba","Th","Pb","U","K","Ta","Nb","La","Ce","Sr","Nd","Hf","Zr","Sm","Eu","Ti","Gd","Tb","Dy","Ho","Er","Yb","Lu"}
	

	strRef = "Zhang (2014) Quantification of the elemental incompatibility\r"
	strRef += "sequence, and composition of the “superchondritic” mantle."
	Make /O/N=0/T dfr:o_Zhang /WAVE=o_Zhang
	note o_Zhang, strRef
	o_Zhang = {"Cs","Rb","Th","Ba","B","U","K","Nb","La","Be"}
	o_Zhang[10] = {"Ta","Li","F","P","Ce","Sr","Pr","Nd","Ti","Sm"}
	o_Zhang[20] = {"Eu","Hf","Gd","Zr","Tb","Dy","Na","Ho","Er","Tm"}
	o_Zhang[30] = {"Yb","Lu","Y","Cr","V"}
	
	CreateUserWaves(dfr)
	
	// -------------------- create normalizing waves ------------------------
	
	Make /O/N=93 dfr:n_template /WAVE=n_template
	// can use this to create new ones; examples follow :)
	int Z
	for (Z=1;Z<93;Z++)
		SetDimLabel 0, Z, $o_AtomicNo[Z], n_template
	endfor
	n_template = NaN

// *** Barrat et al ***
		
	// Barrat, J.A., Zanda, B., Moynier, F., Bollinger, C., Liorzou, C.,
	// Bayon, G. (2012) Geochemistry of CI chondrites: Major and trace
	// elements, and Cu and Zn Isotopes. Geochimica et Cosmochimica Acta
	// 83: 79–92.
	strRef = "Barrat, J.A., Zanda, B., Moynier, F., Bollinger, C., Liorzou, C.,\r"
	strRef += "Bayon, G. (2012) Geochemistry of CI chondrites: Major and trace\r"
	strRef += "elements, and Cu and Zn Isotopes. Geochimica et Cosmochimica Acta\r"
	strRef += "83, 79–92."
	Duplicate /O n_template dfr:n_CI /WAVE=n_CI
	note n_CI, strRef
	n_CI[%Li] = 1.44
	n_CI[%Be] = 0.0226
	n_CI[%Na] = 4800
	n_CI[%Mg] = 94200
	n_CI[%Al] = 7900
	n_CI[%Si] = 105200
	n_CI[%P] = 1010
	n_CI[%K] = 550
	n_CI[%Ca] = 8400
	n_CI[%Sc] = 5.85
	n_CI[%Ti] = 449
	n_CI[%V] = 52.4
	n_CI[%Cr] = 2627
	n_CI[%Mn] = 1910
	n_CI[%Fe] = 195200
	n_CI[%Co] = 519
	n_CI[%Ni] = 11300
	n_CI[%Cu] = 127
	n_CI[%Zn] = 303
	n_CI[%Ga] = 9.48
	n_CI[%Rb] = 2.33
	n_CI[%Sr] = 7.73
	n_CI[%Y] = 1.56
	n_CI[%Zr] = 3.52
	n_CI[%Nb] = 0.289
	n_CI[%Cs] = 0.189
	n_CI[%Ba] = 2.46
	n_CI[%La] = 0.235
	n_CI[%Ce] = 0.6
	n_CI[%Pr] = 0.091
	n_CI[%Nd] = 0.464
	n_CI[%Sm] = 0.153
	n_CI[%Eu] = 0.0586
	n_CI[%Gd] = 0.206
	n_CI[%Tb] = 0.0375
	n_CI[%Dy] = 0.254
	n_CI[%Ho] = 0.0566
	n_CI[%Er] = 0.166
	n_CI[%Tm] = 0.0262
	n_CI[%Yb] = 0.168
	n_CI[%Lu] = 0.0246
	n_CI[%Hf] = 0.107
	n_CI[%Ta] = 0.0148
	n_CI[%W] = 0.11
	n_CI[%Pb] = 2.69
	n_CI[%Th] = 0.0283
	n_CI[%U] = 0.0077

// *** McDonough and Sun ***

	// McDonough, W.F. & Sun, S.-s. (1995) The composition of the Earth
	strRef = "McDonough, W.F. & Sun, S.-s. (1995) The composition of the Earth"
	Duplicate /O n_template dfr:n_CI_MDS95 /WAVE=n_CI_MDS95
	note n_CI_MDS95, strRef
	n_CI_MDS95[%Li] = 1.5
	n_CI_MDS95[%Be] = 0.025
	n_CI_MDS95[%B] = 0.9
	n_CI_MDS95[%C] = 35000
	n_CI_MDS95[%N] = 3180
	n_CI_MDS95[%F] = 60
	n_CI_MDS95[%Na] = 5100
	n_CI_MDS95[%Mg] = 96500
	n_CI_MDS95[%Al] = 8600
	n_CI_MDS95[%Si] = 106500
	n_CI_MDS95[%P] = 1080
	n_CI_MDS95[%S] = 54000
	n_CI_MDS95[%Cl] = 680
	n_CI_MDS95[%K] = 550
	n_CI_MDS95[%Ca] = 9250
	n_CI_MDS95[%Sc] = 5.92
	n_CI_MDS95[%Ti] = 440
	n_CI_MDS95[%V] = 56
	n_CI_MDS95[%Cr] = 2650
	n_CI_MDS95[%Mn] = 1920
	n_CI_MDS95[%Fe] = 181000
	n_CI_MDS95[%Co] = 500
	n_CI_MDS95[%Ni] = 10500
	n_CI_MDS95[%Cu] = 120
	n_CI_MDS95[%Zn] = 310
	n_CI_MDS95[%Ga] = 9.2
	n_CI_MDS95[%Ge] = 31
	n_CI_MDS95[%As] = 1.85
	n_CI_MDS95[%Se] = 21
	n_CI_MDS95[%Br] = 3.57
	n_CI_MDS95[%Rb] = 2.3
	n_CI_MDS95[%Sr] = 7.25
	n_CI_MDS95[%Y] = 1.57
	n_CI_MDS95[%Zr] = 3.82
	n_CI_MDS95[%Nb] = 0.24
	n_CI_MDS95[%Mo] = 0.9
	n_CI_MDS95[%Ru] = 0.71
	n_CI_MDS95[%Rh] = 0.13
	n_CI_MDS95[%Pd] = 0.55
	n_CI_MDS95[%Ag] = 0.2
	n_CI_MDS95[%cd] = 0.71
	n_CI_MDS95[%In] = 0.08
	n_CI_MDS95[%Sn] = 1.65
	n_CI_MDS95[%Sb] = 0.14
	n_CI_MDS95[%Tc] = 2.33
	n_CI_MDS95[%I] = 0.45
	n_CI_MDS95[%Cs] = 0.19
	n_CI_MDS95[%Ba] = 2.41
	n_CI_MDS95[%La] = 0.237
	n_CI_MDS95[%Ce] = 0.613
	n_CI_MDS95[%Pr] = 0.0928
	n_CI_MDS95[%Nd] = 0.457
	n_CI_MDS95[%Sm] = 0.148
	n_CI_MDS95[%Eu] = 0.0563
	n_CI_MDS95[%Gd] = 0.199
	n_CI_MDS95[%Tb] = 0.0361
	n_CI_MDS95[%Dy] = 0.246
	n_CI_MDS95[%Ho] = 0.0546
	n_CI_MDS95[%Er] = 0.16
	n_CI_MDS95[%Tm] = 0.0247
	n_CI_MDS95[%Yb] = 0.161
	n_CI_MDS95[%Lu] = 0.0246
	n_CI_MDS95[%Hf] = 0.103
	n_CI_MDS95[%Ta] = 0.0136
	n_CI_MDS95[%W] = 0.093
	n_CI_MDS95[%Re] = 0.04
	n_CI_MDS95[%Os] = 0.49
	n_CI_MDS95[%Ir] = 0.455
	n_CI_MDS95[%Pt] = 1.01
	n_CI_MDS95[%Au] = 0.14
	n_CI_MDS95[%Hg] = 0.3
	n_CI_MDS95[%Tl] = 0.14
	n_CI_MDS95[%Pb] = 2.47
	n_CI_MDS95[%Bi] = 0.11
	n_CI_MDS95[%Th] = 0.029
	n_CI_MDS95[%U] = 0.0074
	
	Duplicate /O n_template dfr:n_BSE /WAVE=n_BSE
	note n_BSE, strRef
	n_BSE[%Li] = 1.6
	n_BSE[%Be] = 0.068
	n_BSE[%B] = 0.3
	n_BSE[%C] = 120
	n_BSE[%N] = 2
	n_BSE[%F] = 75
	n_BSE[%Na] = 2.67
	n_BSE[%Mg] = 228000
	n_BSE[%Al] = 23500
	n_BSE[%Si] = 210000
	n_BSE[%P] = 90
	n_BSE[%S] = 250
	n_BSE[%Cl] = 17
	n_BSE[%K] = 240
	n_BSE[%Ca] = 25300
	n_BSE[%Sc] = 16.2
	n_BSE[%Ti] = 1205
	n_BSE[%V] = 82
	n_BSE[%Cr] = 2625
	n_BSE[%Mn] = 1045
	n_BSE[%Fe] = 62600
	n_BSE[%Co] = 105
	n_BSE[%Ni] = 1960
	n_BSE[%Cu] = 30
	n_BSE[%Zn] = 55
	n_BSE[%Ga] = 4
	n_BSE[%Ge] = 1.1
	n_BSE[%As] = 0.05
	n_BSE[%Se] = 0.075
	n_BSE[%Br] = 0.05
	n_BSE[%Rb] = 0.6
	n_BSE[%Sr] = 19.9
	n_BSE[%Y] = 4.3
	n_BSE[%Zr] = 10.5
	n_BSE[%Nb] = 0.658
	n_BSE[%Mo] = 0.05
	n_BSE[%Ru] = 0.005
	n_BSE[%Rh] = 0.0009
	n_BSE[%Pd] = 0.0039
	n_BSE[%Ag] = 0.008
	n_BSE[%cd] = 0.04
	n_BSE[%In] = 0.011
	n_BSE[%Sn] = 0.13
	n_BSE[%Sb] = 0.0055
	n_BSE[%Tc] = 0.012
	n_BSE[%I] = 0.01
	n_BSE[%Cs] = 0.021
	n_BSE[%Ba] = 6.6
	n_BSE[%La] = 0.648
	n_BSE[%Ce] = 1.675
	n_BSE[%Pr] = 0.254
	n_BSE[%Nd] = 1.25
	n_BSE[%Sm] = 0.406
	n_BSE[%Eu] = 0.154
	n_BSE[%Gd] = 0.544
	n_BSE[%Tb] = 0.099
	n_BSE[%Dy] = 0.674
	n_BSE[%Ho] = 0.149
	n_BSE[%Er] = 0.438
	n_BSE[%Tm] = 0.068
	n_BSE[%Yb] = 0.441
	n_BSE[%Lu] = 0.0675
	n_BSE[%Hf] = 0.283
	n_BSE[%Ta] = 0.037
	n_BSE[%W] = 0.029
	n_BSE[%Re] = 0.00028
	n_BSE[%Os] = 0.0034
	n_BSE[%Ir] = 0.0032
	n_BSE[%Pt] = 0.0071
	n_BSE[%Au] = 0.001
	n_BSE[%Hg] = 0.01
	n_BSE[%Tl] = 0.0035
	n_BSE[%Pb] = 0.15
	n_BSE[%Bi] = 0.0025
	n_BSE[%Th] = 0.0795
	n_BSE[%U] = 0.0203
	
// *** Sun and McDonough ***
	
	// Sun, S.-s. & McDonough, W.F. (1989) Chemical and isotopic
	// systematics of oceanic basalts: implications for mantle composition
	// and processes. In: Saunders, A.D. & Norry, M.J. (eds), Magmatism in
	// the Ocean Basins, Geological Society Special Publication No. 42,
	// pp. 313-345.
	strRef = "Sun, S.-s. & McDonough, W.F. (1989) Chemical and isotopic\r"
	strRef += "systematics of oceanic basalts: implications for mantle composition\r"
	strRef += "and processes. In: Saunders, A.D. & Norry, M.J. (eds), Magmatism in\r"
	strRef += "the Ocean Basins, Geological Society Special Publication No. 42,\r"
	strRef += "pp. 313-345."
	// primitive mantle
	Duplicate /O n_template dfr:n_PM_SMD89 /WAVE=n_PM_SMD89
	note n_PM_SMD89, strRef
	n_PM_SMD89[%Cs] = 0.032
	n_PM_SMD89[%Tl] = 0.005
	n_PM_SMD89[%Rb] = 0.635
	n_PM_SMD89[%Ba] = 6.989
	n_PM_SMD89[%W] = 0.02
	n_PM_SMD89[%Th] = 0.085
	n_PM_SMD89[%U] = 0.021
	n_PM_SMD89[%Nb] = 0.713
	n_PM_SMD89[%Ta] = 0.041
	n_PM_SMD89[%K] = 250
	n_PM_SMD89[%La] = 0.687
	n_PM_SMD89[%Ce] = 1.775
	n_PM_SMD89[%Pb] = 0.185
	n_PM_SMD89[%Pr] = 0.276
	n_PM_SMD89[%Mo] = 0.063
	n_PM_SMD89[%Sr] = 21.1
	n_PM_SMD89[%P] = 95
	n_PM_SMD89[%Nd] = 1.354
	n_PM_SMD89[%F] = 26
	n_PM_SMD89[%Sm] = 0.444
	n_PM_SMD89[%Zr] = 11.2
	n_PM_SMD89[%Hf] = 0.309
	n_PM_SMD89[%Eu] = 0.168
	n_PM_SMD89[%Sn] = 0.17
	n_PM_SMD89[%Sb] = 0.005
	n_PM_SMD89[%Ti] = 1300
	n_PM_SMD89[%Gd] = 0.596
	n_PM_SMD89[%Tb] = 0.108
	n_PM_SMD89[%Dy] = 0.737
	n_PM_SMD89[%Li] = 1.6
	n_PM_SMD89[%Y] = 4.55
	n_PM_SMD89[%Ho] = 0.164
	n_PM_SMD89[%Er] = 0.48
	n_PM_SMD89[%Tm] = 0.074
	n_PM_SMD89[%Yb] = 0.493
	n_PM_SMD89[%Lu] = 0.074
	
	// 'normal' mid-ocean ridge basalt
	Duplicate /O n_template dfr:n_NMORB /WAVE=n_NMORB
	note n_NMORB, strRef
	n_NMORB[%Cs] = 0.007
	n_NMORB[%Tl] = 0.0014
	n_NMORB[%Rb] = 0.56
	n_NMORB[%Ba] = 6.3
	n_NMORB[%W] = 0.01
	n_NMORB[%Th] = 0.12
	n_NMORB[%U] = 0.047
	n_NMORB[%Nb] = 2.33
	n_NMORB[%Ta] = 0.132
	n_NMORB[%K] = 600
	n_NMORB[%La] = 2.5
	n_NMORB[%Ce] = 7.5
	n_NMORB[%Pb] = 0.3
	n_NMORB[%Pr] = 1.32
	n_NMORB[%Mo] = 0.31
	n_NMORB[%Sr] = 90
	n_NMORB[%P] = 510
	n_NMORB[%Nd] = 7.3
	n_NMORB[%F] = 210
	n_NMORB[%Sm] = 2.63
	n_NMORB[%Zr] = 74
	n_NMORB[%Hf] = 2.05
	n_NMORB[%Eu] = 1.02
	n_NMORB[%Sn] = 1.1
	n_NMORB[%Sb] = 0.01
	n_NMORB[%Ti] = 7600
	n_NMORB[%Gd] = 3.68
	n_NMORB[%Tb] = 0.67
	n_NMORB[%Dy] = 4.55
	n_NMORB[%Li] = 4.3
	n_NMORB[%Y] = 28
	n_NMORB[%Ho] = 1.01
	n_NMORB[%Er] = 2.97
	n_NMORB[%Tm] = 0.456
	n_NMORB[%Yb] = 3.05
	n_NMORB[%Lu] = 0.455
	
	// enriched mid-ocean ridge basalt
	Duplicate /O n_template dfr:n_EMORB /WAVE=n_EMORB
	note n_EMORB, strRef
	n_EMORB[%Cs] = 0.063
	n_EMORB[%Tl] = 0.013
	n_EMORB[%Rb] = 5.04
	n_EMORB[%Ba] = 57
	n_EMORB[%W] = 0.092
	n_EMORB[%Th] = 0.6
	n_EMORB[%U] = 0.18
	n_EMORB[%Nb] = 8.3
	n_EMORB[%Ta] = 0.47
	n_EMORB[%K] = 2100
	n_EMORB[%La] = 6.3
	n_EMORB[%Ce] = 15
	n_EMORB[%Pb] = 0.6
	n_EMORB[%Pr] = 2.05
	n_EMORB[%Mo] = 0.47
	n_EMORB[%Sr] = 155
	n_EMORB[%P] = 620
	n_EMORB[%Nd] = 9
	n_EMORB[%F] = 250
	n_EMORB[%Sm] = 2.6
	n_EMORB[%Zr] = 73
	n_EMORB[%Hf] = 2.03
	n_EMORB[%Eu] = 0.91
	n_EMORB[%Sn] = 0.8
	n_EMORB[%Sb] = 0.01
	n_EMORB[%Ti] = 6000
	n_EMORB[%Gd] = 2.97
	n_EMORB[%Tb] = 0.53
	n_EMORB[%Dy] = 3.55
	n_EMORB[%Li] = 3.5
	n_EMORB[%Y] = 22
	n_EMORB[%Ho] = 0.79
	n_EMORB[%Er] = 2.31
	n_EMORB[%Tm] = 0.356
	n_EMORB[%Yb] = 2.37
	n_EMORB[%Lu] = 0.354
	
	// ocean island basalt
	Duplicate /O n_template dfr:n_OIB /WAVE=n_OIB
	note n_OIB, strRef
	n_OIB[%Cs] = 0.387
	n_OIB[%Tl] = 0.077
	n_OIB[%Rb] = 31
	n_OIB[%Ba] = 350
	n_OIB[%W] = 0.56
	n_OIB[%Th] = 4
	n_OIB[%U] = 1.02
	n_OIB[%Nb] = 48
	n_OIB[%Ta] = 2.7
	n_OIB[%K] = 12000
	n_OIB[%La] = 37
	n_OIB[%Ce] = 80
	n_OIB[%Pb] = 3.2
	n_OIB[%Pr] = 9.7
	n_OIB[%Mo] = 2.4
	n_OIB[%Sr] = 660
	n_OIB[%P] = 2700
	n_OIB[%Nd] = 38.5
	n_OIB[%F] = 1150
	n_OIB[%Sm] = 10
	n_OIB[%Zr] = 280
	n_OIB[%Hf] = 7.8
	n_OIB[%Eu] = 3
	n_OIB[%Sn] = 2.7
	n_OIB[%Sb] = 0.03
	n_OIB[%Ti] = 17200
	n_OIB[%Gd] = 7.62
	n_OIB[%Tb] = 1.05
	n_OIB[%Dy] = 5.6
	n_OIB[%Li] = 5.6
	n_OIB[%Y] = 29
	n_OIB[%Ho] = 1.06
	n_OIB[%Er] = 2.62
	n_OIB[%Tm] = 0.35
	n_OIB[%Yb] = 2.16
	n_OIB[%Lu] = 0.3
	
// *** Rudnick and Gao ***
	
	// Rudnick, R.L and Gao, S. (2003) Composition of the Continental
	// Crust. In Treatise on Geochemistry.
	strRef = "Rudnick, R.L and Gao, S. (2003) Composition of the\r"
	strRef += "Continental Crust. In Treatise on Geochemistry."
	// bulk continental crust
	Duplicate /O n_template dfr:n_CCrust /WAVE=n_CCrust
	note n_CCrust, strRef
	n_CCrust[%Li] = 16
	n_CCrust[%Be] = 1.9
	n_CCrust[%B] = 11

	n_CCrust[%N] = 56
	n_CCrust[%F] = 553
	n_CCrust[%Na] = 22997.58951
	n_CCrust[%Mg] = 28342.96844
	n_CCrust[%Al] = 84151.79482
	n_CCrust[%Si] = 283266.9762
	n_CCrust[%P] = 436.4351134
	n_CCrust[%S] = 404
	n_CCrust[%Cl] = 244
	n_CCrust[%K] = 14942.65999
	n_CCrust[%Ca] = 45740.53534
	n_CCrust[%Sc] = 21.9
	n_CCrust[%Ti] = 4195.846217
	n_CCrust[%V] = 138
	n_CCrust[%Cr] = 135
	n_CCrust[%Mn] = 774.4618464
	n_CCrust[%Fe] = 52080.12972
	n_CCrust[%Co] = 26.6
	n_CCrust[%Ni] = 59
	n_CCrust[%Cu] = 27
	n_CCrust[%Zn] = 72
	n_CCrust[%Ga] = 16
	n_CCrust[%Ge] = 1.3
	n_CCrust[%As] = 2.5
	n_CCrust[%Se] = 0.13
	n_CCrust[%Br] = 0.88
	n_CCrust[%Rb] = 49
	n_CCrust[%Sr] = 320
	n_CCrust[%Y] = 19
	n_CCrust[%Zr] = 132
	n_CCrust[%Nb] = 8
	n_CCrust[%Mo] = 0.8
	n_CCrust[%Ru] = 0.0006

	n_CCrust[%Pd] = 0.0015
	n_CCrust[%Ag] = 0.056
	n_CCrust[%cd] = 0.08
	n_CCrust[%In] = 0.052
	n_CCrust[%Sn] = 1.7
	n_CCrust[%Sb] = 0.2

	n_CCrust[%I] = 0.7
	n_CCrust[%Cs] = 2
	n_CCrust[%Ba] = 456
	n_CCrust[%La] = 20
	n_CCrust[%Ce] = 43
	n_CCrust[%Pr] = 4.9
	n_CCrust[%Nd] = 20
	n_CCrust[%Sm] = 3.9
	n_CCrust[%Eu] = 1.1
	n_CCrust[%Gd] = 3.7
	n_CCrust[%Tb] = 0.6
	n_CCrust[%Dy] = 3.6
	n_CCrust[%Ho] = 0.77
	n_CCrust[%Er] = 2.1
	n_CCrust[%Tm] = 0.28
	n_CCrust[%Yb] = 1.9
	n_CCrust[%Lu] = 0.3
	n_CCrust[%Hf] = 3.7
	n_CCrust[%Ta] = 0.7
	n_CCrust[%W] = 1
	n_CCrust[%Re] = 0.000188
	n_CCrust[%Os] = 0.000041
	n_CCrust[%Ir] = 0.000037
	n_CCrust[%Pt] = 0.0015
	n_CCrust[%Au] = 0.0013
	n_CCrust[%Hg] = 0.03
	n_CCrust[%Tl] = 0.5
	n_CCrust[%Pb] = 11
	n_CCrust[%Bi] = 0.18
	n_CCrust[%Th] = 5.6
	n_CCrust[%U] = 1.3
		
	// upper continental crust
	Duplicate /O n_template dfr:n_UCC /WAVE=n_UCC
	note n_UCC, strRef
	n_UCC[%Si] = 311313
	n_UCC[%Ti] = 3836
	n_UCC[%Al] = 81505
	n_UCC[%Fe] = 39176
	n_UCC[%Mn] = 774
	n_UCC[%Mg] = 14955
	n_UCC[%Ca] = 25657
	n_UCC[%Na] = 24258
	n_UCC[%K] = 23244
	n_UCC[%P] = 654
	n_UCC[%Li] = 24
	n_UCC[%Be] = 2.1
	n_UCC[%B] = 17
	n_UCC[%N] = 83
	n_UCC[%F] = 557
	n_UCC[%S] = 62
	n_UCC[%Cl] = 370
	n_UCC[%Sc] = 14
	n_UCC[%V] = 97
	n_UCC[%Cr] = 92
	n_UCC[%Co] = 17.3
	n_UCC[%Ni] = 47
	n_UCC[%Cu] = 28
	n_UCC[%Zn] = 67
	n_UCC[%Ga] = 17.5
	n_UCC[%Ge] = 1.4
	n_UCC[%As] = 4.8
	n_UCC[%Se] = 0.09
	n_UCC[%Br] = 1.6
	n_UCC[%Rb] = 84
	n_UCC[%Sr] = 320
	n_UCC[%Y] = 21
	n_UCC[%Zr] = 193
	n_UCC[%Nb] = 12
	n_UCC[%Mo] = 1.1
	n_UCC[%Ru] = 0.00034
	n_UCC[%Pd] = 0.00052
	n_UCC[%Ag] = 0.053
	n_UCC[%cd] = 0.09
	n_UCC[%In] = 0.056
	n_UCC[%Sn] = 2.1
	n_UCC[%Sb] = 0.4
	n_UCC[%I] = 1.4
	n_UCC[%Cs] = 4.9
	n_UCC[%Ba] = 628
	n_UCC[%La] = 31
	n_UCC[%Ce] = 63
	n_UCC[%Pr] = 7.1
	n_UCC[%Nd] = 27
	n_UCC[%Sm] = 4.7
	n_UCC[%Eu] = 1
	n_UCC[%Gd] = 4
	n_UCC[%Tb] = 0.7
	n_UCC[%Dy] = 3.9
	n_UCC[%Ho] = 0.83
	n_UCC[%Er] = 2.3
	n_UCC[%Tm] = 0.3
	n_UCC[%Yb] = 1.96
	n_UCC[%Lu] = 0.31
	n_UCC[%Hf] = 5.3
	n_UCC[%Ta] = 0.9
	n_UCC[%W] = 1.9
	n_UCC[%Re] = 0.000198
	n_UCC[%Os] = 0.000031
	n_UCC[%Ir] = 0.000022
	n_UCC[%Pt] = 0.0005
	n_UCC[%Au] = 0.0015
	n_UCC[%Hg] = 0.05
	n_UCC[%Tl] = 0.9
	n_UCC[%Pb] = 17
	n_UCC[%Bi] = 0.16
	n_UCC[%Th] = 10.5
	n_UCC[%U] = 2.7

// *** Pearce et al ***
	
	// Pearce, J.A., Harris, N.B.W. and Tindle, A.G. (1984) Trace Element
	// Discrimination Diagrams for the Tectonic Interpretation of Granitic
	// Rocks. Journal of Petrology, 25: 956-983.
	strRef = "Pearce, J.A., Harris, N.B.W. and Tindle, A.G. (1984) Trace Element\r"
	strRef += "Discrimination Diagrams for the Tectonic Interpretation of Granitic\r"
	strRef += "Rocks. Journal of Petrology, 25, 956-983."
	// ocean ridge granite
	Duplicate /O n_template dfr:n_ORG /WAVE=n_ORG
	note n_ORG, strRef
	n_ORG[%K] = 0.332
	n_ORG[%Rb] = 4
	n_ORG[%Ba] = 50
	n_ORG[%Th] = 0.8
	n_ORG[%Ta] = 0.7
	n_ORG[%Nb] = 10
	n_ORG[%Ce] = 35
	n_ORG[%Hf] = 9
	n_ORG[%Zr] = 340
	n_ORG[%Sm] = 9
	n_ORG[%Y] = 70
	n_ORG[%Yb] = 80
	
// *** Lodders and Fegley ***
	
	// extracted from Lyubetskaya and Korenaga, Br corrected
	strRef = "Lodders, K., and Fegley, B. (1998) The Planetary\r"
	strRef += "Science Companion, Oxford Univ. Press, New York."
	Duplicate /O n_template dfr:n_CI_LF98 /WAVE=n_CI_LF98
	note n_CI_LF98, strRef
	n_CI_LF98[%Li] = 1.5
	n_CI_LF98[%Be] = 0.025
	n_CI_LF98[%B] = 0.87
	n_CI_LF98[%F] = 60
	n_CI_LF98[%Na] = 5000
	n_CI_LF98[%Mg] = 97000
	n_CI_LF98[%Al] = 8650
	n_CI_LF98[%Si] = 106400
	n_CI_LF98[%P] = 950
	n_CI_LF98[%S] = 54100
	n_CI_LF98[%Cl] = 700
	n_CI_LF98[%K] = 550
	n_CI_LF98[%Ca] = 9260
	n_CI_LF98[%Sc] = 5.9
	n_CI_LF98[%Ti] = 440
	n_CI_LF98[%V] = 55
	n_CI_LF98[%Cr] = 2650
	n_CI_LF98[%Mn] = 1940
	n_CI_LF98[%Fe] = 182000
	n_CI_LF98[%Co] = 505
	n_CI_LF98[%Ni] = 11000
	n_CI_LF98[%Cu] = 125
	n_CI_LF98[%Zn] = 315
	n_CI_LF98[%Ga] = 9.8
	n_CI_LF98[%Ge] = 33
	n_CI_LF98[%As] = 1.85
	n_CI_LF98[%Se] = 21
	n_CI_LF98[%Br] = 3.5
	n_CI_LF98[%Rb] = 2.3
	n_CI_LF98[%Sr] = 7.3
	n_CI_LF98[%Y] = 1.56
	n_CI_LF98[%Zr] = 3.9
	n_CI_LF98[%Nb] = 0.25
	n_CI_LF98[%Mo] = 0.92
	n_CI_LF98[%Ru] = 0.71
	n_CI_LF98[%Rh] = 0.14
	n_CI_LF98[%Pd] = 0.56
	n_CI_LF98[%Ag] = 0.2
	n_CI_LF98[%cd] = 0.69
	n_CI_LF98[%In] = 0.08
	n_CI_LF98[%Sn] = 1.7
	n_CI_LF98[%Sb] = 0.135
	n_CI_LF98[%Te] = 2.3
	n_CI_LF98[%I] = 0.43
	n_CI_LF98[%Cs] = 0.19
	n_CI_LF98[%Ba] = 2.35
	n_CI_LF98[%La] = 0.235
	n_CI_LF98[%Ce] = 0.62
	n_CI_LF98[%Pr] = 0.094
	n_CI_LF98[%Nd] = 0.46
	n_CI_LF98[%Sm] = 0.15
	n_CI_LF98[%Eu] = 0.057
	n_CI_LF98[%Gd] = 0.2
	n_CI_LF98[%Tb] = 0.037
	n_CI_LF98[%Dy] = 0.25
	n_CI_LF98[%Ho] = 0.056
	n_CI_LF98[%Er] = 0.16
	n_CI_LF98[%Tm] = 0.025
	n_CI_LF98[%Yb] = 0.16
	n_CI_LF98[%Lu] = 0.025
	n_CI_LF98[%Hf] = 0.105
	n_CI_LF98[%Ta] = 0.014
	n_CI_LF98[%W] = 0.093
	n_CI_LF98[%Re] = 0.038
	n_CI_LF98[%Os] = 0.49
	n_CI_LF98[%Ir] = 0.465
	n_CI_LF98[%Pt] = 1
	n_CI_LF98[%Au] = 0.145
	n_CI_LF98[%Hg] = 0.31
	n_CI_LF98[%Tl] = 0.142
	n_CI_LF98[%Pb] = 2.53
	n_CI_LF98[%Bi] = 0.11
	n_CI_LF98[%Th] = 0.029
	n_CI_LF98[%U] = 0.008
	
// *** Lyubetskaya and Korenaga ***
	
	// Br corrected, ppb should be ppm
	strRef = "Lyubetskaya, T., and Korenaga, J. (2007) Chemical composition"
	strRef += "of Earth’s primitive mantle and its variance: 1. Method and\r"
	strRef += "results. J. Geophys. Res., 112, B03211."
	Duplicate /O n_template dfr:n_PM_LK07 /WAVE=n_PM_LK07
	note n_PM_LK07, strRef
	n_PM_LK07[%Li] = 1.6
	n_PM_LK07[%Be] = 0.054
	n_PM_LK07[%B] = 0.17
	n_PM_LK07[%F] = 18
	n_PM_LK07[%Na] = 2220
	n_PM_LK07[%Mg] = 234100
	n_PM_LK07[%Al] = 18700
	n_PM_LK07[%Si] = 210900
	n_PM_LK07[%P] = 66
	n_PM_LK07[%S] = 230
	n_PM_LK07[%Cl] = 1.4
	n_PM_LK07[%K] = 190
	n_PM_LK07[%Ca] = 20000
	n_PM_LK07[%Sc] = 12.7
	n_PM_LK07[%Ti] = 950
	n_PM_LK07[%V] = 74
	n_PM_LK07[%Cr] = 2645
	n_PM_LK07[%Mn] = 1020
	n_PM_LK07[%Fe] = 62200
	n_PM_LK07[%Co] = 105
	n_PM_LK07[%Ni] = 1985
	n_PM_LK07[%Cu] = 25
	n_PM_LK07[%Zn] = 58
	n_PM_LK07[%Ga] = 4.2
	n_PM_LK07[%Ge] = 1.15
	n_PM_LK07[%As] = 0.05
	n_PM_LK07[%Se] = 0.075
	n_PM_LK07[%Br] = 3.6
	n_PM_LK07[%Rb] = 0.457
	n_PM_LK07[%Sr] = 15.8
	n_PM_LK07[%Y] = 3.37
	n_PM_LK07[%Zr] = 8.42
	n_PM_LK07[%Nb] = 0.46
	n_PM_LK07[%Mo] = 0.03
	n_PM_LK07[%Ru] = 0.005
	n_PM_LK07[%Rh] = 0.0009
	n_PM_LK07[%Pd] = 0.0036
	n_PM_LK07[%Ag] = 0.004
	n_PM_LK07[%cd] = 0.05
	n_PM_LK07[%In] = 0.0101
	n_PM_LK07[%Sn] = 0.103
	n_PM_LK07[%Sb] = 0.007
	n_PM_LK07[%Te] = 0.008
	n_PM_LK07[%I] = 0.01
	n_PM_LK07[%Cs] = 0.016
	n_PM_LK07[%Ba] = 5.08
	n_PM_LK07[%La] = 0.508
	n_PM_LK07[%Ce] = 1.34
	n_PM_LK07[%Pr] = 0.203
	n_PM_LK07[%Nd] = 0.994
	n_PM_LK07[%Sm] = 0.324
	n_PM_LK07[%Eu] = 0.123
	n_PM_LK07[%Gd] = 0.432
	n_PM_LK07[%Tb] = 0.08
	n_PM_LK07[%Dy] = 0.54
	n_PM_LK07[%Ho] = 0.121
	n_PM_LK07[%Er] = 0.346
	n_PM_LK07[%Tm] = 0.054
	n_PM_LK07[%Yb] = 0.346
	n_PM_LK07[%Lu] = 0.054
	n_PM_LK07[%Hf] = 0.227
	n_PM_LK07[%Ta] = 0.0302
	n_PM_LK07[%W] = 0.0119
	n_PM_LK07[%Re] = 0.00032
	n_PM_LK07[%Os] = 0.0034
	n_PM_LK07[%Ir] = 0.0032
	n_PM_LK07[%Pt] = 0.0066
	n_PM_LK07[%Au] = 0.00088
	n_PM_LK07[%Hg] = 0.006
	n_PM_LK07[%Tl] = 0.002
	n_PM_LK07[%Pb] = 0.144
	n_PM_LK07[%Bi] = 0.004
	n_PM_LK07[%Th] = 0.0626
	n_PM_LK07[%U] = 0.0173

	
	// need more of these...
	
	// ---------------------- end of reference data -----------------------
	
	NewDataFolder /O dfr:spiderData
	spider_makePanel()
end

static function spider_makePanel()
	
	DFREF dfr = root:Packages:spidergram
	wave /T w_newwavelist = ListToTextWave(spider_datawaves(), ";")
	Duplicate /O w_newwavelist dfr:w_wavelist /wave=w_wavelist
	KillWaves /Z w_newwavelist
	Make /O/N=(numpnts(w_wavelist)) dfr:w_waveselection /wave=w_waveselection
	
	int i = 0, deltaY = 23, left = 20, top = 10, groupw = 200, font = 12, grout = 10
	
	DoWindow /k spiderpanel
	NewPanel /K=1/N=spiderpanel/W=(0,0,740,420) as "Spidergram"
	ModifyPanel /W=spiderpanel, noEdit=1
	
	string cmd = "spiderdata" // set default save location
	cmd = SelectString(DataFolderExists(cmd) , cmd, UniqueName(cmd, 11, 1))
	
	GroupBox group0, pos={left-grout,top+deltaY*i}, size={groupw,deltaY*8}, title="Data selection"
	GroupBox group0, fSize=font
	i += 1
	// store values internally in these controls
	PopupMenu popElements, mode=1, Value=WaveList("*", ";", "DIMS:1,TEXT:1"), title="Elements",pos={left,top+deltaY*i},size={220,20}
	PopupMenu popElements, help={"select elements wave" }, Proc=spidergram#spider_popup,fSize=font
	i += 1
	ListBox listboxWaves, win=spiderpanel, pos={left,top+deltaY*i},size={groupw-2*grout, deltaY*4.7}, listwave=w_wavelist, selwave=w_waveselection, mode=9
	ListBox listboxWaves, win=spiderpanel,  Proc=spidergram#spider_ListBox
	spider_setSelecter()
	i += 5
	CheckBox check_ppm, pos={left,top+deltaY*i}, fsize=font, value=1, Proc=spidergram#spider_checkbox, title="ppm"
	CheckBox check_ppm, mode=1,help={"input data in ppm"}
	CheckBox check_pc, pos={left+80,top+deltaY*i}, fsize=font, value=0, Proc=spidergram#spider_checkbox, title="wt. % "
	CheckBox check_pc, mode=1,help={"input data in wt. %"}
	i += 1.5
	GroupBox group1, pos={left-grout,top+deltaY*i},size={groupw,deltaY*4},title="Data treatment"
	GroupBox group1, fSize=font
	i += 1
	PopupMenu popOrder, mode=1, Value="data;"+spidergram#spider_waves(2), title="Plot order",pos={left,top+deltaY*i},size={130,20}
	PopupMenu popOrder, help={"Select element order for output" }, Proc=spidergram#spider_popup,fSize=font, popmatch="REE"
	Button btnEdit title="Edit", help={"Edit custom element order"}, pos={left+140,top+deltaY*i},size={40,18}, Proc=spidergram#spider_button, disable=1
	i += 1
	PopupMenu popNorm, mode=1, Value="none;"+spidergram#spider_waves(1), title="Normalize to",pos={left,top+deltaY*i},size={130,20}
	PopupMenu popNorm, help={"Select normalization scheme" }, Proc=spidergram#spider_popup,fSize=font, popmatch="CI"
	i += 1
	CheckBox checkSkip, pos={left,top+deltaY*i}, fsize=font, value=1, Proc=spidergram#spider_checkbox, title="Skip blanks"
	CheckBox checkSkip, mode=0,help={"Don't plot elements that aren't in input data"}
	CheckBox checkNum, pos={left+100,top+deltaY*i}, fsize=font, value=1, Proc=spidergram#spider_checkbox, title="Ignore #s"
	CheckBox checkNum, mode=0,help={"Strip numbers from the elements wave"}
	i += 1.5
	GroupBox group2,pos={left-grout,top+deltaY*i},size={groupw,deltaY*4.3},title="Data output"
	GroupBox group2,fSize=font
	i += 1
	SetVariable setvarDF,pos={left,top+deltaY*i},size={180,16},title="Save to:"
	SetVariable setvarDF,value=_STR:cmd, Proc=spidergram#spider_setVar
	SetVariable setvarDF,help={"Name for output data folder"}, fsize=font
	i += 1
	CheckBox checkPlot, pos={left,top+deltaY*i}, fsize=font, value=1, title="New plot"
	CheckBox checkPlot, mode=0,help={"Plot output in new graph window"}
	CheckBox checkTable, pos={left+90,top+deltaY*i}, fsize=font, value=1, title="Make table"
	CheckBox checkTable, mode=0,help={"Edit output in new table"}
	i += 1
	Button btnSave,pos={left+135,top+deltaY*i},size={45,20},title="Do It", Proc=spidergram#spider_button
	Button btnSave,help={"Save a copy of the output"}
	
	// resizing userdata for controls
	GroupBox group0,userdata(ResizeControlsInfo)= A"!!,A.!!#;-!!#AW!!#AGz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	GroupBox group0,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#u:Du]k<zzzzzzzzzzz"
	GroupBox group0,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	PopupMenu popElements,userdata(ResizeControlsInfo)= A"!!,BY!!#=g!!#?O!!#<Xz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	PopupMenu popElements,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#u:Du]k<zzzzzzzzzzz"
	PopupMenu popElements,userdata(ResizeControlsInfo) += A"zzz!!#u:Du]k<zzzzzzzzzzzzzz!!!"
	ListBox listboxWaves,userdata(ResizeControlsInfo)= A"!!,BY!!#>n!!#AC!!#@<z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	ListBox listboxWaves,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#u:Du]k<zzzzzzzzzzz"
	ListBox listboxWaves,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	CheckBox check_ppm,userdata(ResizeControlsInfo)= A"!!,BY!!#A:!!#>6!!#<(z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	CheckBox check_ppm,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	CheckBox check_ppm,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	CheckBox check_pc,userdata(ResizeControlsInfo)= A"!!,F-!!#A:!!#>Z!!#<(z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	CheckBox check_pc,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	CheckBox check_pc,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	GroupBox group1,userdata(ResizeControlsInfo)= A"!!,A.!!#A\\!!#AW!!#?qz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	GroupBox group1,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	GroupBox group1,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	PopupMenu popOrder,userdata(ResizeControlsInfo)= A"!!,BY!!#As!!#@B!!#<pz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	PopupMenu popOrder,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	PopupMenu popOrder,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	PopupMenu popNorm,userdata(ResizeControlsInfo)= A"!!,BY!!#B5!!#@N!!#<pz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	PopupMenu popNorm,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	PopupMenu popNorm,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	CheckBox checkSkip,userdata(ResizeControlsInfo)= A"!!,BY!!#BC!!#?]!!#<8z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	CheckBox checkSkip,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	CheckBox checkSkip,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	CheckBox checkNum,userdata(ResizeControlsInfo)= A"!!,FU!!#BC!!#?E!!#<8z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	CheckBox checkNum,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	CheckBox checkNum,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	GroupBox group2,userdata(ResizeControlsInfo)= A"!!,A.!!#BTJ,hr-!!#@(z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	GroupBox group2,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	GroupBox group2,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	SetVariable setvarDF,userdata(ResizeControlsInfo)= A"!!,BY!!#B`!!#AC!!#<Hz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	SetVariable setvarDF,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	SetVariable setvarDF,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	CheckBox checkPlot,userdata(ResizeControlsInfo)= A"!!,BY!!#BkJ,hoj!!#<8z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	CheckBox checkPlot,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	CheckBox checkPlot,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	CheckBox checkTable,userdata(ResizeControlsInfo)= A"!!,FA!!#BkJ,hp-!!#<8z!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	CheckBox checkTable,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	CheckBox checkTable,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	Button btnSave,userdata(ResizeControlsInfo)= A"!!,G+!!#C\"!!#>B!!#<Xz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	Button btnSave,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	Button btnSave,userdata(ResizeControlsInfo) += A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	Button btnEdit,userdata(ResizeControlsInfo)=A"!!,G0!!#As!!#>.!!#<Hz!!#](Aon\"Qzzzzzzzzzzzzzz!!#](Aon\"Qzz"
	Button btnEdit,userdata(ResizeControlsInfo)+=A"zzzzzzzzzzzz!!#?(FEDG<zzzzzzzzzzz"
	Button btnEdit,userdata(ResizeControlsInfo)+=A"zzz!!#?(FEDG<zzzzzzzzzzzzzz!!!"
	// resizing user data for panel window
	SetWindow kwTopWin,userdata(ResizeControlsInfo)= A"!!*'\"z!!#DI!!#C7zzzzzzzzzzzzzzzzzzzzz"
	SetWindow kwTopWin,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzzzzzzzzzzzzzzz"
	SetWindow kwTopWin,userdata(ResizeControlsInfo) += A"zzzzzzzzzzzzzzzzzzz!!!"
	
	// resizing panel hook
	SetWindow kwTopWin, hook(ResizeControls)=ResizeControls#ResizeControlsHook
	
	// create graph subwindow
	DefineGuide/W=spiderpanel guideL={FL,220}
	DefineGuide/W=spiderpanel guideB={FB,-10}
	DefineGuide/W=spiderpanel guideR={FR,-10}
	Display /W=(220,10,730,410)/FG=(guideL,$"",guideR,guideB) /HOST=SpiderPanel/N=spidergraph
	ModifyGraph /W=SpiderPanel#spidergraph frameStyle=7
	spider_style("spiderpanel#spidergraph")
	SetActiveSubwindow SpiderPanel
	#if IgorVersion() >= 7
		SetWindow SpiderPanel#spidergraph, activeChildFrame=0
	#endif
	SetWindow SpiderPanel, hook(hPaste)=spidergram#hookSpiderPanel
	
	if (IgorVersion() < 9)
		// this fixes a rendering problem on Igor 8, Mac OS 11
		GetWindow SpiderPanel  wsize
		MoveWindow /W=SpiderPanel V_left, V_top, V_right+1,  V_bottom
	endif
	
	spider_update()
end

static function spider_setvar(STRUCT WMsetVariableAction &s)
	if (s.eventcode != 8)
		return 0
	endif
	string cmd = CleanupName(s.sval,0)
	SetVariable $s.ctrlName, win=$s.win, value=_STR:cmd
	if (DataFolderExists(cmd))
		SetVariable $s.ctrlName, win=$s.win, valueBackColor=(65535,0,0)
	else
		SetVariable $s.ctrlName, win=$s.win, valueBackColor=(65535,65535,65535)
	endif
end

static function spider_button(STRUCT WMButtonAction &s)
	if (s.eventCode != 2)
		return 0
	endif
	if (cmpstr(s.ctrlName, "btnEdit") == 0)
		editCustomOrder()
	elseif (cmpstr(s.ctrlName, "btnSave") == 0)
		spider_save()
	endif
	return 0
end

static function editCustomOrder()
	DFREF dfr = root:Packages:spidergram
	wave /T custom = dfr:o_Custom
	if (WaveExists(custom) == 0)
		Make /T/N=0 dfr:o_Custom /WAVE=custom
	endif
	KillWindow /Z SpiderTable
	Edit /K=1/N=SpiderTable custom as "Edit custom element order"
	SetWindow SpiderTable, hook(hTable)=spidergram#hookTable
end

static function spider_checkbox(STRUCT WMCheckboxAction &s)
	if (s.eventCode != 2)
		return 0
	endif
	if (stringmatch(s.ctrlName, "check_ppm"))
		CheckBox check_pc, win=$s.win, value=0
	endif
	if (stringmatch(s.ctrlName, "check_pc"))
		CheckBox check_ppm, win=$s.win, value=0
	endif
	spider_update()
end

static function spider_popup(STRUCT WMPopupAction &s)
	if (s.eventCode != 2)
		return 0
	endif
	if (cmpstr(s.ctrlName, "popElements") == 0)
		// set wave selector
		spider_setSelecter()
	elseif (GrepString(s.ctrlName, "popNorm|popOrder"))
		spider_setPopupHelp(s)
		if (cmpstr(s.ctrlName, "popOrder") == 0)
			Button btnEdit win=$s.win, disable=cmpstr(s.popStr, "Custom")
		endif
	endif
	spider_update()
	return 0
end

static function spider_setPopupHelp(STRUCT WMPopupAction &s)
	DFREF dfr = root:Packages:spidergram
	string strHelp = ""
	if (cmpstr(s.ctrlName, "popNorm") == 0)
		wave /Z w = dfr:$"n_"+s.popStr
		strHelp = "Select normalization scheme"
	elseif (cmpstr(s.ctrlName, "popOrder") == 0)
		wave /Z w = dfr:$"o_"+s.popStr
		strHelp = "Select element order for output"
	endif
	if (WaveExists(w))
		strHelp = SelectString(strlen(note(w))>0, strHelp, note(w))
	endif
	PopupMenu $s.ctrlName, win=$s.win, help={strHelp}
end

static function /T spider_waves(type)
	int type // 1=numeric n_waves, 2=text o_waves
	
	DFREF dfr = root:Packages:Spidergram
	string s_list = "", s_wave = ""
	int i = 0, imax = CountObjectsDFR(dfr, 1)
	for (i=0;i<imax;i++)
		s_wave = GetIndexedObjNameDFR(dfr, 1, i)
		if (type==1 && stringmatch(s_wave, "n_*"))
			s_list = AddListItem(s_wave[2,strlen(s_wave)-1], s_list)
		elseif (type==2 && stringmatch(s_wave, "o_*"))
			s_list = AddListItem(s_wave[2,strlen(s_wave)-1], s_list)
		endif
	endfor
	s_list = RemoveFromList("template", s_list)
	s_list = SortList(s_list)
	return s_list
end

static function /T spider_datawaves()
	string s_value = ""
	ControlInfo /W=SpiderPanel popElements
	wave /Z/T w = $s_value
	if (WaveExists(w) == 0)
		return ""
	endif
	int n = numpnts(w)
	string optionsStr = ""
	sprintf optionsStr, "DIMS:1,TEXT:0,MAXROWS:%d,MINROWS:%d", n, n
	return WaveList("*", ";", optionsStr)
end

static function spider_setSelecter()
	DFREF dfr = root:Packages:spidergram
	wave /T w_newlist = ListToTextWave(spider_datawaves(), ";")
	Make /O/N=(numpnts(w_newlist)) dfr:w_waveselection /wave=w_waveselection
	w_waveselection = 0
	Make /O/T/N=(numpnts(w_newlist)) dfr:w_wavelist /wave=w_wavelist
	w_wavelist = w_newlist
end

// Process the data and update preview plot. Removes all traces from the 
// preview plot, reprocesses all the selected data and replots 
// everything. That sounds inefficient, but the number of points in each 
// wave is limited to the number of elements in the periodic table and 
// things seem to update nicely for a reasonable number of input waves :)
static function spider_update()
	
	DFREF dfr = root:Packages:Spidergram
	DFREF spider = dfr:spiderData
	
	do // remove all traces from plot
		RemoveFromGraph /Z/W=spiderpanel#spidergraph $StringFromList(0,TraceNameList("spiderpanel#spidergraph",";",1+4))
	while (strlen(TraceNameList("spiderpanel#spidergraph", ";", 1+4)))
	
	ControlInfo /W=spiderpanel popElements
	
	// for Igor 6 compatibility
	if (exists(s_value) == 0)
		return 0
	endif
	
	wave /Z/T w_elements = $s_value
	if (WaveExists(w_elements) == 0)
		return 0
	endif
	ControlInfo /W=spiderpanel popOrder
	wave /Z/T w_order = dfr:$"o_" + s_value
	ControlInfo /W=spiderpanel popNorm
	wave /Z w_norm = dfr:$"n_" + s_value
	ControlInfo /W=spiderpanel checkSkip
	int skipBlanks = v_value
	ControlInfo /W=spiderpanel check_ppm
	variable mult = v_value ? 1 : 1e4
	ControlInfo /W=spiderpanel checkNum
	int IgnoreNumbers = v_value
	
	if (!(WaveExists(w_elements) ))
		return 0
	endif
	
	int i, j, n, nn
	string s = ""
	
	Make /T/free/N = (numpnts(w_elements)) w_cat = ""
	w_cat = SelectString(IgnoreNumbers, w_elements, spider_RemoveNumbers(w_elements) )
	if (WaveExists(w_order) == 0)
		Duplicate /free/T w_elements w_order
		if (IgnoreNumbers)
			w_order = spider_RemoveNumbers(w_order)
		endif
		Extract /T/O w_order, w_order, strlen(w_order) > 0
	endif
	
	Make /T/N=0/O spider:elements /wave=e_out
	n = numpnts(w_order)
	for (i=0;i<n;i++)
		FindValue /TEXT=w_order[i]/TXOP=3/Z w_cat
		if (v_value > -1)
			e_out[numpnts(e_out)] = {w_cat[v_value]}
		elseif (skipBlanks == 0)
			e_out[numpnts(e_out)] = {w_order[i]}
		endif
	endfor
		
	wave /T w_wavelist = dfr:w_wavelist
	wave w_waveselection = dfr:w_waveselection
	
	Make /N=0/O/WAVE dfr:wavs /wave=wavs
	nn = numpnts(w_wavelist)
	if (nn == 0)
		return 0
	endif
	
	for (i=0;i<nn;i++)
		wave /Z w = $w_wavelist[i]
		if (WaveExists(w) && w_waveselection[i])
			wavs[numpnts(wavs)] = {w}
		endif
	endfor
	
	nn = numpnts(wavs)
	if (nn == 0)
		return 0
	endif
	
	n = numpnts(w_order)
	for (j=0;j<nn;j++)
		Make /O/N=0 spider:$(NameOfWave(wavs[j])+"_n") /wave=w_out
		wave w_in = wavs[j]
		for (i=0;i<n;i++)
			FindValue /TEXT=w_order[i]/TXOP=3/Z w_cat
			if (v_value > -1)
				if (WaveExists(w_norm))
					if (FindDimLabel(w_norm, 0, w_order[i]) != -2)
						w_out[numpnts(w_out)] = {w_in[v_value]*mult/w_norm[%$w_order[i]]}
					else
						w_out[numpnts(w_out)] = {NaN}
					endif
				else
					w_out[numpnts(w_out)] = {w_in[v_value]} // output not normalized, has same units as input
				endif
			elseif (skipBlanks == 0)
				w_out[numpnts(w_out)] = {NaN}
			endif
		endfor
		note w_out note(w_in)
		AppendToGraph /W=spiderpanel#spidergraph w_out vs e_out
	endfor
	
	// relabel Y axis
	ControlInfo /W=spiderpanel popNorm
	if (stringmatch(s_value, "none"))
		ControlInfo /W=spiderpanel check_ppm
		s_value = SelectString(v_value , "wt. %", "ppm")
	else
		s_value = "/" + s_value
	endif
	Label /W=spiderpanel#spidergraph left, s_value
	
	sprintf s "element wave: %s;", NameOfWave(w_elements)
	sprintf s "%s data: %s;", s, NameOfWave(w_elements)
	sprintf s "%s order: %s;", s, (NameOfWave(w_order))[2,strlen(NameOfWave(w_order))-1]
	if (WaveExists(w_norm))
		sprintf s "%s normalized to: %s;", s, (NameOfWave(w_norm))[2,strlen(NameOfWave(w_norm))-1]
	endif
	note w_out ""
	
	spider_style("spiderpanel#spidergraph")
	return 1
end

static function /T spider_RemoveNumbers(string s)
	WAVE/B/U wbytes = StringToUnsignedByteWave(s)
	Extract /O wbytes, wbytes, (wbytes>64 && wbytes<91) || (wbytes>60 && wbytes<123)
	s = WaveDataToString(wbytes)
	return s
end

static function spider_listbox(STRUCT WMListboxAction &lba)
	if (lba.eventCode==4 || lba.eventCode==5)
		spider_update()
	endif
end

Proc SpidergramStyle() : GraphStyle
	spidergram#spider_style("")
end

static function spider_style(string s_win)
	ModifyGraph /W=$s_win/Z mode=4, marker=8, opaque=1,log(left)=1, tick(left)=2, tick(bottom)=4
	ModifyGraph /W=$s_win/Z mirror(left)=1, mirror(bottom)=2, standoff(left)=0, btLen(left)=4
	ModifyGraph /W=$s_win/Z catGap(bottom)=0.1, barGap(bottom)=0.1, btLen(bottom)=3, toMode=-1
end

// Utility function that puts the code needed to recreate w_text, and 
// possibly w, into the clipboard. Used to generate code for newly added 
// datasets
function /t spider_waveCode(wave /T w_text, [wave /Z w])
	string s = ""
	int i
	if (ParamIsDefault(w))
		sprintf s "Make /O/N=0/T dfr:%s /WAVE=%s\r\r%s={", NameOfWave(w_text), NameOfWave(w_text), NameOfWave(w_text)
		do
			sprintf s "%s\"%s\",", s, w_text[i]
			i += 1
			if ((mod(i,10)==0) && (i<numpnts(w_text)))
				s = RemoveEnding(s)
				sprintf s "%s}\r%s[%d]={", s, NameOfWave(w_text), i
			endif
		while(i<numpnts(w_text))
		s[strlen(s)-1,strlen(s)-1] = "}\r"
	else
		sprintf s "Duplicate /O n_template dfr:%s /WAVE=%s\r\r", NameOfWave(w), NameOfWave(w)
		do
			sprintf s "%s%s[%%%s] = %g\r", s, NameOfWave(w), w_text[i], w[i]
			i++
		while(i<numpnts(w))
	endif
	PutScrapText s
	return s
end

static function spider_save()
	
	DFREF dfr = root:Packages:Spidergram
	
	string plotName = "NewSpidergraph"
	string tableName = plotName + "Data"
	
	ControlInfo /W=spiderpanel checkPlot
	int makePlot = v_value
	ControlInfo /W=spiderpanel checkTable
	int makeTable = v_value
	ControlInfo /W=spiderpanel setvarDF
	string s_folder = s_value
	
	string s_list = TraceNameList("spiderpanel#spidergraph", ";", 1)
	if (strlen(s_list) == 0)
		return 0
	endif
	
	string cmd = ""
	if (DataFolderExists(s_folder))
		sprintf cmd, "Data folder %s%s exists.\r Overwrite waves in %s?", GetDataFolder(1), s_folder, s_folder
		DoAlert 1, cmd
		if (v_flag == 2)
			return 0
		endif
	endif
	
	NewDataFolder /O $s_folder
	DFREF dfr = $s_folder
	
	wave /Z/T w = XWaveRefFromTrace("spiderpanel#spidergraph", StringFromList(0,s_list))
	
	if (WaveExists(w) == 0)
		Print "Could not find category wave for " + StringFromList(0,s_list) + ". Save cancelled."
		return 0
	endif
	
	Duplicate /O w dfr:$NameOfWave(w) /WAVE=cat
	
	if (makePlot)
		if (CheckName(plotName, 6) + CheckName(plotName, 1))
			plotName = UniqueName(plotName, 6, 1)
		endif
		Display /N=$plotName as plotName
	endif
	
	if (makeTable)
		if (CheckName(tableName, 7) + CheckName(tableName, 1))
			tableName = UniqueName(tableName, 6, 1)
		endif
		Edit /K=1/N=$tableName cat as tableName
	endif
	
	int i
	for(i=0;i<ItemsInList(s_list);i++)
		wave w_i = TraceNameToWaveRef("spiderpanel#spidergraph",StringFromList(i, s_list))
		Duplicate /O w_i dfr:$NameOfWave(w_i) /WAVE=w_out
		if (makePlot)
			AppendToGraph /W=$plotName w_out vs cat
		endif
		if (makeTable)
			AppendToTable /W=$tableName w_out
		endif
	endfor
	
	if (makePlot)
		DoWindow /f $plotName
		// label Y axis
		ControlInfo /W=spiderpanel popNorm
		if (cmpstr(s_value, "none") == 0)
			ControlInfo /W=spiderpanel check_ppm
			s_value = SelectString(v_value , "wt. %", "ppm")
		else
			s_value = "/" + s_value
		endif
	
		Label /W=$plotName left, s_value
		spider_style(plotName)
	endif
	
	KillWindow /Z spiderpanel
	KillWindow /Z SpiderTable
	KillDataFolder /Z root:Packages:Spidergram:spiderdata
	
	return 1
end

static function hookSpiderPanel(STRUCT WMWinHookStruct &H_Struct)
	if (H_Struct.eventcode == 10) // menu
		if (stringmatch(H_Struct.menuItem, "Paste"))
			if (IgorVersion() >= 9) // cannot select an empty listbox in earlier versions
				ControlInfo /W=$H_Struct.winName kwSelectedControl
				if (cmpstr(s_value, "listboxWaves"))
					return 0
				endif
			endif
			return spider_import()
		endif
	endif
	return 0
end

static function hookTable(STRUCT WMWinHookStruct &H_Struct)
	if ((H_Struct.eventcode == 24 || H_Struct.eventcode == 25) && WinType("spiderpanel")==7) // edit
		spider_update()
	endif
	return 0
end

// Provides an easy way to import data from a table with analyses
// arranged in lines. Analyses may be arranged in rows or columns.
// Element symbols should be in either the first row [or column], and
// sample names in the first column [or row] of the selection. Wave names
// are taken from the sample name column [or row]. Text entries from
// other columns [or rows] are added as wave notes. Simply copy the
// table, activate the spidergram panel, and paste.
static function spider_import()
	
	string s = GetScrapText()
	if (strlen(s) == 0)
		return 0 // don't allow paste to happen
	endif
	
	string s_row = ""
	int row = 0, column = 0, numrows = ItemsInList(s,"\r"), numcolumns = 0
				
	for(row=0;row<numrows;row++)
		s_row = StringFromList(row, s, "\r")
		numcolumns = max(numcolumns, ItemsInList(s_row, "\t"))
	endfor
	
	// assume that analyses are arranged in rows
	Make /free/T/N=(numrows, numcolumns) w_table
	multithread w_table[][] = StringFromList(q, StringFromList(p, s, "\r"), "\t")
	// nested StringFromList that runs for every point is not smart
	
	Make /free/T/N=(numrows) w_firstColumn = w_table[p][0]
	Make /free/T/N=(numcolumns) w_firstRow = w_table[0][p]
	
	// figure out whether analyses are arranged in columns or rows
	int elementsInRow1 = ElementMatches(w_firstRow)
	int elementsInColumn1 = ElementMatches(w_firstColumn)
	int elementsFound = max(elementsInRow1, elementsInColumn1)
	
	if (elementsInColumn1 > elementsInRow1)
		Redimension /N=(numcolumns, numrows) w_table
		multithread w_table[][] = StringFromList(p, StringFromList(q, s, "\r"), "\t") // inefficient???
		// nested StringFromList is still not smart
		numrows = DimSize(w_table,0)
		numcolumns = DimSize(w_table,1)
	endif
	
	if (elementsFound)
		// make a new text wave containing elements
		string s_newname = "", s_elementsName = "elements"
		if (CheckName(s_elementsName, 1))
			s_elementsName = UniqueName(s_elementsName+"_", 1, 1)
		endif
	
		Make /T/N=(numcolumns-1) $s_elementsName /wave=w_elements
		w_elements = w_table[0][p+1]
	else
		// no element line in selection: allow import without elements only
		// if number of columns match current element wave
		ControlInfo /W=spiderpanel popElements
	
		// for Igor 6 compatibility
		if (exists(s_value) == 0)
			return 0
		endif
		
		wave /Z/T w_elements = $s_value
		if (WaveExists(w_elements) == 0)
			return 0
		endif
		
		if (numpnts(w_elements) != (DimSize(w_table, 1)-1))
			return 0
		endif
	endif
		
	for (row=(elementsFound>0);row<numrows;row++)
		s_newname = w_table[row][0]
		if (strlen(s_newname) == 0)
			continue
		endif
		s_newname = CleanupName(s_newname, 0)
		if (CheckName(s_newname, 1))
			s_newname = UniqueName(s_newname+"_", 1, 1)
		endif
		Make /N=(numcolumns-1) $s_newname /wave=w
		w = str2num(w_table[row][p+1])
		
		Duplicate /free w temp
		temp = numtype(temp) == 0 ? temp : 0
		if (numpnts(temp)==0 || sum(temp)==0)
			KillWaves /Z w
			continue
		endif

		for (column=1;column<numcolumns;column++)
			if (strlen(w_table[row][column]) && (numtype(w[column-1])!=0))
				if (cmpstr(w_table[row][column], "#VALUE!"))
					if (strlen(w_elements[column-1]))
						note w, w_elements[column-1] + ":" + w_table[row][column] + ";"
					else
						note w, w_table[row][column] + ";"
					endif
				endif
			endif
		endfor
	endfor
	
	if (elementsFound)
		PopupMenu popElements, win=spiderpanel, Value=WaveList("*", ";", "DIMS:1,TEXT:1"), popmatch=s_elementsName
	endif
	spider_setSelecter()
	
	return 1
end

static function ElementMatches(wave /T w)
	DFREF dfr = root:Packages:Spidergram
	wave /T w_elements = dfr:o_AtomicNo
	Duplicate /T/free w w_input
	w_input = spider_RemoveNumbers(w_input)
	Extract /T/O w_input, w_input, inTextWave(w_input, w_elements)
	return numpnts(w_input)
end

static function inTextWave(string s, wave /T w)
	FindValue /Z/TXOP=3/Text=s w
	return (v_value > -1)
end

#if IgorVersion() < 9

static function /WAVE StringToUnsignedByteWave(string s)
	Make /free/B/U/N=(strlen(s)) w
	w = char2num(s[p])
	return w
end

static function /S WaveDataToString(wave /B/U wbytes)
	string s = ""
	s = PadString(s, numpnts(wbytes), 0)
	int i
	for(i=numpnts(wbytes)-1;i>=0;i--)
		s[i,i] = num2char(wbytes[i])
	endfor
	return s
end

#endif