#include "XOPStandardHeaders.r"

resource 'vers' (1) {						// XOP version info.
	0x02, 0x00, release, 0x01, 0,			// version bytes and country integer.
	"2.0.1",
    "2.0.1, 2008, NIST, Pursuant to title 17 Section 105 of the United States Code this software is not subject to copyright protection and is in the public domain."
};

resource 'vers' (2) {						// Igor version info.
	0x05, 0x00, release, 0x00, 0,				// Version bytes and country integer.
	"5.00",
	"(for Igor 5.00 or later)"
};

// No custom error messages

// Description of menu items added to built-in Igor menus.
resource 'XMI1' (1100) {
    {
	/* [1] */
	50,									// Add item to menu with ID=50 (Load Waves menu).
	"Load CCP4 File...",							// This is text for added menu item.
	0,									// This item has no submenu.
	0,									// Flags field.
	/* [2] */
	50,									// Add item to menu with ID=50 (Load Waves menu).
	"Load MAR345 File...",							// This is text for added menu item.
	0,									// This item has no submenu.
	0,									// Flags field.
    }
};

/* Balloon strings for "Load CCP4 File..." item */
resource 'STR#' (1110, "Load CCP4 File...") {
    {
	/* [1] (used when menu item is enabled) */
	"Loads data from CCP4 encoded files into Igor waves.",
	
	/* [2] (used when menu item is disabled) */
	"",		/* item is never disabled */
	
	/* [3] (used when menu item is checked) */
	"",		/* item is never checked */
	
	/* [4] (used when menu item is marked) */
	"",		/* item is never marked */
    }
};

/* Balloon strings for "Load MAR345 File..." item */
resource 'STR#' (1111, "Load MAR345 File...") {
    {
	/* [1] (used when menu item is enabled) */
	"Loads data from MAR345 image plate files into Igor waves.",
	
	/* [2] (used when menu item is disabled) */
	"",		/* item is never disabled */
	
	/* [3] (used when menu item is checked) */
	"",		/* item is never checked */
	
	/* [4] (used when menu item is marked) */
	"",		/* item is never marked */
    }
};


resource 'XOPI' (1100) {
	XOP_VERSION,						// XOP protocol version.
	DEV_SYS_CODE,						// Development system information.
	0,							// Obsolete - set to zero.
	0,							// Obsolete - set to zero.
	XOP_TOOLKIT_VERSION,					// XOP Toolkit version.
};

resource 'XOPC' (1100) {
	{
		"ccp4unpack",					// Name of operation.
		XOPOp+UtilOP+compilableOp,			// Operation's category.
	}
};


