#pragma rtGlobals=1		// strict wave access makes annoyance!.
//#pragma rtGlobals=3		// Use modern global access method and strict wave access.

//==================================================================================================
// FitXPS: A Core Level X-ray Photoelectron Spectrum Fitting Macro / IgorPro
//
// written by Prof. Han-Jin Noh, Ph.D. Department of Physics, Chonnam National University
//
// 2015.1.2: version 0.2: It can be used to fit an XPS spectrum by hand.
// version 0.3: All function buttons except 'Fit!' basically work even though they are incomplete.
// date: 2015.1.11
// version 0.4: now gCvNParSet is a Matrix to implement LvMq fitting method.
//2015.1.13
// version 0.5.1: XPS spectrum can be automatically fitted to Voight profiles with shirley type background
// The fitting algorithm uses Levenberg-Marquardt method.
// version 0.5.2: User interface is almost fixed.
// Ver. 0.6: All functions works pretty fine. Tougaard background and Doniac-Sunjic line shape are not implemented yet.
// Ver. 0.6.1: Several boundary checks in LvMq fitting functions to make more chances to convergence.
// Ver. 0.7: Tougaard type background was implemented.
// 2015.1.15,
// Ver. 0.8: Doniac-Sunjic line shape was implemented. So, basically all functions in the wish-list have been implemented.
// Ver.0.8.1: DS function scale factor problem was fixed.
//		simple help file was written.
// Ver 0.8.2: background initial guess function was added.
// Ver 0.9: Fitting loop goes to a local minimum in 20 times at most cases.
// To do: 
// 		find bugs and fix them. 
//-----------------------------

Menu "Fit XPS"
	"Fitting XPS", ShowFitXPSPanel()
end

Proc ShowFitXPSPanel()
	if(WinType("FitXPS") !=1) // 1:Graph
		FitXPSPanel()
	else
		Print "FitXPS is already running!"
	endif
EndMacro

Function InitFitXPS()
	String savDF = GetDataFolder(1)
	if(DataFolderExists("root:Packages")==0)
		NewDataFolder/O/S root:Packages
	endif

	String CvsParSet = "root:Packages:FitXPS:gCvsParSet"

// Flag for fitting parameters. FPI[0~11]: curve1, and so on.	
	String FitParIndex = "root:Packages:FitXPS:gFitParIndex"

	if(DataFolderExists("root:Packages:FitXPS")==0)
		NewDataFolder/O/S root:Packages:FitXPS
		
		String/G gSpectrum = "Select"
		String/G gParameterName="Select"
		String/G gChisquare = "Chi^2 = N. A."
		String/G gCsrA, gCsrB
		Variable/G gUseCsrs = 0, gBGType=0

		Make/O/N=(12*6) $FitParIndex
		Wave FPI = $FitParIndex
		FPI = 0

		Make/O/N=(12,6) $CvsParSet // CvPS[][N] for curve (N+1)
		Wave CvPS=$CvsParSet
		CvPS = 0
		
		CvPS[3][0]=0.3 // L.W. for curve 1
		CvPS[4][0]=0.5 // G.W.
//		CvPS[10][0]=0.01 // Base line

		CvPS[3][1]=0.3 // L.W. for curve 2
		CvPS[4][1]=0.5 // G.W.

		CvPS[3][2]=0.3 // L.W. for curve 3
		CvPS[4][2]=0.5 // G.W.

		CvPS[3][3]=0.3 // L.W. for curve 4
		CvPS[4][3]=0.5 // G.W.

		CvPS[3][4]=0.3 // L.W. for curve 5
		CvPS[4][4]=0.5 // G.W.

		CvPS[3][5]=0.3 // L.W. for curve 6
		CvPS[4][5]=0.5 // G.W.
				
//		CvPS[0][]=0 // checkbox CvPS[][0~5] for curve 1~6,
//		CvPS[1][]=0.0 // INT
//		CvPS[2][]=0.0 // B. E.
//		CvPS[3][]=1.0 // L. W.
//		CvPS[4][]=1.0 // G. W.
//		CvPS[5][]=0.0 // LSE
//		CvPS[6][]=0.0 // LSI
//		CvPS[7][]=0.0 // LSW
//		CvPS[8][]=0.0 // ASY
//		CvPS[9][]=0.0 // BGD
//		CvPS[10][0]=0.0 // BaseLine,  CvPS[1][1~5] not used.
//		CvPS[11][]=0.0 // Area
	
	endif
	
	SetDataFolder savDF
End


Function FinalizeFitXPS()

	String CvsParSet = "root:Packages:FitXPS:gCvsParSet"

	Wave CvsPS=$CvsParSet
	Variable idx
	for(idx=0; idx<6; idx+=1)
		if(CvsPS[0][idx]==1)
			String CvN
			sprintf CvN, "Chk_Curve%d", idx+1
			Panel_ChkCurveN(CvN, 1)		
		endif
	endfor
	
End

Window FitXPSPanel(): Graph
	PauseUpdate; Silent 1
	variable winXpos=250, winYpos=100, width=550, height=480

	InitFitXPS()
	
	Display/K=1/W=(winXpos,winYpos,winXpos+width,winYpos+height-30)/N=FitXPS as "FitXPS"

// first row menu
	variable xPosition=4, yPosition=5
	ControlBar/T 260+22
	PopupMenu View_Filename,  pos={xPosition,yPosition}, proc=Panel_Filename_Click, title="XPSpectrum:"
	PopupMenu View_Filename, mode=1, popvalue=root:Packages:FitXPS:gSpectrum
	PopupMenu View_Filename, value=WaveList("!*FXP*",";","Dims:1")
// mode=0: title is in pop-up menu, mode>0: title is to the left of pop-up menu.
	xPosition += 200
	PopupMenu Read_Parameters,  pos={xPosition,yPosition}, proc=Panel_Parameter_Click, title="ParSet:"
	PopupMenu Read_Parameters, mode=1, popvalue=root:Packages:FitXPS:gParameterName
	PopupMenu Read_Parameters, value=WaveList("*FXPar",";","Dims:2")

	xPosition += 180+65
	Button btnSave, pos={xPosition, yPosition}, proc=Panel_btnSave_Click, size={50,20}, title="Save"
	xPosition += 55
	Button btnView, pos={xPosition, yPosition}, proc=Panel_btnView_Click, size={50,20}, title="View"
	xPosition += 55
	Button btnFit, pos={xPosition, yPosition}, proc=Panel_btnFit_Click, size={50,20}, title="Fit!"
	xPosition += 55
	Button btnClear, pos={xPosition, yPosition}, proc=Panel_btnClear_Click, size={50,20}, title="Clear"
	xPosition += 55
	Button btnUndo, pos={xPosition, yPosition}, proc=Panel_btnUndo_Click, size={50,20}, title="Undo"

	TitleBox tbBGType, pos={xPosition-65, yPosition+22*2}, anchor=MC, frame=4, size={115,20}, fixedSize=1, title="Background Type"
	CheckBox chkBGShirley,pos={xPosition-55, yPosition+22*3+2}, title="Shirley", value=1, mode=1, proc=Panel_radioBG_Click
	CheckBox chkBGTougaard,pos={xPosition-55, yPosition+22*4-2}, title="Tougaard", value=0, mode=1, proc=Panel_radioBG_Click

	CheckBox chkCsr, pos={xPosition-60, yPosition+22*5}, title="Use Cursors to \rSet Fit. Range", value=0, proc=Panel_chkCsr_Click

	TitleBox tbChiTitle, pos={xPosition-65, yPosition+22*7}, anchor=MC, frame=4, size={115,20}, fixedSize=1, title="Chi square value"
	TitleBox tbChisq, pos={xPosition-65, yPosition+22*8}, anchor=MC, frame=0, size={115,20}, fixedSize=1, title=" "
	TitleBox tbChisq, variable=root:Packages:FitXPS:gChisquare

// left column parameter title buttons
	xPosition = 4
	yPosition = 5+28+21
	Button btnBE, pos={xPosition, yPosition}, size={50,20}, title="B. E."

	yPosition += 22
	Button btnINT, pos={xPosition, yPosition}, size={50,20}, title="INT"

	yPosition += 22
	Button btnLW, pos={xPosition, yPosition}, size={50,20}, title="LorW"

	yPosition += 22
	Button btnGW, pos={xPosition, yPosition}, size={50,20}, title="GauW"

	yPosition += 22
	Button btnLSE, pos={xPosition, yPosition}, size={50,20}, title="LSE"

	yPosition += 22
	Button btnLSI, pos={xPosition, yPosition}, size={50,20}, title="LSI"

	yPosition += 22
	Button btnLSW, pos={xPosition, yPosition}, size={50,20}, title="LSW"

	yPosition += 22
	Button btnASY, pos={xPosition, yPosition}, size={50,20}, title="ASY"

	yPosition += 22
	Button btnBGD, pos={xPosition, yPosition}, size={50,20}, title="BGD"

	yPosition += 22
	Button btnBL, pos={xPosition, yPosition}, size={50,20}, title="BLine"


// first column for curve 1
	xPosition = 66
	yPosition = 5+28
	CheckBox Chk_Curve1, proc=Panel_ChkCurveN,  pos={xPosition, yPosition}, title="Curve 1", fColor=(65535,0,0), value=root:Packages:FitXPS:gCvsParSet[0][0]
	
	xPosition = 40+15
	yPosition += 22
	SetVariable Curve1BE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1BE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[1][0]
	CheckBox chk1BE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1INT, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1INT, limits={0,INF,0.005},  value=root:Packages:FitXPS:gCvsParSet[2][0]
	CheckBox chk1INT, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1LW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1LW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[3][0]
	CheckBox chk1LW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1GW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1GW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[4][0]
	CheckBox chk1GW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1LSE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1LSE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[5][0]
	CheckBox chk1LSE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1LSI, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1LSI, limits={0,1,0.01},  value=root:Packages:FitXPS:gCvsParSet[6][0]
	CheckBox chk1LSI, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1LSW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1LSW, limits={0,INF,0.1},  value=root:Packages:FitXPS:gCvsParSet[7][0]
	CheckBox chk1LSW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1ASY, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1ASY, limits={0,0.5,0.005}, disable=0,  value=root:Packages:FitXPS:gCvsParSet[8][0]
	CheckBox chk1ASY, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" ", disable=0

	yPosition += 22
	SetVariable Curve1BGD, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1BGD, limits={0,1,0.001},  value=root:Packages:FitXPS:gCvsParSet[9][0]
	CheckBox chk1BGD, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve1BL, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve1BL, limits={-0.1,0.2,0.001},  value=root:Packages:FitXPS:gCvsParSet[10][0]
	CheckBox chk1BL, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

// second column for curve 2
	xPosition = 66+90 
	yPosition=5+28
	CheckBox Chk_Curve2, proc=Panel_ChkCurveN,  pos={xPosition, yPosition}, title="Curve 2",  fColor=(0,65535,0), value=root:Packages:FitXPS:gCvsParSet[0][1]
	
	xPosition = 55+90 
	yPosition += 22
	SetVariable Curve2BE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2BE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[1][1]
	CheckBox chk2BE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve2INT, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2INT, limits={0,INF,0.005},  value=root:Packages:FitXPS:gCvsParSet[2][1]
	CheckBox chk2INT, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve2LW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2LW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[3][1]
	CheckBox chk2LW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve2GW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2GW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[4][1]
	CheckBox chk2GW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve2LSE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2LSE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[5][1]
	CheckBox chk2LSE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve2LSI, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2LSI, limits={0,1,0.01},  value=root:Packages:FitXPS:gCvsParSet[6][1]
	CheckBox chk2LSI, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve2LSW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2LSW, limits={0,INF,0.1},  value=root:Packages:FitXPS:gCvsParSet[7][1]
	CheckBox chk2LSW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve2ASY, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2ASY, limits={0,0.5,0.005}, disable=0,  value=root:Packages:FitXPS:gCvsParSet[8][1]
	CheckBox chk2ASY, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" ", disable=0

	yPosition += 22
	SetVariable Curve2BGD, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve2BGD, limits={0,1,0.001},  value=root:Packages:FitXPS:gCvsParSet[9][1]
	CheckBox chk2BGD, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

// third column for curve 3
	xPosition =  66+90*2 
	yPosition = 5+28
	CheckBox Chk_Curve3, proc=Panel_ChkCurveN,  pos={xPosition, yPosition}, title="Curve 3",  fColor=(0,0,65535), value=root:Packages:FitXPS:gCvsParSet[0][2]
	
	xPosition = 55+90*2 
	yPosition += 22
	SetVariable Curve3BE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3BE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[1][2]
	CheckBox chk3BE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve3INT, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3INT, limits={0,INF,0.005},  value=root:Packages:FitXPS:gCvsParSet[2][2]
	CheckBox chk3INT, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve3LW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3LW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[3][2]
	CheckBox chk3LW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve3GW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3GW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[4][2]
	CheckBox chk3GW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve3LSE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3LSE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[5][2]
	CheckBox chk3LSE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve3LSI, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3LSI, limits={0,1,0.01},  value=root:Packages:FitXPS:gCvsParSet[6][2]
	CheckBox chk3LSI, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve3LSW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3LSW, limits={0,INF,0.1},  value=root:Packages:FitXPS:gCvsParSet[7][2]
	CheckBox chk3LSW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve3ASY, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3ASY, limits={0,0.5,0.005},  disable=0, value=root:Packages:FitXPS:gCvsParSet[8][2]
	CheckBox chk3ASY, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" ", disable=0

	yPosition += 22
	SetVariable Curve3BGD, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve3BGD, limits={0,1,0.001},  value=root:Packages:FitXPS:gCvsParSet[9][2]
	CheckBox chk3BGD, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

// third column for curve 4
	xPosition =  66+90*3 
	yPosition = 5+28
	CheckBox Chk_Curve4, proc=Panel_ChkCurveN,  pos={xPosition, yPosition}, title="Curve 4", fColor=(65535,35535,0),value=root:Packages:FitXPS:gCvsParSet[0][3]
	
	xPosition = 55+90*3 
	yPosition += 22
	SetVariable Curve4BE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4BE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[1][3]
	CheckBox chk4BE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve4INT, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4INT, limits={0,INF,0.005},  value=root:Packages:FitXPS:gCvsParSet[2][3]
	CheckBox chk4INT, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve4LW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4LW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[3][3]
	CheckBox chk4LW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve4GW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4GW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[4][3]
	CheckBox chk4GW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve4LSE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4LSE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[5][3]
	CheckBox chk4LSE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve4LSI, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4LSI, limits={0,1,0.01},  value=root:Packages:FitXPS:gCvsParSet[6][3]
	CheckBox chk4LSI, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve4LSW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4LSW, limits={0,INF,0.1},  value=root:Packages:FitXPS:gCvsParSet[7][3]
	CheckBox chkLSW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve4ASY, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4ASY, limits={0,0.5,0.005},  disable=0, value=root:Packages:FitXPS:gCvsParSet[8][3]
	CheckBox chk4ASY, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" ", disable=0

	yPosition += 22
	SetVariable Curve4BGD, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve4BGD, limits={0,1,0.001},  value=root:Packages:FitXPS:gCvsParSet[9][3]
	CheckBox chk4BGD, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

// third column for curve 5
	xPosition =  66+90*4 
	yPosition = 5+28
	CheckBox Chk_Curve5, proc=Panel_ChkCurveN,  pos={xPosition, yPosition}, title="Curve 5", fColor=(0,65535,65535),value=root:Packages:FitXPS:gCvsParSet[0][4]
	
	xPosition = 55+90*4 
	yPosition += 22
	SetVariable Curve5BE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5BE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[1][4]
	CheckBox chk5BE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve5INT, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5INT, limits={0,INF,0.005},  value=root:Packages:FitXPS:gCvsParSet[2][4]
	CheckBox chk5INT, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve5LW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5LW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[3][4]
	CheckBox chk5LW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve5GW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5GW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[4][4]
	CheckBox chk5GW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve5LSE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5LSE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[5][4]
	CheckBox chk5LSE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve5LSI, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5LSI, limits={0,1,0.01},  value=root:Packages:FitXPS:gCvsParSet[6][4]
	CheckBox chk5LSI, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve5LSW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5LSW, limits={0,INF,0.1},  value=root:Packages:FitXPS:gCvsParSet[7][4]
	CheckBox chk5LSW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve5ASY, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5ASY, limits={0,0.5,0.005},  disable=0, value=root:Packages:FitXPS:gCvsParSet[8][4]
	CheckBox chk5ASY, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" ", disable=0

	yPosition += 22
	SetVariable Curve5BGD, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve5BGD, limits={0,1,0.001},  value=root:Packages:FitXPS:gCvsParSet[9][4]
	CheckBox chk5BGD, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

// third column for curve 6
	xPosition =  66+90*5 
	yPosition = 5+28
	CheckBox Chk_Curve6, proc=Panel_ChkCurveN,  pos={xPosition, yPosition}, title="Curve 6", fColor=(65535,0,65535),value=root:Packages:FitXPS:gCvsParSet[0][5]
	
	xPosition = 55+90*5 
	yPosition += 22
	SetVariable Curve6BE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6BE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[1][5]
	CheckBox chk6BE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve6INT, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6INT, limits={0,INF,0.005},  value=root:Packages:FitXPS:gCvsParSet[2][5]
	CheckBox chk6INT, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve6LW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6LW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[3][5]
	CheckBox chk6LW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve6GW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6GW, limits={0,INF,0.05},  value=root:Packages:FitXPS:gCvsParSet[4][5]
	CheckBox chk6GW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve6LSE, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6LSE, limits={-INF,INF,0.01},  value=root:Packages:FitXPS:gCvsParSet[5][5]
	CheckBox chk6LSE, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve6LSI, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6LSI, limits={0,1,0.01},  value=root:Packages:FitXPS:gCvsParSet[6][5]
	CheckBox chk6LSI, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve6LSW, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6LSW, limits={0,INF,0.1},  value=root:Packages:FitXPS:gCvsParSet[7][5]
	CheckBox chk6LSW, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "

	yPosition += 22
	SetVariable Curve6ASY, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6ASY, limits={0,0.5,0.005},  disable=0, value=root:Packages:FitXPS:gCvsParSet[8][5]
	CheckBox chk6ASY, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" ", disable=0

	yPosition += 22
	SetVariable Curve6BGD, pos={xPosition,yPosition}, proc=Panel_Curve_Change, size={70,20}, title="  "
	SetVariable Curve6BGD, limits={0,1,0.001},  value=root:Packages:FitXPS:gCvsParSet[9][5]
	CheckBox chk6BGD, proc=Panel_ChkPar, pos={xPosition+74, yPosition+1}, value=0, title=" "



	String ExpSpect = "root:Packages:FitXPS:ExpSpect_FXPS"
	if(waveexists($ExpSpect) == 0)	// if not exist			
		Make/O/N=(201) $ExpSpect // initial logo wave.
		Setscale/I x, -305, -295, $ExpSpect
		$ExpSpect = (1/(PI*0.4/2))*(0.4/2)^2/((x-(-299))^2+(0.4/2)^2) + gnoise(0.01)
		$ExpSpect +=  (0.667/(PI*(0.45)/2))*(0.45/2)^2/((x-(-301))^2+((0.45)/2)^2) +gnoise(0.01)
	endif

	AppendToGraph/B $ExpSpect
	ModifyGraph margin(left)=50,margin(bottom)=34,margin(top)=14,margin(right)=40
	ModifyGraph fSize=10, mode=3, msize=1.5, marker=8, rgb=(0,0,0)
	ModifyGraph lblMargin(left)=5, lblPosMode(bottom)=4,lblPos(bottom)=37,tlOffset(bottom)=-1
	ModifyGraph nticks(left)=10, btLen=3
	Label left "\\Z11Intensity (arb. units)"
	Label bottom "\\Z11E - E\\BF\\M (eV)"
	ShowInfo  // append the cursors.

	FinalizeFitXPS()

EndMacro


Function Panel_Filename_Click(ctrlName, popNum, popString) : PopupMenuControl
	string ctrlName, popString
	variable popNum

	SVAR Spectrum = root:Packages:FitXPS:gSpectrum


	string strOlder = Spectrum
	Spectrum = popString

	if(waveexists($popString)==0) // not existed
		return 0
	endif

	Execute "Panel_btnClear_Click(\"btnClear\")"
	FitSpectrum_CalculateData()
End

Function Panel_Parameter_Click(ctrlName, popNum, popString) : PopupMenuControl
	string ctrlName, popString
	variable popNum

	SVAR ParSet = root:Packages:FitXPS:gParameterName
	ParSet=popString

	if(waveexists($popString)==0) // not existed
		return 0
	endif

	Wave wPS = $popString
	Variable idx
	String sPS= "root:Packages:FitXPS:gCvsParSet"
	Wave wCV = $sPS

	String cmd
	sprintf cmd, "Panel_btnClear_Click(\"btnClear\")"
	Execute cmd
	
	for(idx=0  ; idx <dimsize(wPS,1) ; idx+=1)
		wCV[][idx]=wPS[p][idx]
		sprintf cmd, "CheckBox Chk_Curve%d, value=1", idx+1
		Execute cmd
		sprintf cmd, "Panel_ChkCurveN(\"Chk_Curve%d\", %d)", idx+1, wCV[0][idx]
		Execute cmd
	endfor

End


Function Panel_btnView_Click(ctrlName) : ButtonControl
	String ctrlName

	SVAR gChi = root:Packages:FitXPS:gChisquare
	Variable chi2

	String sCvsPS = "root:Packages:FitXPS:gCvsParSet"
	Wave CvsParSet = $sCvsPS
	
// checked flag for Curve #N 
	if(CvsParSet[0][0]==1) 
	 	Curves_CalculateData(1)
	endif
	if(CvsParSet[0][1]==1) 
	 	Curves_CalculateData(2)
	endif
	if(CvsParSet[0][2]==1) 
	 	Curves_CalculateData(3)
	endif
	if(CvsParSet[0][3]==1) 
	 	Curves_CalculateData(4)
	endif
	if(CvsParSet[0][4]==1) 
	 	Curves_CalculateData(5)
	endif
	if(CvsParSet[0][5]==1) 
	 	Curves_CalculateData(6)
	endif

 	Background_CalculateData()
	FittingCurve_CalculateData()
	DiffCurve_CalculateData()

	String sExp = "root:Packages:FitXPS:ExpSpect_FXPS"
	String BG="root:Packages:FitXPS:Background_FXPS"
	String FCv="root:Packages:FitXPS:FittingSpect_FXPS"
	String DCv="root:Packages:FitXPS:DiffSpect_FXPS"
	chi2 = Chisq($sExp, $FCv, 0)
	sprintf gChi, "%6.6f", chi2
	
	String trFit
	Variable nList
	trFit = TraceNameList("FitXPS", ";", 1+4)
	nList=FindListItem("Background_FXPS", trFit, ";")
	if(nList==-1) // if not yet appended 
		AppendToGraph/B/W=FitXPS $BG
		ModifyGraph lStyle(Background_FXPS)=3, rgb(Background_FXPS)=(0,0,0)
	endif
	nList=FindListItem("FittingSpect_FXPS", trFit, ";")
	if(nList==-1) // if not yet appended 
		AppendToGraph/B/W=FitXPS $FCv
		ModifyGraph lStyle(FittingSpect_FXPS)=0, rgb(FittingSpect_FXPS)=(0,0,0)
	endif
	nList=FindListItem("DiffSpect_FXPS", trFit, ";")
	if(nList==-1) // if not yet appended 
		AppendToGraph/B/W=FitXPS $DCv
		ModifyGraph lStyle(DiffSpect_FXPS)=1, rgb(DiffSpect_FXPS)=(0,0,0)
	endif
	 
End

Function Panel_btnFIt_Click(ctrlName) : ButtonControl
	String ctrlName

	Execute "Panel_btnView_Click(\"btnView\")"
	LvMqFit()
	Execute "Panel_btnView_Click(\"btnView\")"
End

//------------------------------------------
// Levenberg-Marquardt Method Fitting Algorithm
//------------------------------------------
Function LvMqFit()

	String savDF = GetDataFolder(1)
	SetDataFolder root:Packages:FitXPS

	String sCvsPS = "root:Packages:FitXPS:gCvsParSet"
	Wave wCvsPS = $sCvsPS
	
	String sFPI="root:Packages:FitXPS:gFitParIndex"
	Wave wFPIndex =  $sFPI

	String sExp = "root:Packages:FitXPS:ExpSpect_FXPS"
	String sFit = "root:Packages:FitXPS:FittingSpect_FXPS"
	String sBG = "root:Packages:FitXPS:Background_FXPS"
	String sDif = "root:Packages:FitXPS:DiffSpect_FXPS"
	Wave ExpCv = $sExp
	Wave Fit = $sFit
	Wave BG = $sBG
	Wave Dif = $sDif
	
	Duplicate/O Fit prevFit 
	Duplicate/O wCvsPS prevPS

	Variable idx, idx1, i_k, i_l, chisq0, chisq1, chi_ratio, iterMax=20
	Variable lambda=0.01 // initial guess value
	Variable NFP=0 // No. of fitting parameters

	for(idx=0,idx1=0; idx<6; idx +=1)
		if(wCvsPS[0][idx]==1)
			idx1+=1
		endif
	endfor
	if(idx1==0)
		print "Turn on at least one of curves 1 ~ 6!"
		SetDataFolder savDF		
		return 0
	endif

	for(idx=0; idx < dimsize(wFPIndex,0); idx += 1)
		NFP += wFPIndex[idx]
	endfor
	if (NFP > 10)
		print "Too many fitting parameters!"
		return 0
	endif

	SVAR csrA = root:Packages:FitXPS:gCsrA
	SVAR csrB = root:Packages:FitXPS:gCsrB
	NVAR csrFlag = root:Packages:FitXPS:gUseCsrs
	Variable cAp, cBp, startPnt, endPnt

	csrA = CsrInfo(A)
	csrB = CsrInfo(B)
	
	cAp = NumberbyKey("POINT",csrA)
	cBp = NumberbyKey("POINT",csrB)

	if(csrFlag==1 && cAp != NaN  && cBp != NaN)
		startPnt = min(cAp, cBp)
		endPnt = max(cAp, cBp)
	else
		startPnt=0
		endPnt=dimsize(Fit,0)
	endif

	
	Make/O/N=(NFP) a_k, da_k, b_k
	Make/O/N=(NFP,NFP) alp_kl
	Make/O/N=(dimsize(Fit,0),NFP) dyda

// calculate chi^ (a) = sum_i (y_obs - y(x_i, a))^2
	chisq0 = Chisq(ExpCv, Fit, 0)

// start do-while loop here.
	do	
// calcuate a_k, da_k
	for(idx1=0, idx=0; idx < dimsize(wFPIndex,0); idx += 1)
		if(wFPIndex[idx]==1)
			a_k[idx1]=wCvsPS[idx-12*trunc(idx/12)][trunc(idx/12)]
			da_k[idx1] = 3.4e-4 * max(abs(a_k[idx1]), 3.4e-4)
			idx1+=1
		endif
	endfor
// calculate b_k
// b_k = sum_i (y_obs(x_i) - y(x_i, vector a))/sigma^2 (x_i) * dy(x_i, a)/da_k, partial derivative.
	for(idx=0, i_k=0 ; idx < dimsize(wFPIndex,0); idx += 1)
		if(wFPIndex[idx]==1)
			wCvsPS[idx-12*trunc(idx/12)][trunc(idx/12)] += da_k[i_k]

			if(wCvsPS[0][0]==1) 
	 			Curves_CalculateData(1)
			endif
			if(wCvsPS[0][1]==1) 
	 			Curves_CalculateData(2)
			endif
			if(wCvsPS[0][2]==1) 
	 			Curves_CalculateData(3)
			endif
			if(wCvsPS[0][3]==1) 
	 			Curves_CalculateData(4)
			endif
			if(wCvsPS[0][4]==1) 
	 			Curves_CalculateData(5)
			endif
			if(wCvsPS[0][5]==1) 
	 			Curves_CalculateData(6)
			endif
 			Background_CalculateData()
			FittingCurve_CalculateData()
			
			for(idx1=startPnt, b_k[i_k]=0; idx1<endPnt; idx1+=1)
				dyda[idx1][i_k] = (Fit[idx1]-prevFit[idx1])/da_k[i_k]
				b_k[i_k] += Dif[idx1]* dyda[idx1][i_k]
			endfor
			
			wCvsPS[idx-12*trunc(idx/12)][trunc(idx/12)] -= da_k[i_k]
			i_k += 1
		endif
	endfor


// calculate alpha'_kl
// alpha'_kk = alpha_kk * (1 + lambda)
// alpha'_kl = alpha_kl
// alpha_kl = sum_i dy(x_i, a_k)/da_k  *  dy(x_i, a_l)/da_l 

	for(i_k=0; i_k < NFP; i_k += 1)
	for(i_l=0; i_l < NFP; i_l += 1)
		alp_kl[i_k][i_l] = DotProduct_in_Matrix(dyda, i_k, i_l)
		if(i_k==i_l)
			alp_kl[i_k][i_l] *= (1+lambda)
		endif
	endfor
	endfor

// solve matrix eq.  alpha'_kl * delta_a_l = beta_k to obtain delta_a
	MatrixGaussJ alp_kl, b_k 
	if(V_flag != 1) // not singular
		String sMx="root:Packages:FitXPS:M_x"
		Wave wMx=$sMx
		da_k[] = wMx[p]
	endif

// calculate chi^2 ( a + delta a )
	Variable flagAllDaSmall = 1
	for(idx=0, i_k=0 ; idx < dimsize(wFPIndex,0); idx += 1)
		if(wFPIndex[idx]==1)
			Variable i_m, i_n
			if(abs(da_k[i_k]) > 1.0e-8)
				flagAllDaSmall = 0
			endif
			if(abs(da_k[i_k]) > 10)
				da_k[i_k] = 0
				print "Too large da_k[",i_k,"]!  Reset da_k[",i_k,"]=0"
			endif
			
			i_m = idx-12*trunc(idx/12)
			i_n = trunc(idx/12)
			wCvsPS[i_m][i_n] += da_k[i_k]
// check abnormal directions.
			if(i_m==3 && wCvsPS[i_m][i_n]<0.05) // Lorentzian width
				wCvsPS[i_m][i_n] = 0.05
				print "LW reset!"
			elseif(i_m==4 && wCvsPS[i_m][i_n]<0.05 ) // Gaussian width
				wCvsPS[i_m][i_n] = 0.05
				print "GW reset!"
			elseif(wCvsPS[i_m][i_n]<0 && i_m!=1 && i_m!=5 && i_m!=7 ) // not B.E. nor LSE, LSW
				wCvsPS[i_m][i_n] = 0.0
				print "CurvesParSet[", i_m,"][",i_n,"] reset to 0.0"
			endif
			i_k += 1
		endif
	endfor

	if(wCvsPS[0][0]==1) 
		Curves_CalculateData(1)
	endif
	if(wCvsPS[0][1]==1) 
		Curves_CalculateData(2)
	endif
	if(wCvsPS[0][2]==1) 
		Curves_CalculateData(3)
	endif
	if(wCvsPS[0][3]==1) 
		Curves_CalculateData(4)
	endif
	if(wCvsPS[0][4]==1) 
		Curves_CalculateData(5)
	endif
	if(wCvsPS[0][5]==1) 
		Curves_CalculateData(6)
	endif
	Background_CalculateData()
	FittingCurve_CalculateData()
	DiffCurve_CalculateData()
	chisq1 = Chisq(ExpCv, Fit, 0)
	chi_ratio = chisq1/chisq0
	chisq0 = chisq1
	print "chi^2 (new) / chi^2 (old) =", chi_ratio

// if chi^2 (a+da) >= chi^2(a), increse lambda by 5~10 times, then goto matrix eq.
// else, decrease lambda by 5~10 times, set d+da to new a, then goto matrix eq.
// if 0.99 < chi^2(a+da)/chi^2(a) <= 1, then stop.
	if(chi_ratio > 1.00001)
		lambda *= 10.0
		for(idx=0, i_k=0 ; idx < dimsize(wFPIndex,0); idx += 1)
			if(wFPIndex[idx]==1)
				wCvsPS[idx-12*trunc(idx/12)][trunc(idx/12)] -= da_k[i_k]
				i_k += 1
			endif
		endfor
	else
		lambda *= 0.1
	endif
	
	if(flagAllDaSmall ==1)
		print "Fitting loop is termincated by flagAllDaSmall flag!"
		break
	endif
	iterMax -= 1
	if(iterMax <= 0)
		print "Fitting loop iterated maximum times!"
		break
	endif
	
	while( (chi_ratio < 0.999 || (chi_ratio -1) > 1.0e-5 ) && chisq1 < 1.0e8)
// end of do-while loop.
	print "Fitting is completed!"

	killwaves/Z a_k, b_k, da_k, dyda, alp_kl, wMx, M_inverse, prevFit, sig_sq
	SetDataFolder savDF
End

Function DotProduct_in_Matrix(m1, i_k, i_l)
	Wave m1
	Variable i_k, i_l

	Variable idx, s1
	
	for(idx=0, s1=0; idx < dimsize(m1,0); idx += 1)
		s1 += m1[idx][i_k]*m1[idx][i_l]
	endfor
	
	return s1
End

Function Panel_btnSave_Click(ctrlName) : ButtonControl
	String ctrlName

	String CvsPS = "root:Packages:FitXPS:gCvsParSet"
	Wave Cvs = $CvsPS

	String sExp = "root:Packages:FitXPS:ExpSpect_FXPS"
	String sFit = "root:Packages:FitXPS:FittingSpect_FXPS"
	String sBG = "root:Packages:FitXPS:Background_FXPS"
	String sDif = "root:Packages:FitXPS:DiffSpect_FXPS"
	String sCvs, InpCv

	String noteCv

	SVAR CurExpFileName = root:Packages:FitXPS:gSpectrum
	NVAR BGtype=root:Packages:FitXPS:gBGType
	SVAR chisq=root:Packages:FitXPS:gChisquare
	
	String sParName=CurExpFileName
	Prompt sParName, "Enter fitting result name: "
	DoPrompt "Save Fitting Result As ", sParName
	if(V_Flag)
		return 0
	endif

	String sPS = "root:"+sParName+"_FXPar"
		
	Variable dimY=Cvs[0][0]+Cvs[0][1]+Cvs[0][2]+Cvs[0][3]+Cvs[0][4]+Cvs[0][5]

	Make/O/N=(Dimsize(Cvs,0),dimY) $sPS
	Wave ParSet = $sPS

// checked flag for Curve #N 
	Variable idxc=0, idx=0

	for(idxc=0, idx=0; idxc<6; idxc+=1)
		if(Cvs[0][idxc]==1) 
			ParSet[][idx]=Cvs[p][idxc]
			idx += 1
			sprintf InpCv, "root:%s_FXPCv%d", sParName, idx
			sprintf sCvs, "root:Packages:FitXPS:Curve%d_FXPS", idx
			sprintf noteCv, "B. E.=%.3f, Intensity=%.3f, LorW=%.3f, GauW=%.3f, LSE=%.3f, LSI=%.4f,LSW=%.3f, BG=%.6f", Cvs[1][idxc], Cvs[2][idxc],Cvs[3][idxc],Cvs[4][idxc],Cvs[5][idxc],Cvs[6][idxc],Cvs[7][idxc],Cvs[9][idxc]
			duplicate/O $sCvs $InpCv
			Note $InpCv noteCv
		endif
	endfor

	InpCv = "root:"+sParName+"_FXPExp"
	duplicate/O $sExp $InpCv

	InpCv = "root:"+sParName+"_FXPFit"
	duplicate/O $sFit $InpCv
	sprintf noteCv, "Chi^2 = %s", chisq
	Note $InpCv noteCv
	
	InpCv = "root:"+sParName+"_FXPBgr"
	duplicate/O $sBG $InpCv
	if(BGtype==0)
		sprintf noteCv, "Shirley type background"
	elseif(BGtype==1)
		sprintf noteCv, "Tougaard type background"
	else
		sprintf noteCv, "Do not believe this background"
	endif
	Note $InpCv noteCv

	InpCv = "root:"+sParName+"_FXPDif"
	duplicate/O $sDif $InpCv

End

Function Panel_btnUndo_Click(ctrlName) : ButtonControl
	String ctrlName

	String  sCvPS = "root:Packages:FitXPS:gCvsParSet"
	String  prevPS = "root:Packages:FitXPS:PrevPS"
	
	if(waveexists($prevPS))
		Duplicate/O $prevPS $sCvPS
		Execute "Panel_btnView_Click(\"btnView\")"
	endif
End

Function Panel_btnClear_Click(ctrlName) : ButtonControl
	String ctrlName

	String  sCvPS = "root:Packages:FitXPS:gCvsParSet"
	String  prevPS = "root:Packages:FitXPS:PrevPS"
	Duplicate/O $sCVPS $prevPS
	
	Make/O/N=(12,6) $sCvPS
	Wave wCv = $sCvPS
	wCv = 0

	Variable idx
	wCv[10][0]=0.01
	for(idx=0;idx<6;idx+=1)
		wCv[3][idx]=0.3
		wCv[4][idx]=0.5
	endfor

	String trFit
	Variable nList
	trFit = TraceNameList("FitXPS", ";", 1+4)
	nList=FindListItem("Background_FXPS", trFit, ";")
	if(nList != -1) // if appended 
		RemoveFromGraph/Z/W=FitXPS Background_FXPS 
	endif

	nList=FindListItem("FittingSpect_FXPS", trFit, ";")
	if(nList != -1) // if appended 
		RemoveFromGraph/Z/W=FitXPS FittingSpect_FXPS 
	endif

	nList=FindListItem("DiffSpect_FXPS", trFit, ";")
	if(nList != -1) // if appended 
		RemoveFromGraph/Z/W=FitXPS DiffSpect_FXPS 
	endif

	String cmd
	for(idx=1; idx < 7; idx += 1)
		sprintf cmd, "CheckBox Chk_Curve%d, value=0", idx
		Execute cmd
		sprintf cmd, "Panel_ChkCurveN(\"Chk_Curve%d\", 0)", idx
		Execute cmd
	endfor

End

// generalized version
Function Panel_ChkCurveN(ctrlName, checked) : CheckBoxControl
	String ctrlName
	Variable checked // 1 if selected, 0 if not

	Variable CvN

	strswitch(ctrlName)
		case "Chk_Curve1":
			CvN=1
			break
		case "Chk_Curve2":
			CvN=2
			break
		case "Chk_Curve3":
			CvN=3
			break
		case "Chk_Curve4":
			CvN=4
			break
		case "Chk_Curve5":
			CvN=5
			break
		case "Chk_Curve6":
			CvN=6
			break
		default:
		
	endswitch
	
	String FitSpectrum="root:Packages:FitXPS:ExpSpect_FXPS"
	String Curve 
	sprintf Curve,  "root:Packages:FitXPS:Curve%d_FXPS", CvN
	String CvsPS = "root:Packages:FitXPS:gCvsParSet"
	Wave CvsParSet = $CvsPS
	CvsParSet[0][CvN-1] = checked

	String trFit, Cv_FXPS
	Variable nList
	sprintf Cv_FXPS, "Curve%d_FXPS", CvN
	trFit = TraceNameList("FitXPS", ";", 1+4)
	nList=FindListItem(Cv_FXPS, trFit, ";")

	if(checked)
		Curves_CalculateData(CvN)
		if(nList==-1) // if not yet appended 
			AppendToGraph/B/W=FitXPS $Curve
			if(CvN==1)
				ModifyGraph lStyle(Curve1_FXPS)=0, rgb(Curve1_FXPS)=(65535,0,0)
			elseif(CvN==2)
				ModifyGraph lStyle(Curve2_FXPS)=0, rgb(Curve2_FXPS)=(0,65535,0)
			elseif(CvN==3)
				ModifyGraph lStyle(Curve3_FXPS)=0, rgb(Curve3_FXPS)=(0,0,65535)
			elseif(CvN==4)
				ModifyGraph lStyle(Curve4_FXPS)=0, rgb(Curve4_FXPS)=(65535,35535,0)
			elseif(CvN==5)
				ModifyGraph lStyle(Curve5_FXPS)=0, rgb(Curve5_FXPS)=(0,65535,65535)
			elseif(CvN==6)
				ModifyGraph lStyle(Curve6_FXPS)=0, rgb(Curve6_FXPS)=(65535,0,65535)
			else
				print "Check Panel_ChkCurveN"
			endif
		endif
	else
		if(nList!=-1) // appended
			if(CvN==1)
				RemoveFromGraph/Z/W=FitXPS Curve1_FXPS
			elseif(CvN==2)
				RemoveFromGraph/Z/W=FitXPS Curve2_FXPS
			elseif(CvN==3)
				RemoveFromGraph/Z/W=FitXPS Curve3_FXPS
			elseif(CvN==4)
				RemoveFromGraph/Z/W=FitXPS Curve4_FXPS
			elseif(CvN==5)
				RemoveFromGraph/Z/W=FitXPS Curve5_FXPS
			elseif(CvN==6)
				RemoveFromGraph/Z/W=FitXPS Curve6_FXPS
			else
				print "Check Panel_ChkCurveN"
			endif
		endif
	endif
End

Function Panel_radioBG_Click(ctrlName, checked) : CheckBoxControl
	String ctrlName
	Variable checked // 1 if selected, 0 if not

	NVAR BGtype=root:Packages:FitXPS:gBGType
	
	strswitch (ctrlName)
		case "chkBGShirley":
			BGtype = 0
			CheckBox chkBGShirley, value = 1
			CheckBox chkBGTougaard, value = 0
			break
		case "chkBGTougaard":
			BGtype = 1
			CheckBox chkBGShirley, value = 0
			CheckBox chkBGTougaard, value = 1
			break
	endswitch
	
End

Function Panel_chkCsr_Click(ctrlName, checked): CheckBoxControl
	String ctrlName
	Variable checked // 1 if checked, 0 if not
	
	String ExpSpect="root:Packages:FitXPS:ExpSpect_FXPS"
	SVAR csrA = root:Packages:FitXPS:gCsrA
	SVAR csrB = root:Packages:FitXPS:gCsrB
	NVAR csrFlag = root:Packages:FitXPS:gUseCsrs
	Variable x_left, x_right

	if(WaveExists($ExpSpect)==0)
		return 0
	endif 
	
	x_left = pnt2x($ExpSpect, 0) 
	x_right = pnt2x($ExpSpect, Dimsize($ExpSpect,0))	
	if(checked==1)
		csrFlag = 1
		Cursor A ExpSpect_FXPS x_left + (x_right-x_left)*0.1
		Cursor B ExpSpect_FXPS x_left + (x_right-x_left)*0.9
	else
		csrFlag = 0
		Cursor/K A
		Cursor/K B
	endif
End

Function Panel_ChkPar(ctrlName, checked) : CheckBoxControl
	String ctrlName
	Variable checked // 1 if selected, 0 if not

	String sFPI = "root:Packages:FitXPS:gFitParIndex"
	Wave FPI = $sFPI
	
	strswitch(ctrlName)
// for curve 1
		case "chk1BE":
			FPI[1]=checked
			break
		case "chk1INT":
			FPI[2]=checked
			break
		case "chk1LW":
			FPI[3]=checked
			break
		case "chk1GW":
			FPI[4]=checked
			break
		case "chk1LSE":
			FPI[5]=checked
			break
		case "chk1LSI":
			FPI[6]=checked
			break
		case "chk1LSW":
			FPI[7]=checked
			break
		case "chk1ASY":
			FPI[8]=checked
			break
		case "chk1BGD":
			FPI[9]=checked
			break
		case "chk1BL":
			FPI[10]=checked
			break
// for curve 2
		case "chk2BE":
			FPI[12*1+1]=checked
			break
		case "chk2INT":
			FPI[12*1+2]=checked
			break
		case "chk2LW":
			FPI[12*1+3]=checked
			break
		case "chk2GW":
			FPI[12*1+4]=checked
			break
		case "chk2LSE":
			FPI[12*1+5]=checked
			break
		case "chk2LSI":
			FPI[12*1+6]=checked
			break
		case "chk2LSW":
			FPI[12*1+7]=checked
			break
		case "chk2ASY":
			FPI[12*1+8]=checked
			break
		case "chk2BGD":
			FPI[12*1+9]=checked
			break

// for curve 3
		case "chk3BE":
			FPI[12*2+1]=checked
			break
		case "chk3INT":
			FPI[12*2+2]=checked
			break
		case "chk3LW":
			FPI[12*2+3]=checked
			break
		case "chk3GW":
			FPI[12*2+4]=checked
			break
		case "chk3LSE":
			FPI[12*2+5]=checked
			break
		case "chk3LSI":
			FPI[12*2+6]=checked
			break
		case "chk3LSW":
			FPI[12*2+7]=checked
			break
		case "chk3ASY":
			FPI[12*2+8]=checked
			break
		case "chk3BGD":
			FPI[12*2+9]=checked
			break

// for curve 4
		case "chk4BE":
			FPI[12*3+1]=checked
			break
		case "chk4INT":
			FPI[12*3+2]=checked
			break
		case "chk4LW":
			FPI[12*3+3]=checked
			break
		case "chk4GW":
			FPI[12*3+4]=checked
			break
		case "chk4LSE":
			FPI[12*3+5]=checked
			break
		case "chk4LSI":
			FPI[12*3+6]=checked
			break
		case "chk4LSW":
			FPI[12*3+7]=checked
			break
		case "chk4ASY":
			FPI[12*3+8]=checked
			break
		case "chk4BGD":
			FPI[12*3+9]=checked
			break

// for curve 5
		case "chk5BE":
			FPI[12*4+1]=checked
			break
		case "chk5INT":
			FPI[12*4+2]=checked
			break
		case "chk5LW":
			FPI[12*4+3]=checked
			break
		case "chk5GW":
			FPI[12*4+4]=checked
			break
		case "chk5LSE":
			FPI[12*4+5]=checked
			break
		case "chk5LSI":
			FPI[12*4+6]=checked
			break
		case "chk5LSW":
			FPI[12*4+7]=checked
			break
		case "chk5ASY":
			FPI[12*4+8]=checked
			break
		case "chk5BGD":
			FPI[12*4+9]=checked
			break

// for curve 6
		case "chk6BE":
			FPI[12*5+1]=checked
			break
		case "chk6INT":
			FPI[12*5+2]=checked
			break
		case "chk6LW":
			FPI[12*5+3]=checked
			break
		case "chk6GW":
			FPI[12*5+4]=checked
			break
		case "chk6LSE":
			FPI[12*5+5]=checked
			break
		case "chk6LSI":
			FPI[12*5+6]=checked
			break
		case "chk6LSW":
			FPI[12*5+7]=checked
			break
		case "chk6ASY":
			FPI[12*5+8]=checked
			break
		case "chk6BGD":
			FPI[12*5+9]=checked
			break

		default:
			print "Something works abnormally in free fitting parameter check buttons."
			break
	endswitch
	
End


Function Panel_Curve_Change(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum // value of variable as number
	String varStr, varName // name of variable

// you can do something for every curve parameter as follows.		
//	if(cmpstr(ctrlName, "Curve1BE")==0)
//		Print "curve 1 BE\n"
//	elseif(cmpstr(ctrlName, "Curve1INT")==0)
//		Print "intensity\n"
//	elseif(cmpstr(ctrlName, "Curve1LW")==0)
//		Print "LW\n"
//	elseif(cmpstr(ctrlName, "Curve1GW")==0)
//		Print "GW\n"
//	elseif(cmpstr(ctrlName, "Curve1LSE")==0)
//		Print "LSE\n"
//	elseif(cmpstr(ctrlName, "Curve1LSI")==0)
//		Print "LSI\n"
//	elseif(cmpstr(ctrlName, "Curve1LSW")==0)
//		Print "LSW\n"
//	elseif(cmpstr(ctrlName, "Curve1ASY")==0)
//		Print "ASY\n"
//	elseif(cmpstr(ctrlName, "Curve1BGD")==0)
//		Print "BGD\n"
//	elseif(cmpstr(ctrlName, "Curve2BE")==0)
//		Print "curve 1 BE\n"
//	elseif(cmpstr(ctrlName, "Curve2INT")==0)
//		Print "intensity\n"
//	elseif(cmpstr(ctrlName, "Curve2LW")==0)
//		Print "LW\n"
//	elseif(cmpstr(ctrlName, "Curve2GW")==0)
//		Print "GW\n"
//	elseif(cmpstr(ctrlName, "Curve2LSE")==0)
//		Print "LSE\n"
//	elseif(cmpstr(ctrlName, "Curve2LSI")==0)
//		Print "LSI\n"
//	elseif(cmpstr(ctrlName, "Curve2LSW")==0)
//		Print "LSW\n"
//	elseif(cmpstr(ctrlName, "Curve2ASY")==0)
//		Print "ASY\n"
//	elseif(cmpstr(ctrlName, "Curve2BGD")==0)
//		Print "BGD\n"
//	endif
	
End

Function FitSpectrum_CalculateData()		
	SVAR sourcename = root:Packages:FitXPS:gSpectrum
	String ExpSpectrum="root:Packages:FitXPS:ExpSpect_FXPS"

	if(exists(sourcename)==1) // exp spectrum is selected.
		wave sourcewave = $sourcename
		
		Duplicate/O sourcewave tmpSpectrum		
		// normalization
		Variable Spect_min, Spect_Area
		Spect_min=WaveMin(tmpSpectrum)
		tmpSpectrum -= Spect_min
		Spect_Area = Area(tmpSpectrum)
		tmpSpectrum /= Spect_Area  // Area normalization
		tmpSpectrum += 0.01 // for initial base line.
		GuessBG(tmpSpectrum)
		Duplicate/O tmpSpectrum $ExpSpectrum
		Killwaves/z tmpSpectrum
	endif
End

Function Curves_CalculateData(cvN)	
	Variable cvN

	String FitSpectrum="root:Packages:FitXPS:ExpSpect_FXPS"
	if(WaveExists($FitSpectrum)==0)
		return 0
	endif
	Wave SpecWave = $FitSpectrum

	String Curve, Cv
	
	sprintf Curve, "root:Packages:FitXPS:Curve%d_FXPS", CvN
	if(WaveExists($Curve)==0)
		Make/N=(1) $Curve
	endif
	Cv="root:Packages:FitXPS:gCvsParset"
	Wave CvParSet = $Cv

	Variable BE = CvParSet[1][CvN-1]
	Variable INT = CvParSet[2][CvN-1]
	Variable LW =CvParSet[3][CvN-1]
	Variable GW =CvParSet[4][CvN-1]
	Variable LSE =CvParSet[5][CvN-1]
	Variable LSI =CvParSet[6][CvN-1]
	Variable LSW = CvParSet[7][CvN-1]
	Variable ASY = CvParSet[8][CvN-1]
	Variable BGD = CvParSet[9][CvN-1]

		
	duplicate/O SpecWave tmpLorSpect
	Note/K tmpLorSpect
	duplicate/O tmpLorSpect tmpGaussSpect
	duplicate/O tmpLorSpect tmpVoightSpect

	if(ASY==0)	
		tmpLorSpect[] = (INT/(PI*LW/2))*(LW/2)^2/((x-BE)^2+(LW/2)^2)
		tmpLorSpect[] +=  (INT*LSI/(PI*(LW+LSW)/2))*(LW/2+LSW/2)^2/((x-BE-LSE)^2+((LW+LSW)/2)^2)
	elseif(ASY > 0 && ASY < 1)
		tmpLorSpect[] = (INT*Gamma(1-ASY)/PI) * cos(PI*ASY/2 + (1-ASY)*atan((x-BE)/(LW/2)) ) / ((x-BE)^2+(LW/2)^2)^((1-ASY)/2)
		tmpLorSpect[] += (INT*LSI*Gamma(1-ASY)/PI) * cos(PI*ASY/2 + (1-ASY)*atan((x-BE-LSE)/((LW+LSW)/2)) ) / ((x-BE-LSE)^2+((LW+LSW)/2)^2)^((1-ASY)/2)
	else
		print "check ASY parameter!"
	endif	
	
	tmpGaussSpect =  Gauss(x, (rightx(tmpLorSpect)+leftx(tmpLorSpect))/2, GW/(2*sqrt(2)))
	MakeConvolution(tmpGaussSpect, tmpVoightSpect, tmpLorSpect, DimSize(tmpGaussSpect, 0))
			
	duplicate/O tmpVoightSpect $Curve
	killwaves/z tmpLorSpect, tmpGaussSpect, tmpVoightSpect
	
End


Function GuessBG(wtmpBG)
	Wave wtmpBG

	String CvsPS = "root:Packages:FitXPS:gCvsParSet"
	Wave CvsParSet = $CvsPS

	Variable b1, b2, SpectArea, idx, Ndata
	
	Ndata = Dimsize(wtmpBG, 0)
	if(Ndata < 11)
		print "Too few data point!"
		return 0;
	endif

	b1=0
	b2=0
	SpectArea=0	
	for(idx=0; idx < 5; idx += 1)
		b1 += wtmpBG[idx]
	endfor
	for( ; idx < Ndata-5; idx+=1)
		SpectArea += wtmpBG[idx]
	endfor
	for( ; idx < Ndata; idx+=1)
		b2 += wtmpBG[idx]
	endfor
	b1 /= 5.0
	b2 /= 5.0 // for base line.
	
	CvsParSet[9][0]= 100.0*(b1-b2)/(SpectArea-(b1+b2)/2 * (Ndata-10))
	CvsParSet[10][0]=b2
End


Function Background_CalculateData()
	NVAR BGtype = root:Packages:FitXPS:gBGType

	String ExpSpectrum="root:Packages:FitXPS:ExpSpect_FXPS"
	if(WaveExists($ExpSpectrum)==0)
		return 0
	endif
	Wave SpecWave = $ExpSpectrum

	Duplicate/O SpecWave tmpBGrd
	Note/K tmpBGrd

	String BGrd="root:Packages:FitXPS:Background_FXPS"
	if(waveexists($BGrd)==0)
		Make/N=(1) $BGrd
	endif
	Wave wBGrd=$BGrd
	duplicate/O tmpBGrd $BGrd

	String CvsPS = "root:Packages:FitXPS:gCvsParSet"
	Wave CvsParSet = $CvsPS

	wBGrd = 0
	
	Variable idx
	for(idx=0;idx<6;idx+=1)
		if(CvsParSet[0][idx]==1 && CvsParSet[9][idx]!=0) 
			String Cv
			sprintf Cv, "root:Packages:FitXPS:Curve%d_FXPS", idx+1
			if(WaveExists($Cv)!=0) // if curve N exists
				if(BGtype==0)
					Wave wCv = $Cv
					ShirleyBG(tmpBGrd, wCv, CvsParSet[9][idx])
					wBGrd += tmpBGrd
				elseif(BGtype==1)
					Wave wCv = $Cv
					TougaardBG(tmpBGrd, wCv, CvsParSet[9][idx])
					wBGrd += tmpBGrd
				else
					print "check gBGType variable!"
				endif
			endif
		endif
	endfor
	
	killwaves/z tmpBGrd
	
End


//=================================
// put Shirley type background in wBG.
//==================================
Function ShirleyBG(wBG, wSRC, IRatio)
	Wave wBG, wSRC
	Variable IRatio

	Variable idxB, scaleIR
	Variable IntensityBG=0
	
	scaleIR = IRatio/100.0
	
	for(idxB=DimSize(wSRC,0)-1; idxB>=0; idxB-=1)
		IntensityBG += wSRC[idxB]*scaleIR
		wBG[idxB]=IntensityBG
	endfor
End

//=================================
// put Tougaard type background in wBG.
// Tougaard parameter B=2866.0, C=1643.0
//==================================
Function TougaardBG(wBG, wSRC, IRatio)
	Wave wBG, wSRC
	Variable IRatio

	Variable idxB, idxS, TG_B=2866.0, TG_C=1643.0, Ndata, x_E, dE
	Variable IntensityBG=0
	
	Duplicate/O wSRC lossFtn
	
	TG_B *= IRatio
	Ndata = Dimsize(wSRC,0) 
	dE = deltax(wSRC)

	for(idxB=0; idxB<Ndata; idxB+=1)
		x_E=idxB*dE
		lossFtn[idxB]=TG_B*x_E/(TG_C+x_E^2)^2
	endfor
	
	for(idxB=0; idxB<Ndata; idxB+=1)
		wBG[idxB]=0
		for(idxS=idxB+1; idxS<Ndata; idxS+=1)
			wBG[idxB] += wSRC[idxS]*lossFtn[Ndata-idxS]		
		endfor
	endfor
	Killwaves/Z lossFtn
End

Function FittingCurve_CalculateData()	

	String ExpSpectrum="root:Packages:FitXPS:ExpSpect_FXPS"
	String FCv="root:Packages:FitXPS:FittingSpect_FXPS"
	if(WaveExists($ExpSpectrum)==0)
		return 0
	endif
	Wave SpecWave = $ExpSpectrum

	Duplicate/O SpecWave tmpFCv
	Note/K tmpFCv

	String BGrd="root:Packages:FitXPS:Background_FXPS"
	Wave wBG = $BGrd

	String sCvsPS="root:Packages:FitXPS:gCvsParSet"
	Wave CvsParSet = $sCvsPS

	tmpFCv = CvsParSet[10][0] +wBG // baseline+background

	Variable idx
	for(idx=0;idx<6;idx+=1)
		if(CvsParSet[0][idx]==1) 
			String Cv
			sprintf Cv, "root:Packages:FitXPS:Curve%d_FXPS", idx+1
			Wave wCv = $Cv
			tmpFCv += wCv
		endif
	endfor
	
	Duplicate/O tmpFCv $FCv
	killwaves/z tmpFCv

End

Function DiffCurve_CalculateData()	
	String ExpSpectrum="root:Packages:FitXPS:ExpSpect_FXPS"
	String FCv="root:Packages:FitXPS:FittingSpect_FXPS"
	String DCv="root:Packages:FitXPS:DiffSpect_FXPS"
	if(WaveExists($ExpSpectrum)==0)
		return 0
	endif
	if(WaveExists($FCv)==0)
		return 0
	endif
	Wave wSpect = $ExpSpectrum
	Wave wFCv = $FCv

	Duplicate/O wSpect tmpDCv
	Note/K tmpDCv
	
	tmpDCv -= wFCv

	Duplicate/O tmpDCv $DCv
	Killwaves/z tmpDCv

End

Function GetOnePointConvol(resp, src, i, N)
	Wave resp, src
	Variable i, N
	
	Variable con, k
	
	con = 0
	for(k=-trunc(N/2);k<N/2; k += 1)
		if ( i+k >= 0 & i+k < N )
			con += src[i+k]*resp[k+trunc(N/2)]
		endif
	endfor

	return con
End

Function MakeConvolution(resp, target, src, N)
	Wave resp, target, src
	Variable N
	
	Variable i, delta
	
	for(i=0; i < N; i+=1)
		target[i] = GetOnePointConvol(resp, src, i, N)
	endfor
	
	delta = deltax(target)
	if (delta < 0)
		delta = -delta
	endif
	target *= delta
End


// weighted Chisq = sum (w1_i-w2_i)^2/Var(w1_i)
Function wtChisq(w1, w2, wSsq)
	Wave w1, w2, wSsq

	SVAR csrA = root:Packages:FitXPS:gCsrA
	SVAR csrB = root:Packages:FitXPS:gCsrB
	NVAR csrFlag = root:Packages:FitXPS:gUseCsrs
	Variable cAp, cBp, startPnt, endPnt

	csrA = CsrInfo(A)
	csrB = CsrInfo(B)
	
	cAp = NumberbyKey("POINT",csrA)
	cBp = NumberbyKey("POINT",csrB)

	if(csrFlag==1 && cAp != NaN  && cBp != NaN)
		startPnt = min(cAp, cBp)
		endPnt = max(cAp, cBp)
	else
		startPnt=0
		endPnt=dimsize(w1,0)
	endif
	
	Variable idx, chi2

	if(dimsize(w1,0)!=dimsize(w2,0) || dimsize(w1,0)!=dimsize(wSsq,0))
		return -1
	endif

	for(idx=startPnt, chi2=0; idx < endPnt; idx += 1)
		chi2 += (w1[idx]-w2[idx])^2/wSsq[idx]
	endfor

	return chi2
End

// calculate chi^2 of w1 and w2
Function Chisq(w1, w2, mode)
	Wave w1, w2
	Variable mode

	SVAR csrA = root:Packages:FitXPS:gCsrA
	SVAR csrB = root:Packages:FitXPS:gCsrB
	NVAR csrFlag = root:Packages:FitXPS:gUseCsrs
	Variable cAp, cBp, startPnt, endPnt

	csrA = CsrInfo(A)
	csrB = CsrInfo(B)
	
	cAp = NumberbyKey("POINT",csrA)
	cBp = NumberbyKey("POINT",csrB)

	if(csrFlag==1 && cAp != NaN  && cBp != NaN)
		startPnt = min(cAp, cBp)
		endPnt = max(cAp, cBp)
	else
		startPnt=0
		endPnt=dimsize(w1,0)
	endif
	
	Variable idx, chi2

	if(dimsize(w1,0)!=dimsize(w2,0) )
		print "check Chisq function!"
		return -1
	endif
	
	if(mode==0)
		for(idx=startPnt, chi2=0; idx < endPnt; idx += 1)
			chi2 += (w1[idx]-w2[idx])^2
		endfor
	else // weighted Chisquare, make Var_x_i from w1
//		Make/O/N=(dimsize(w1,0)) sig_sq
		// make ad-hoc variance of Y_obs[x_i]
//		for(idx=0; idx<dimsize(w1,0); idx+=1)
//			if(idx==0 )
//				sig_sq[idx]=(w1[idx+1]+2*w1[idx])/3
//			elseif(idx==dimsize(w1,0)-1)
//				sig_sq[idx]=(w1[idx-1]+2*w1[idx])/3
//			else
//				sig_sq[idx]=(w1[idx-1]+w1[idx+1]+2*w1[idx])/4
//			endif
//		endfor

		for(idx=startPnt, chi2=0; idx < endPnt; idx += 1)
			chi2 += (w1[idx]-w2[idx])^2 
		endfor
	
	endif

	return chi2
End
